/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.standard.service;

import com.aliyun.dataworks.migrationx.domain.dataworks.standard.objects.Package;
import com.aliyun.dataworks.migrationx.domain.dataworks.standard.service.PackageFileService;
import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPackageFileService<T extends Package>
implements PackageFileService<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractPackageFileService.class);
    protected Locale locale;

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    protected abstract boolean isProjectRoot(File var1);

    protected File getPackageRoot(File unzippedDir) {
        if (unzippedDir.listFiles() == null) {
            return null;
        }
        Optional<File> root = Arrays.stream(Objects.requireNonNull(unzippedDir.listFiles())).filter(this::isProjectRoot).findAny();
        if (root.isPresent()) {
            File rootDir = root.get();
            boolean hasSibling = Arrays.stream(Objects.requireNonNull(rootDir.getParentFile().listFiles())).filter(sibling -> !sibling.equals(rootDir) && sibling.isDirectory()).filter(sibling -> sibling.listFiles() != null).anyMatch(sibling -> Arrays.stream(Objects.requireNonNull(sibling.listFiles())).anyMatch(this::isProjectRoot));
            return hasSibling ? rootDir.getParentFile() : unzippedDir;
        }
        for (File subdir : Objects.requireNonNull(unzippedDir.listFiles(File::isDirectory))) {
            File dirRoot = this.getPackageRoot(subdir);
            if (dirRoot == null) continue;
            return dirRoot;
        }
        return null;
    }
}

