/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3;

import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.ProcessDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.ProcessTaskRelation;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.ResourceComponent;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.UdfFunc;
import com.aliyun.migrationx.common.context.TransformerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.ListUtils;

public class DolphinSchedulerV3Context {
    private static DolphinSchedulerV3Context context;
    private List<Project> projects;
    private List<DataSource> dataSources;
    private List<ResourceComponent> resources;
    private List<UdfFunc> udfFuncs;
    private List<DagData> dagDatas;
    private Map<Long, Project> projectCodeMap = new HashMap<Long, Project>();
    private Map<Long, ProcessDefinition> processCodeMap = new HashMap<Long, ProcessDefinition>();
    private Map<Long, List<TaskDefinition>> processCodeTaskRelationMap = new HashMap<Long, List<TaskDefinition>>();
    private Map<Long, TaskDefinition> taskCodeMap = new HashMap<Long, TaskDefinition>();
    private Map<Long, List<String>> subProcessCodeOutMap = new HashMap<Long, List<String>>();
    private Map<Long, Object> subProcessCodeNodeMap = new HashMap<Long, Object>();
    private Map<Long, Object> subProcessCodeWorkflowMap = new HashMap<Long, Object>();
    private Map<Long, String> taskCodeNodeDataMap = new HashMap<Long, String>();
    private Map<Long, String> taskCodeNodeIdMap = new HashMap<Long, String>();
    private Map<Long, Object> taskCodeSpecNodeMap = new HashMap<Long, Object>();
    private Map<Object, List<Long>> specNodeProcessCodeMap = new HashMap<Object, List<Long>>();

    public Map<Long, Object> getTaskCodeSpecNodeMap() {
        return this.taskCodeSpecNodeMap;
    }

    private DolphinSchedulerV3Context() {
    }

    public static void initContext(List<Project> projects, List<DagData> dagDatas, List<DataSource> dataSources, List<ResourceComponent> resourceInfos, List<UdfFunc> udfFuncs) {
        DolphinSchedulerV3Context context = new DolphinSchedulerV3Context();
        context.projects = projects;
        context.dagDatas = dagDatas;
        context.dataSources = dataSources;
        context.resources = resourceInfos;
        context.udfFuncs = udfFuncs;
        context.taskCodeMap = new HashMap<Long, TaskDefinition>();
        for (Project project : ListUtils.emptyIfNull(projects)) {
            context.projectCodeMap.put(project.getCode(), project);
        }
        int totalTasks = 0;
        for (DagData dagData : ListUtils.emptyIfNull(dagDatas)) {
            ProcessDefinition definition = dagData.getProcessDefinition();
            Project project = context.getProjectCodeMap().get(definition.getProjectCode());
            String projectName = null;
            if (project != null) {
                projectName = project.getName();
            }
            if (definition.getProjectName() == null) {
                definition.setProjectName(projectName);
            }
            context.processCodeMap.put(definition.getCode(), definition);
            for (TaskDefinition taskDefinition : ListUtils.emptyIfNull(dagData.getTaskDefinitionList())) {
                ++totalTasks;
                if (taskDefinition.getProjectName() == null) {
                    taskDefinition.setProjectName(projectName);
                }
                context.taskCodeMap.put(taskDefinition.getCode(), taskDefinition);
            }
            for (ProcessTaskRelation relation : ListUtils.emptyIfNull(dagData.getProcessTaskRelationList())) {
                TaskDefinition taskDefinition;
                List<TaskDefinition> taskDefinitionList = context.processCodeTaskRelationMap.get(relation.getProcessDefinitionCode());
                if (taskDefinitionList == null) {
                    taskDefinitionList = new ArrayList<TaskDefinition>();
                    context.processCodeTaskRelationMap.put(relation.getProcessDefinitionCode(), taskDefinitionList);
                }
                if ((taskDefinition = context.taskCodeMap.get(relation.getPostTaskCode())) != null) {
                    taskDefinitionList.add(taskDefinition);
                    continue;
                }
                taskDefinition = context.taskCodeMap.get(relation.getPreTaskCode());
                if (taskDefinition == null) continue;
                taskDefinitionList.add(taskDefinition);
            }
        }
        TransformerContext.getCollector().setTotalTasks(totalTasks);
        DolphinSchedulerV3Context.context = context;
    }

    public static DolphinSchedulerV3Context getContext() {
        return context;
    }

    public Map<Long, Project> getProjectCodeMap() {
        return this.projectCodeMap;
    }

    public void setProjectCodeMap(Map<Long, Project> projectCodeMap) {
        this.projectCodeMap = projectCodeMap;
    }

    public Map<Long, ProcessDefinition> getProcessCodeMap() {
        return this.processCodeMap;
    }

    public void setProcessCodeMap(Map<Long, ProcessDefinition> processCodeMap) {
        this.processCodeMap = processCodeMap;
    }

    public List<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(List<Project> projects) {
        this.projects = projects;
    }

    public List<DataSource> getDataSources() {
        return this.dataSources;
    }

    public void setDataSources(List<DataSource> dataSources) {
        this.dataSources = dataSources;
    }

    public List<ResourceComponent> getResources() {
        return this.resources;
    }

    public void setResources(List<ResourceComponent> resources) {
        this.resources = resources;
    }

    public List<UdfFunc> getUdfFuncs() {
        return this.udfFuncs;
    }

    public void setUdfFuncs(List<UdfFunc> udfFuncs) {
        this.udfFuncs = udfFuncs;
    }

    public List<DagData> getDagDatas() {
        return this.dagDatas;
    }

    public void setDagDatas(List<DagData> dagDatas) {
        this.dagDatas = dagDatas;
    }

    public Map<Long, TaskDefinition> getTaskCodeMap() {
        return this.taskCodeMap;
    }

    public void setTaskCodeMap(Map<Long, TaskDefinition> taskCodeMap) {
        this.taskCodeMap = taskCodeMap;
    }

    public Map<Long, List<TaskDefinition>> getProcessCodeTaskRelationMap() {
        return this.processCodeTaskRelationMap;
    }

    public void setProcessCodeTaskRelationMap(Map<Long, List<TaskDefinition>> processCodeTaskRelationMap) {
        this.processCodeTaskRelationMap = processCodeTaskRelationMap;
    }

    public void putSubProcessCodeOutMap(Long code, String out) {
        List<String> outs = this.subProcessCodeOutMap.get(code);
        if (outs == null) {
            outs = new ArrayList<String>();
            this.subProcessCodeOutMap.put(code, outs);
        }
        outs.add(out);
    }

    public List<String> getSubProcessCodeMap(Long code) {
        return this.subProcessCodeOutMap.get(code);
    }

    public Map<Long, String> getTaskCodeNodeDataMap() {
        return this.taskCodeNodeDataMap;
    }

    public Map<Long, String> getTaskCodeNodeIdMap() {
        return this.taskCodeNodeIdMap;
    }

    public Map<Long, Object> getSubProcessCodeNodeMap() {
        return this.subProcessCodeNodeMap;
    }

    public Map<Long, Object> getSubProcessCodeWorkflowMap() {
        return this.subProcessCodeWorkflowMap;
    }

    public Map<Object, List<Long>> getSpecNodeProcessCodeMap() {
        return this.specNodeProcessCodeMap;
    }

    public void setSpecNodeProcessCodeMap(Map<Object, List<Long>> specNodeProcessCodeMap) {
        this.specNodeProcessCodeMap = specNodeProcessCodeMap;
    }
}

