/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource;

import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.BaseDataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.ClickHouseDataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.DB2ServerDataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.HiveDataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.MySQLDataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.OracleDataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.PostgreDataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.SQLServerDataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.SparkDataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.enums.DbType;
import com.aliyun.migrationx.common.utils.JSONUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceFactory {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceFactory.class);

    public static BaseDataSource getDatasource(String dbType, String parameter) {
        DbType type = DbType.ofType(dbType);
        if (type == null) {
            return null;
        }
        try {
            switch (type) {
                case MYSQL: {
                    return (BaseDataSource)JSONUtils.parseObject((String)parameter, MySQLDataSource.class);
                }
                case POSTGRESQL: {
                    return (BaseDataSource)JSONUtils.parseObject((String)parameter, PostgreDataSource.class);
                }
                case HIVE: {
                    return (BaseDataSource)JSONUtils.parseObject((String)parameter, HiveDataSource.class);
                }
                case SPARK: {
                    return (BaseDataSource)JSONUtils.parseObject((String)parameter, SparkDataSource.class);
                }
                case CLICKHOUSE: {
                    return (BaseDataSource)JSONUtils.parseObject((String)parameter, ClickHouseDataSource.class);
                }
                case ORACLE: {
                    return (BaseDataSource)JSONUtils.parseObject((String)parameter, OracleDataSource.class);
                }
                case SQLSERVER: {
                    return (BaseDataSource)JSONUtils.parseObject((String)parameter, SQLServerDataSource.class);
                }
                case DB2: {
                    return (BaseDataSource)JSONUtils.parseObject((String)parameter, DB2ServerDataSource.class);
                }
            }
            return null;
        }
        catch (Exception e) {
            logger.error("get datasource object error", (Throwable)e);
            return null;
        }
    }

    public static void loadClass(DbType dbType) throws Exception {
        switch (dbType) {
            case MYSQL: {
                Class.forName("com.mysql.jdbc.Driver");
                break;
            }
            case POSTGRESQL: {
                Class.forName("org.postgresql.Driver");
                break;
            }
            case HIVE: {
                Class.forName("org.apache.hive.jdbc.HiveDriver");
                break;
            }
            case SPARK: {
                Class.forName("org.apache.hive.jdbc.HiveDriver");
                break;
            }
            case CLICKHOUSE: {
                Class.forName("ru.yandex.clickhouse.ClickHouseDriver");
                break;
            }
            case ORACLE: {
                Class.forName("oracle.jdbc.driver.OracleDriver");
                break;
            }
            case SQLSERVER: {
                Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
                break;
            }
            case DB2: {
                Class.forName("com.ibm.db2.jcc.DB2Driver");
                break;
            }
            default: {
                logger.error("not support sql type: {},can't load class", (Object)dbType);
                throw new IllegalArgumentException("not support sql type,can't load class");
            }
        }
    }
}

