/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.utils;

import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.ProcessTaskRelation;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.v320.Location;
import com.aliyun.migrationx.common.utils.JSONUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.SetUtils;

public class LocationUtils {
    private LocationUtils() {
    }

    public static String buildLocations(List<ProcessTaskRelation> processTaskRelationList, int xStep, int yStep) {
        Map<Long, Set<Long>> prePostTaskMap = processTaskRelationList.stream().collect(Collectors.groupingBy(ProcessTaskRelation::getPreTaskCode, Collectors.mapping(ProcessTaskRelation::getPostTaskCode, Collectors.toSet())));
        Map<Long, Long> inDegreeMap = processTaskRelationList.stream().collect(Collectors.groupingBy(ProcessTaskRelation::getPostTaskCode, Collectors.counting()));
        List<Location> locationList = LocationUtils.buildLocationList(prePostTaskMap, inDegreeMap, xStep, yStep);
        return JSONUtils.toJsonString(locationList);
    }

    private static List<Location> buildLocationList(Map<Long, Set<Long>> prePostTaskMap, Map<Long, Long> inDegreeMap, int xStep, int yStep) {
        int x = 0;
        ArrayList<Location> locations = new ArrayList<Location>();
        ArrayDeque<Long> deque = new ArrayDeque<Long>(Collections.singletonList(0L));
        while (!deque.isEmpty()) {
            int size = deque.size();
            int y = 0;
            HashSet zeroInDegreeTaskNodeSet = new HashSet();
            for (int i = 0; i < size; ++i) {
                Long preTaskCode = (Long)deque.poll();
                Set<Long> postTaskCodeSet = prePostTaskMap.get(preTaskCode);
                SetUtils.emptyIfNull(postTaskCodeSet).forEach(postTaskCode -> {
                    if (LocationUtils.subAndRemoveZeroValue(inDegreeMap, postTaskCode)) {
                        zeroInDegreeTaskNodeSet.add(postTaskCode);
                    }
                });
                if (Objects.isNull(preTaskCode) || preTaskCode == 0L) continue;
                locations.add(new Location(preTaskCode, x, y += yStep));
            }
            deque.addAll(zeroInDegreeTaskNodeSet);
            zeroInDegreeTaskNodeSet.forEach(inDegreeMap::remove);
            x += xStep;
        }
        return locations;
    }

    private static boolean subAndRemoveZeroValue(Map<Long, Long> inDegreeMap, Long taskCode) {
        Long inDegree = inDegreeMap.get(taskCode);
        if (Objects.isNull(inDegree)) {
            return false;
        }
        if (inDegree == 1L) {
            inDegreeMap.remove(taskCode);
            return true;
        }
        inDegreeMap.put(taskCode, inDegree - 1L);
        return false;
    }
}

