/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.propertydescriptor;

import com.github.dozermapper.core.MappingException;
import com.github.dozermapper.core.config.BeanContainer;
import com.github.dozermapper.core.factory.BeanCreationDirective;
import com.github.dozermapper.core.factory.DestBeanCreator;
import com.github.dozermapper.core.fieldmap.FieldMap;
import com.github.dozermapper.core.fieldmap.HintContainer;
import com.github.dozermapper.core.propertydescriptor.AbstractPropertyDescriptor;
import com.github.dozermapper.core.propertydescriptor.DeepHierarchyElement;
import com.github.dozermapper.core.util.BridgedMethodFinder;
import com.github.dozermapper.core.util.CollectionUtils;
import com.github.dozermapper.core.util.MappingUtils;
import com.github.dozermapper.core.util.ReflectionUtils;
import com.github.dozermapper.core.util.TypeResolver;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GetterSetterPropertyDescriptor
extends AbstractPropertyDescriptor {
    private final Logger log = LoggerFactory.getLogger(GetterSetterPropertyDescriptor.class);
    private Class<?> propertyType;
    protected final BeanContainer beanContainer;
    protected final DestBeanCreator destBeanCreator;

    public GetterSetterPropertyDescriptor(Class<?> clazz, String fieldName, boolean isIndexed, int index, HintContainer srcDeepIndexHintContainer, HintContainer destDeepIndexHintContainer, BeanContainer beanContainer, DestBeanCreator destBeanCreator) {
        super(clazz, fieldName, isIndexed, index, srcDeepIndexHintContainer, destDeepIndexHintContainer);
        this.beanContainer = beanContainer;
        this.destBeanCreator = destBeanCreator;
    }

    protected abstract Method getWriteMethod() throws NoSuchMethodException;

    protected abstract Method getReadMethod() throws NoSuchMethodException;

    protected abstract String getSetMethodName() throws NoSuchMethodException;

    protected abstract boolean isCustomSetMethod();

    public Class<?> getWriteMethodPropertyType() {
        try {
            return this.getWriteMethod().getParameterTypes()[0];
        }
        catch (Exception e) {
            MappingUtils.throwMappingException(e);
            return null;
        }
    }

    @Override
    public Class<?> getPropertyType() {
        if (this.propertyType == null) {
            this.propertyType = this.determinePropertyType();
        }
        return this.propertyType;
    }

    @Override
    public Object getPropertyValue(Object bean) {
        Object result;
        if (MappingUtils.isDeepMapping(this.fieldName)) {
            result = this.getDeepSrcFieldValue(bean);
        } else {
            result = this.invokeReadMethod(bean);
            if (this.isIndexed) {
                result = MappingUtils.getIndexedValue(result, this.index);
            }
        }
        return result;
    }

    @Override
    public void setPropertyValue(Object bean, Object value, FieldMap fieldMap) {
        if (MappingUtils.isDeepMapping(this.fieldName)) {
            this.writeDeepDestinationValue(bean, value, fieldMap);
        } else if (!this.getPropertyType().isPrimitive() || value != null) {
            if (this.isIndexed) {
                this.writeIndexedValue(bean, value);
            } else {
                try {
                    if (this.getPropertyValue(bean) == value && !this.isIndexed) {
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.invokeWriteMethod(bean, value);
            }
        }
    }

    private Object getDeepSrcFieldValue(Object srcObj) {
        Object parentObj;
        Object hierarchyValue = parentObj = srcObj;
        for (DeepHierarchyElement hierarchyElement : this.getDeepFieldHierarchy(srcObj, this.srcDeepIndexHintContainer)) {
            PropertyDescriptor pd = hierarchyElement.getPropDescriptor();
            hierarchyValue = hierarchyElement.getIndex() > -1 ? MappingUtils.getIndexedValue(ReflectionUtils.invoke(pd.getReadMethod(), hierarchyValue, null), hierarchyElement.getIndex()) : ReflectionUtils.invoke(pd.getReadMethod(), parentObj, null);
            parentObj = hierarchyValue;
            if (hierarchyValue == null) break;
        }
        if (this.isIndexed) {
            hierarchyValue = MappingUtils.getIndexedValue(hierarchyValue, this.index);
        }
        return hierarchyValue;
    }

    protected void writeDeepDestinationValue(Object destObj, Object destFieldValue, FieldMap fieldMap) {
        DeepHierarchyElement[] hierarchy = this.getDeepFieldHierarchy(destObj, fieldMap.getDestDeepIndexHintContainer());
        Object parentObj = destObj;
        int hierarchyLength = hierarchy.length - 1;
        int hintIndex = 0;
        for (int i = 0; i < hierarchyLength; ++i) {
            int currentSize;
            Class<?> collectionEntryType;
            DeepHierarchyElement hierarchyElement = hierarchy[i];
            PropertyDescriptor pd = hierarchyElement.getPropDescriptor();
            Object value = ReflectionUtils.invoke(pd.getReadMethod(), parentObj, null);
            if (value == null) {
                Class<?> clazz = pd.getPropertyType();
                if (clazz.isInterface() && i + 1 == hierarchyLength && fieldMap.getDestHintContainer() != null) {
                    clazz = fieldMap.getDestHintContainer().getHint();
                }
                Object o = null;
                if (clazz.isArray()) {
                    o = MappingUtils.prepareIndexedCollection(clazz, null, this.destBeanCreator.create(clazz.getComponentType()), hierarchyElement.getIndex());
                } else if (Collection.class.isAssignableFrom(clazz)) {
                    Class<?> genericType = ReflectionUtils.determineGenericsType(parentObj.getClass(), pd);
                    if (genericType != null) {
                        collectionEntryType = genericType;
                    } else {
                        collectionEntryType = fieldMap.getDestDeepIndexHintContainer().getHint(hintIndex);
                        ++hintIndex;
                    }
                    o = MappingUtils.prepareIndexedCollection(clazz, null, this.destBeanCreator.create(collectionEntryType), hierarchyElement.getIndex());
                } else {
                    try {
                        o = this.destBeanCreator.create(clazz);
                    }
                    catch (Exception e) {
                        if (fieldMap.getClassMap().getDestClassBeanFactory() != null) {
                            o = this.destBeanCreator.create(new BeanCreationDirective(null, fieldMap.getClassMap().getSrcClassToMap(), clazz, clazz, fieldMap.getClassMap().getDestClassBeanFactory(), fieldMap.getClassMap().getDestClassBeanFactoryId(), null, null));
                        }
                        MappingUtils.throwMappingException(e);
                    }
                }
                ReflectionUtils.invoke(pd.getWriteMethod(), parentObj, new Object[]{o});
                value = ReflectionUtils.invoke(pd.getReadMethod(), parentObj, null);
            }
            if (MappingUtils.isSupportedCollection(value.getClass()) && (currentSize = CollectionUtils.getLengthOfCollection(value)) < hierarchyElement.getIndex() + 1) {
                collectionEntryType = pd.getPropertyType().getComponentType();
                if (collectionEntryType == null && (collectionEntryType = ReflectionUtils.determineGenericsType(parentObj.getClass(), pd)) == null) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn(this.fieldName + " is in a Collection with an unspecified type.");
                    }
                    if (this.destDeepIndexHintContainer != null && this.destDeepIndexHintContainer.getHints() != null && this.destDeepIndexHintContainer.getHints().size() > 0) {
                        collectionEntryType = this.destDeepIndexHintContainer.getHints().get(0);
                        if (this.log.isWarnEnabled()) {
                            this.log.warn("Using deep-index-hint to predict containing Collection type for field " + this.fieldName + " to be " + collectionEntryType);
                        }
                    }
                }
                value = MappingUtils.prepareIndexedCollection(pd.getPropertyType(), value, this.destBeanCreator.create(collectionEntryType), hierarchyElement.getIndex());
                ReflectionUtils.invoke(pd.getWriteMethod(), parentObj, new Object[]{value});
            }
            parentObj = value != null && value.getClass().isArray() ? Array.get(value, hierarchyElement.getIndex()) : (value != null && Collection.class.isAssignableFrom(value.getClass()) ? MappingUtils.getIndexedValue(value, hierarchyElement.getIndex()) : value);
        }
        PropertyDescriptor pd = hierarchy[hierarchy.length - 1].getPropDescriptor();
        Class<?> type = pd.getReadMethod() != null ? pd.getReadMethod().getReturnType() : pd.getWriteMethod().getParameterTypes()[0];
        if (!type.isPrimitive() || destFieldValue != null) {
            if (!this.isIndexed) {
                Method method = null;
                if (!this.isCustomSetMethod()) {
                    method = pd.getWriteMethod();
                } else {
                    try {
                        method = ReflectionUtils.findAMethod(parentObj.getClass(), this.getSetMethodName(), this.beanContainer);
                    }
                    catch (NoSuchMethodException e) {
                        MappingUtils.throwMappingException(e);
                    }
                }
                ReflectionUtils.invoke(method, parentObj, new Object[]{destFieldValue});
            } else {
                this.writeIndexedValue(parentObj, destFieldValue);
            }
        }
    }

    protected Object invokeReadMethod(Object target) {
        Object result = null;
        try {
            result = ReflectionUtils.invoke(this.getReadMethod(), target, null);
        }
        catch (NoSuchMethodException e) {
            MappingUtils.throwMappingException(e);
        }
        return result;
    }

    protected void invokeWriteMethod(Object target, Object value) {
        try {
            ReflectionUtils.invoke(this.getWriteMethod(), target, new Object[]{value});
        }
        catch (NoSuchMethodException e) {
            MappingUtils.throwMappingException(e);
        }
    }

    private DeepHierarchyElement[] getDeepFieldHierarchy(Object obj, HintContainer deepIndexHintContainer) {
        return ReflectionUtils.getDeepFieldHierarchy(obj.getClass(), this.fieldName, deepIndexHintContainer);
    }

    private void writeIndexedValue(Object destObj, Object destFieldValue) {
        Object existingValue = this.invokeReadMethod(destObj);
        Object indexedValue = MappingUtils.prepareIndexedCollection(this.getPropertyType(), existingValue, destFieldValue, this.index);
        this.invokeWriteMethod(destObj, indexedValue);
    }

    private Class determinePropertyType() {
        Method readMethod = this.getBridgedReadMethod();
        Method writeMethod = this.getBridgedWriteMethod();
        Class<?> returnType = null;
        try {
            returnType = TypeResolver.resolvePropertyType(this.clazz, readMethod, writeMethod);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (returnType != null) {
            return returnType;
        }
        if (readMethod == null && writeMethod == null) {
            throw new MappingException("No read or write method found for field (" + this.fieldName + ") in class (" + this.clazz + ")");
        }
        if (readMethod == null) {
            return this.determineByWriteMethod(writeMethod);
        }
        try {
            return readMethod.getReturnType();
        }
        catch (Exception e) {
            return this.determineByWriteMethod(writeMethod);
        }
    }

    private Class determineByWriteMethod(Method writeMethod) {
        try {
            return writeMethod.getParameterTypes()[0];
        }
        catch (Exception e) {
            throw new MappingException(e);
        }
    }

    private Method getBridgedReadMethod() {
        try {
            return BridgedMethodFinder.findMethod(this.getReadMethod(), this.clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Method getBridgedWriteMethod() {
        try {
            return BridgedMethodFinder.findMethod(this.getWriteMethod(), this.clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Class<?> genericType() {
        Class<?> genericType = null;
        try {
            Method method = this.getWriteMethod();
            genericType = ReflectionUtils.determineGenericsType(this.clazz, method, false);
        }
        catch (NoSuchMethodException e) {
            this.log.warn("The destination object: {} does not have a write method for property : {}", (Throwable)e);
        }
        return genericType;
    }
}

