/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.el;

import com.github.dozermapper.core.util.MappingUtils;
import javax.el.ExpressionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ELExpressionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ELExpressionFactory.class);
    private static Boolean isJavaxEL;

    private ELExpressionFactory() {
    }

    public static Boolean isSupported() {
        return ELExpressionFactory.isSupported(ELExpressionFactory.class.getClassLoader());
    }

    public static Boolean isSupported(ClassLoader classLoader) {
        if (isJavaxEL == null) {
            try {
                isJavaxEL = ELExpressionFactory.newInstance(classLoader) != null;
                LOG.info("javax.el support is {}", (Object)isJavaxEL);
            }
            catch (IllegalStateException ex) {
                LOG.warn("javax.el is not supported; {}", (Object)ex.getMessage());
                isJavaxEL = false;
            }
        }
        return isJavaxEL;
    }

    public static ExpressionFactory newInstance(ClassLoader classLoader) throws IllegalStateException {
        ELExpressionFactory.resolveClassForName();
        return ELExpressionFactory.resolveViaClassLoaderOrTCCL(classLoader);
    }

    private static void resolveClassForName() throws IllegalStateException {
        String expressionFactoryProperty = System.getProperty("javax.el.ExpressionFactory");
        String expressionFactoryClass = MappingUtils.isBlankOrNull(expressionFactoryProperty) ? "com.sun.el.ExpressionFactoryImpl" : expressionFactoryProperty;
        try {
            Class.forName(expressionFactoryClass);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Failed to resolve ExpressionFactory, " + ex.getMessage(), ex);
        }
    }

    private static ExpressionFactory resolveViaClassLoaderOrTCCL(ClassLoader classLoader) {
        ExpressionFactory answer;
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader newTccl = classLoader == null ? tccl : classLoader;
            Thread.currentThread().setContextClassLoader(newTccl);
            answer = ELExpressionFactory.newInstance();
        }
        catch (ClassCastException ex) {
            throw new IllegalStateException("Failed to resolve ExpressionFactory, " + ex.getMessage(), ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        return answer;
    }

    public static ExpressionFactory newInstance() {
        return ExpressionFactory.newInstance();
    }
}

