/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.rapt.commons.circuitbreaker;

import com.aliyun.rapt.commons.circuitbreaker.CircuitBreakEventListener;
import com.aliyun.rapt.commons.circuitbreaker.CircuitBreaker;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractCircuitBreaker<T>
implements CircuitBreaker<T> {
    public static final String PROPERTY_NAME = "open";
    protected final AtomicReference<State> state = new AtomicReference<State>(State.CLOSED);
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private CircuitBreakEventListener listener;

    @Override
    public boolean isOpen() {
        return AbstractCircuitBreaker.isOpen(this.state.get());
    }

    @Override
    public boolean isClosed() {
        return !this.isOpen();
    }

    @Override
    public abstract boolean checkState();

    @Override
    public abstract boolean incrementAndCheckState(T var1);

    public void close0() {
        this.changeState(State.CLOSED);
    }

    public void open0() {
        this.changeState(State.OPEN);
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.close0();
        this.sendChangeNotify();
    }

    @Override
    public void open() {
        if (this.isOpen()) {
            return;
        }
        this.open0();
        this.sendChangeNotify();
    }

    private void sendChangeNotify() {
        if (this.listener == null) {
            return;
        }
        this.listener.statusChanged(this.checkState());
    }

    protected static boolean isOpen(State state) {
        return state == State.OPEN;
    }

    protected void changeState(State newState) {
        if (this.state.compareAndSet(newState.oppositeState(), newState)) {
            this.changeSupport.firePropertyChange(PROPERTY_NAME, !AbstractCircuitBreaker.isOpen(newState), AbstractCircuitBreaker.isOpen(newState));
            this.sendChangeNotify();
        }
    }

    public void addChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removeChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void setEventListener(CircuitBreakEventListener circuitBreakEventListener) {
        this.listener = circuitBreakEventListener;
    }

    @Override
    public void shutdown() {
    }

    protected static enum State {
        CLOSED{

            @Override
            public State oppositeState() {
                return OPEN;
            }
        }
        ,
        OPEN{

            @Override
            public State oppositeState() {
                return CLOSED;
            }
        };


        public abstract State oppositeState();
    }
}

