/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.dbr.reader.client;

import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.dbr.spec.DbrJob;
import com.aliyun.migration.dbr.spec.ExportWorkspaceRequest;
import com.aliyun.migration.dbr.spec.ExportWorkspaceResp;
import com.aliyun.migration.dbr.spec.ListJobRequest;
import com.aliyun.migration.dbr.spec.ListJobsResp;
import com.aliyun.migration.workflow.migration.common.bean.HttpClientRes;
import com.aliyun.migration.workflow.migration.common.bean.HttpMethodEnum;
import com.aliyun.migration.workflow.migration.common.bean.LogLevel;
import com.aliyun.migration.workflow.migration.common.utils.Base64Tool;
import com.aliyun.migration.workflow.migration.common.utils.BwmHttpClientUtil;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migration.workflow.migration.common.utils.client.AbstractHttpClient;
import com.cronutils.utils.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DbrClient
extends AbstractHttpClient {
    private static final Logger log = LoggerFactory.getLogger(DbrClient.class);
    private final String LIST_JOBS_URL = "/api/2.2/jobs/list";
    private final String EXPORT_WORKSPACE_URL = "/api/2.0/workspace/export";
    private final String PIPELINE_URL = "/api/2.0/pipelines/%s";
    private String endpoint;
    private String token;

    public DbrClient(String endpoint, String token) {
        this.endpoint = endpoint;
        this.token = token;
    }

    public void listAllJobs(List<DbrJob> res, String nextPageToken) {
        ListJobsResp listJobsResp = this.listJobsSingle(nextPageToken);
        if (Objects.isNull(listJobsResp)) {
            return;
        }
        List jobs = listJobsResp.getJobs();
        if (CollectionUtils.isNotEmpty((Collection)jobs)) {
            res.addAll(jobs);
        }
        if (StringUtils.isEmpty((CharSequence)(nextPageToken = listJobsResp.getNextPageToken()))) {
            return;
        }
        this.listAllJobs(res, nextPageToken);
    }

    public ListJobsResp listJobsSingle(String nextPageToken) {
        String url = this.endpoint + "/api/2.2/jobs/list";
        ListJobRequest request = ListJobRequest.builder().build();
        request.setExpandTasks(Boolean.TRUE);
        request.setLimit(Integer.valueOf(20));
        if (!StringUtils.isEmpty((CharSequence)nextPageToken)) {
            request.setPageToken(nextPageToken);
        }
        Map reqMap = BwmJsonUtil.parseMapWithAnnotation((Object)request);
        String reqContent = BwmJsonUtil.toJsonString((Object)reqMap);
        log.info("****** list job get request: {}, url : {}", (Object)reqContent, (Object)url);
        String result = this.execHttp(header -> {
            header.put("Authorization", this.token);
            HttpClientRes httpClientRes = BwmHttpClientUtil.httpRequest((HttpMethodEnum)HttpMethodEnum.GET, (String)url, (String)reqContent, (Map)header, (LogLevel)LogLevel.info);
            return this.parseRep(httpClientRes);
        });
        return (ListJobsResp)BwmJsonUtil.parseObjectWithAnnotation((String)result, ListJobsResp.class);
    }

    public String exportWorkspace(String path) {
        String url = this.endpoint + "/api/2.0/workspace/export";
        ExportWorkspaceRequest sourceReq = ExportWorkspaceRequest.builder().path(path).format("SOURCE").build();
        Map reqMap = BwmJsonUtil.parseMapWithAnnotation((Object)sourceReq);
        String reqContent = BwmJsonUtil.toJsonString((Object)reqMap);
        log.info("****** export workflow file get request: {}, url : {}", (Object)reqContent, (Object)url);
        String result = this.execHttp(header -> {
            header.put("Authorization", this.token);
            HttpClientRes httpClientRes = BwmHttpClientUtil.httpRequest((HttpMethodEnum)HttpMethodEnum.GET, (String)url, (String)reqContent, (Map)header, (LogLevel)LogLevel.info);
            return this.parseRep(httpClientRes);
        });
        ExportWorkspaceResp exportWorkspaceResp = (ExportWorkspaceResp)BwmJsonUtil.parseObjectWithAnnotation((String)result, ExportWorkspaceResp.class);
        String content = exportWorkspaceResp.getContent();
        if (!StringUtils.isEmpty((CharSequence)content)) {
            return Base64Tool.decode((String)content);
        }
        return result;
    }

    private String parseRep(HttpClientRes httpClientRes) {
        if (Objects.isNull(httpClientRes)) {
            log.error("http call failed,err message: {}", (Object)httpClientRes);
            return null;
        }
        if (Boolean.TRUE.equals(httpClientRes.isOk())) {
            return httpClientRes.getResponseBody();
        }
        log.error("http call failed,err message: {}", (Object)httpClientRes);
        throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.DBR_SERVER_CALL_FAILED, (String)httpClientRes.getResponseBody());
    }
}

