/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.client;

import com.aliyun.credentials.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemProp {
    private static final Logger log = LoggerFactory.getLogger(SystemProp.class);
    private static final String CONF = "conf/app.properties";
    private static final Properties PROP = new Properties();

    public static void load(String file, Properties properties) {
        try (InputStream in = SystemProp.class.getClassLoader().getResourceAsStream(file);){
            if (in == null) {
                throw new IOException("\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25\uff1a" + file);
            }
            properties.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getValue(String key) {
        return PROP.getProperty(key);
    }

    public static String getValue(String key, String defaultValue) {
        String value = PROP.getProperty(key);
        if (value == null) {
            return null;
        }
        return StringUtils.isEmpty((CharSequence)key) ? defaultValue : value;
    }

    public static int getValue(String key, int defaultValue) {
        String value = PROP.getProperty(key);
        if (NumberUtils.isDigits((String)value)) {
            return NumberUtils.createInteger((String)value);
        }
        return StringUtils.isEmpty((CharSequence)key) ? defaultValue : 0;
    }

    public static long getValue(String key, long defaultValue) {
        String value = PROP.getProperty(key);
        if (NumberUtils.isDigits((String)value)) {
            return NumberUtils.createLong((String)value);
        }
        return StringUtils.isEmpty((CharSequence)key) ? defaultValue : 0L;
    }

    static {
        try {
            SystemProp.load(CONF, PROP);
        }
        catch (Exception e) {
            log.error("load properties error", (Throwable)e);
        }
    }
}

