/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.client;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.client.Command;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageFileOperator;
import com.aliyun.migration.workflow.migration.dw.migration.supervisor.common.SupervisorTaskContext;
import com.aliyun.migration.workflow.migration.dw.migration.supervisor.module.DwMigrationSupervisor;
import com.google.common.base.Charsets;
import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationSupervisorCommand
extends Command {
    private static final Logger log = LoggerFactory.getLogger(MigrationSupervisorCommand.class);

    public MigrationSupervisorCommand() {
        this.addOption();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exec(String[] args) {
        System.setProperty("file.encoding", "zh_CN.UTF-8");
        try {
            CommandLine cmd = this.parse.parse(this.options, args);
            if (cmd.hasOption("help")) {
                this.usage();
                return;
            }
            String configStr = BwmPackageFileOperator.JsonType.JSON_TYPE.value;
            if (cmd.hasOption("c")) {
                String configPath = cmd.getOptionValue("c");
                File file = new File(configPath);
                if (file.exists()) {
                    configStr = FileUtils.readFileToString((File)file, (String)Charsets.UTF_8.name());
                } else {
                    log.error("config file path not exists {}", (Object)configPath);
                }
            }
            JSONObject Configuration = JSONObject.parseObject((String)configStr);
            SupervisorTaskContext taskContext = SupervisorTaskContext.builder().readPkgPath(Configuration.getString("reader.output.package.path")).convertPkgPath(Configuration.getString("convert.output.package.path")).writePkgPath(Configuration.getString("write.output.package.path")).dataworksPkgPath(Configuration.getString("dataworks.export.package.path")).outputQRCodePath(Configuration.getString("statistics.qrcode.output.path")).outputJsonPath(Configuration.getString("statistics.json.output.path")).build();
            DwMigrationSupervisor dwMigrationSupervisor = new DwMigrationSupervisor();
            dwMigrationSupervisor.init(taskContext);
            dwMigrationSupervisor.root();
            dwMigrationSupervisor.close();
        }
        catch (Exception e) {
            log.error("exec error\uff0c", (Throwable)e);
            this.usage();
            System.exit(1);
        }
        finally {
            log.info("exec finished!");
        }
        System.exit(0);
    }

    @Override
    public TaskContext getTaskContext(CommandLine cmd) throws Exception {
        return null;
    }

    @Override
    public void getPlugin(TaskContext taskContext) throws Exception {
    }

    @Override
    public void execLocal(TaskContext taskContext) throws Exception {
    }

    @Override
    public void execSaas(TaskContext taskContext) throws Exception {
    }

    @Override
    public void closePlugin() {
    }

    @Override
    public void addOption() {
        this.options.addOption(Option.builder((String)"c").argName("conf").hasArg().desc("\u914d\u7f6e\u6587\u4ef6").required(true).build());
    }

    @Override
    public String getName() {
        return "supervisor";
    }

    @Override
    public String desc() {
        return "\u8fc1\u79fb\u6307\u6807\u751f\u6210";
    }
}

