/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.client;

import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.plugin.Converter;
import com.aliyun.migration.api.plugin.Reader;
import com.aliyun.migration.api.plugin.Writer;
import com.aliyun.migration.client.Command;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageFileOperator;
import com.aliyun.migration.workflow.migration.common.spi.PluginHandler;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Charsets;
import java.io.File;
import java.util.Optional;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationCommand
extends Command {
    private static final Logger log = LoggerFactory.getLogger(MigrationCommand.class);

    public MigrationCommand() {
        this.addOption();
    }

    @Override
    public void exec(String[] args) throws Exception {
        CommandLine cmd = this.parse.parse(this.options, args);
        if (cmd.hasOption("help")) {
            this.usage();
            return;
        }
        String configStr = BwmPackageFileOperator.JsonType.JSON_TYPE.value;
        if (cmd.hasOption("c")) {
            String configPath = cmd.getOptionValue("c");
            File file = new File(configPath);
            if (file.exists()) {
                configStr = FileUtils.readFileToString((File)file, (String)Charsets.UTF_8.name());
            } else {
                log.error("config file path not exists {}", (Object)configPath);
            }
        }
        BwmConfiguration bwmConfiguration = BwmConfiguration.from((String)configStr);
        BwmConfiguration readerConf = bwmConfiguration.getConfiguration("reader");
        BwmConfiguration transformerConf = bwmConfiguration.getConfiguration("transformer");
        BwmConfiguration writerConf = bwmConfiguration.getConfiguration("writer");
        String readerName = readerConf.getString("name");
        String sourceScheduleDatasource = readerConf.getString("schedule_datasource");
        Datasource srcDatasource = (Datasource)GsonUtils.fromJsonString((String)sourceScheduleDatasource, Datasource.class);
        Reader reader = PluginHandler.getReader((String)readerName);
        TaskContext taskContext = new TaskContext();
        taskContext.setReaderDatasource(srcDatasource);
        taskContext.setReaderName(readerName);
        taskContext.setBwmConfiguration(readerConf.getString("conf"));
        reader.init(taskContext);
        WorkflowProjectPackage workflowProjectPackage = reader.read();
        String writerName = writerConf.getString("name");
        String tgtScheduleDatasourceStr = writerConf.getString("schedule_datasource");
        Datasource tgtDatasource = (Datasource)GsonUtils.fromJsonString((String)tgtScheduleDatasourceStr, Datasource.class);
        String transformName = transformerConf.getString("name");
        Converter converter = PluginHandler.getConverter((String)transformName);
        TaskContext transTaskContext = new TaskContext();
        transTaskContext.setBwmConfiguration(transformerConf.toJSON());
        transTaskContext.setReaderDatasource(srcDatasource);
        transTaskContext.setWriterDatasource(tgtDatasource);
        transTaskContext.setConverterName(transformName);
        transTaskContext.setWorkflowProjectPackage(workflowProjectPackage);
        converter.init(transTaskContext);
        WorkflowProjectPackage convertPackage = converter.convert();
        Writer writer = PluginHandler.getWriter((String)writerName);
        TaskContext writerTaskContext = new TaskContext();
        writerTaskContext.setBwmConfiguration(writerConf.getString("conf"));
        writerTaskContext.setWriterDatasource(tgtDatasource);
        writerTaskContext.setWriterName(writerName);
        writerTaskContext.setWorkflowProjectPackage(convertPackage);
        writer.init(writerTaskContext);
        writer.write();
        this.close(reader, converter, writer);
    }

    @Override
    public TaskContext getTaskContext(CommandLine cmd) throws Exception {
        return null;
    }

    @Override
    public void getPlugin(TaskContext taskContext) throws Exception {
    }

    @Override
    public void execLocal(TaskContext taskContext) throws Exception {
    }

    @Override
    public void execSaas(TaskContext taskContext) throws Exception {
    }

    @Override
    public void closePlugin() {
    }

    private void close(Reader reader, Converter converter, Writer writer) {
        Optional.ofNullable(reader).ifPresent(Reader::close);
        Optional.ofNullable(converter).ifPresent(Converter::close);
        Optional.ofNullable(writer).ifPresent(Writer::close);
    }

    @Override
    public void addOption() {
        this.options.addOption(Option.builder((String)"c").argName("conf").hasArg().desc("\u914d\u7f6e\u6587\u4ef6").required(true).build());
    }

    @Override
    public String getName() {
        return "migration";
    }

    @Override
    public String desc() {
        return "\u901a\u8fc7\u914d\u7f6e\u5b8c\u6210\u4e00\u952e\u4efb\u52a1\u4e0a\u4e91";
    }
}

