/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.client;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.client.Command;
import com.aliyun.migration.workflow.migration.common.config.BwmSaasConfiguration;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageFileOperator;
import com.aliyun.migration.workflow.migration.dw.merge.common.MergeTaskContext;
import com.aliyun.migration.workflow.migration.dw.merge.module.DwMergeAssistant;
import com.google.common.base.Charsets;
import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeCommand
extends Command {
    private static final Logger log = LoggerFactory.getLogger(MergeCommand.class);
    private DwMergeAssistant dwMergeAssistant;

    public MergeCommand() {
        this.addOption();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exec(String[] args) {
        System.setProperty("file.encoding", "zh_CN.UTF-8");
        MergeTaskContext taskContext = MergeTaskContext.builder().build();
        try {
            JSONObject configuration;
            CommandLine cmd = this.parse.parse(this.options, args);
            this.commandName = "merge";
            if (cmd.hasOption("help")) {
                this.usage();
                return;
            }
            String configStr = BwmPackageFileOperator.JsonType.JSON_TYPE.value;
            if (cmd.hasOption("c")) {
                String configPath = cmd.getOptionValue("c");
                File file = new File(configPath);
                if (file.exists()) {
                    configStr = FileUtils.readFileToString((File)file, (String)Charsets.UTF_8.name());
                } else {
                    log.error("config file path not exists {}", (Object)configPath);
                }
            }
            if ((configuration = JSONObject.parseObject((String)configStr)).containsKey("saas")) {
                BwmSaasConfiguration bwmSaasConfiguration = (BwmSaasConfiguration)configuration.getJSONObject("saas").to(BwmSaasConfiguration.class, new JSONReader.Feature[0]);
                this.downloadFileFromOss(bwmSaasConfiguration);
                if (StringUtils.isEmpty((CharSequence)bwmSaasConfiguration.getLocal().getInputFileReadPath().getNewConverterOutputPackage())) {
                    WorkflowProjectPackage workflowProjectPackage = BwmPackageFileOperator.readFile((String)bwmSaasConfiguration.getLocal().getInputFileReadPath().getNewReaderOutputPackage());
                    taskContext = MergeTaskContext.builder().readerOutputT1Path(bwmSaasConfiguration.getLocal().getInputFileReadPath().getOldReaderOutputPackage()).readerOutputTPath(bwmSaasConfiguration.getLocal().getInputFileReadPath().getNewReaderOutputPackage()).resultXlsFilePath(bwmSaasConfiguration.getDiscoveryDiffXlsSavePath(workflowProjectPackage != null && workflowProjectPackage.getWorkflowProject() != null ? workflowProjectPackage.getWorkflowProject().getProjectId() : null)).readTPkg(workflowProjectPackage).resultPackagePath(null).bwmSaasConfiguration(bwmSaasConfiguration).mergeMode(MergeTaskContext.MergeMode.CUSTOM).mergeRules(null).build();
                } else {
                    taskContext = MergeTaskContext.builder().readerOutputT1Path(bwmSaasConfiguration.getLocal().getInputFileReadPath().getOldReaderOutputPackage()).readerOutputTPath(bwmSaasConfiguration.getLocal().getInputFileReadPath().getNewReaderOutputPackage()).convertOutputT1Path(bwmSaasConfiguration.getLocal().getInputFileReadPath().getOldConverterOutputPackage()).convertOutputT1ExtendedScriptPath(bwmSaasConfiguration.getLocal().getInputFileReadPath().getOldConverterOutputPackageExtendedScriptFolder()).convertOutputTPath(bwmSaasConfiguration.getLocal().getInputFileReadPath().getNewConverterOutputPackage()).convertOUtputTExtendedScriptPath(bwmSaasConfiguration.getLocal().getInputFileReadPath().getNewConverterOutputPackageExtendedScriptFolder()).writeOutputT1Path(bwmSaasConfiguration.getLocal().getInputFileReadPath().getOldWriterOutputPackage()).targetOutputTPath(bwmSaasConfiguration.getLocal().getInputFileReadPath().getNewDataWorksReaderOutputPackage()).resultXlsFilePath(bwmSaasConfiguration.getMergeConflictXlsSavePath()).resultPackagePath(bwmSaasConfiguration.getMigrationPackageZipSavePath()).bwmSaasConfiguration(bwmSaasConfiguration).mergeMode(StringUtils.isEmpty((CharSequence)configuration.getString("merge.mode")) ? null : MergeTaskContext.MergeMode.valueOf((String)configuration.getString("merge.mode"))).mergeRules(configuration.getString("merge.rules")).build();
                }
            } else {
                taskContext = MergeTaskContext.builder().readerOutputT1Path(configuration.getString("reader.output.t-1.package.path")).readerOutputTPath(configuration.getString("reader.output.t.package.path")).convertOutputT1Path(configuration.getString("convert.output.t-1.package.path")).convertOutputTPath(configuration.getString("convert.output.t.package.path")).writeOutputT1Path(configuration.getString("write.output.t-1.package.path")).targetOutputTPath(configuration.getString("target.reader.output.t.package.path")).resultXlsFilePath(configuration.getString("merge.xls.output.path")).resultPackagePath(configuration.getString("result.output.t.package.path")).bwmSaasConfiguration(null).mergeMode(StringUtils.isEmpty((CharSequence)configuration.getString("merge.mode")) ? null : MergeTaskContext.MergeMode.valueOf((String)configuration.getString("merge.mode"))).mergeRules(configuration.getString("merge.rules")).build();
            }
            this.dwMergeAssistant = new DwMergeAssistant();
            this.dwMergeAssistant.init(taskContext);
            this.dwMergeAssistant.root();
            this.dwMergeAssistant.exportFile();
            if (taskContext.getBwmSaasConfiguration() != null) {
                this.sendMns(taskContext.getBwmSaasConfiguration());
            }
        }
        catch (Exception e) {
            this.dwMergeAssistant.close();
            log.error("exec error\uff0c", (Throwable)e);
            this.usage();
            if (taskContext.getBwmSaasConfiguration() != null) {
                this.sendMns(taskContext.getBwmSaasConfiguration(), e.getMessage());
            }
            System.exit(1);
        }
        finally {
            this.dwMergeAssistant.close();
            log.info("exec finished!");
        }
        System.exit(0);
    }

    @Override
    public TaskContext getTaskContext(CommandLine cmd) throws Exception {
        return null;
    }

    @Override
    public void getPlugin(TaskContext taskContext) throws Exception {
    }

    @Override
    public void execLocal(TaskContext taskContext) throws Exception {
    }

    @Override
    public void execSaas(TaskContext taskContext) throws Exception {
    }

    @Override
    public void closePlugin() {
    }

    @Override
    public void addOption() {
        this.options.addOption(Option.builder((String)"c").argName("conf").hasArg().desc("\u914d\u7f6e\u6587\u4ef6").required(true).build());
    }

    @Override
    public String getName() {
        return "merge";
    }

    @Override
    public String desc() {
        return "\u53cc\u7aef\u4fee\u6539\u878d\u5408";
    }
}

