/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.client;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.plugin.Converter;
import com.aliyun.migration.client.Command;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.workflow.migration.common.config.BwmSaasConfiguration;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageFileOperator;
import com.aliyun.migration.workflow.migration.common.spi.PluginHandler;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.common.utils.cloud.OssCloudClient;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ConverterCommand
extends Command {
    private static final Logger log = LoggerFactory.getLogger(ConverterCommand.class);
    private Converter converter;

    public ConverterCommand() {
        this.addOption();
    }

    @Override
    public void getPlugin(TaskContext taskContext) {
        this.converter = PluginHandler.getConverter((String)taskContext.getConverterName());
        this.commandName = "converter";
    }

    @Override
    public void closePlugin() {
        Optional.ofNullable(this.converter).ifPresent(Converter::close);
    }

    @Override
    public TaskContext getTaskContext(CommandLine cmd) throws Exception {
        String outputFilePath;
        String sourceFilePath;
        String originalFilePath;
        Datasource targetDatasource;
        String targetSchedule;
        Datasource sourceDatasource;
        BwmConfiguration Configuration;
        String sourceSchedule;
        String convertType = cmd.getOptionValue("t");
        String configStr = BwmPackageFileOperator.JsonType.JSON_TYPE.value;
        if (cmd.hasOption("c")) {
            String configPath = cmd.getOptionValue("c");
            File file = new File(configPath);
            if (file.exists()) {
                configStr = FileUtils.readFileToString((File)file, (String)Charsets.UTF_8.name());
            } else {
                log.error("\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728 {}", (Object)configPath);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)(sourceSchedule = (Configuration = BwmConfiguration.from((String)configStr)).getString("schedule_datasource")))) {
            sourceDatasource = (Datasource)GsonUtils.fromJsonString((String)sourceSchedule, Datasource.class);
            if (Objects.isNull(sourceDatasource)) {
                log.error("\u65e0\u6cd5\u89e3\u6790\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684\u8fc1\u79fb\u6e90\u7aef\u6570\u636e\u6e90\u4fe1\u606f\uff1a{}", (Object)sourceSchedule);
                sourceDatasource = new Datasource();
            }
        } else {
            log.warn("\u914d\u7f6e\u9879\u4e2d\u672a\u83b7\u53d6\u5230\u6e90\u7aef\u8c03\u5ea6\u6570\u636e\u6e90\u4fe1\u606f\uff0c\u9ed8\u8ba4\u4f7f\u7528\u7a7a\u6570\u636e\u6e90");
            sourceDatasource = new Datasource();
        }
        if (CollectionUtils.isEmpty((Map)sourceDatasource.getProperties())) {
            sourceDatasource.setProperties(new HashMap());
        }
        if (!StringUtils.isEmpty((CharSequence)(targetSchedule = Configuration.getString("target_schedule_datasource")))) {
            targetDatasource = (Datasource)GsonUtils.fromJsonString((String)targetSchedule, Datasource.class);
            if (Objects.isNull(targetDatasource)) {
                log.error("\u65e0\u6cd5\u89e3\u6790\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684\u8fc1\u79fb\u76ee\u6807\u7aef\u6570\u636e\u6e90\u4fe1\u606f\uff1a{}", (Object)targetSchedule);
                targetDatasource = new Datasource();
            }
        } else {
            log.warn("\u914d\u7f6e\u9879\u4e2d\u672a\u83b7\u53d6\u5230\u76ee\u6807\u7aef\u8c03\u5ea6\u6570\u636e\u6e90\u4fe1\u606f\uff0c\u9ed8\u8ba4\u4f7f\u7528\u7a7a\u6570\u636e\u6e90");
            targetDatasource = new Datasource();
        }
        if (CollectionUtils.isEmpty((Map)targetDatasource.getProperties())) {
            targetDatasource.setProperties(new HashMap());
        }
        if (cmd.hasOption("m") && !StringUtils.isEmpty((CharSequence)(originalFilePath = cmd.getOptionValue("m")))) {
            sourceDatasource.getProperties().put("source-file-path", originalFilePath);
        }
        if (cmd.hasOption("f") && !StringUtils.isEmpty((CharSequence)(sourceFilePath = cmd.getOptionValue("f")))) {
            sourceDatasource.getProperties().put("export-file-path", sourceFilePath);
        }
        if (cmd.hasOption("o") && !StringUtils.isEmpty((CharSequence)(outputFilePath = cmd.getOptionValue("o")))) {
            targetDatasource.getProperties().put("source-file-path", outputFilePath);
        }
        TaskContext taskContext = new TaskContext();
        taskContext.setReaderDatasource(sourceDatasource);
        taskContext.setWriterDatasource(targetDatasource);
        taskContext.setConverterName(convertType);
        taskContext.setBwmConfiguration(configStr);
        taskContext.setSaasConfiguration(Configuration.getString("saas"));
        return taskContext;
    }

    @Override
    public void execLocal(TaskContext taskContext) throws IOException {
        String originalFilePath = (String)taskContext.getReaderDatasource().getProperties().get("source-file-path");
        String sourceFilePath = (String)taskContext.getReaderDatasource().getProperties().get("export-file-path");
        String exportFilePath = (String)taskContext.getWriterDatasource().getProperties().get("source-file-path");
        BwmConfiguration bwmConfiguration = BwmConfiguration.from((String)taskContext.getBwmConfiguration());
        Map selfConfMap = bwmConfiguration.getMap("self", new HashMap());
        Boolean isUseMx = selfConfMap.getOrDefault("if.use.migrationx.before", false);
        taskContext.setIsUserMx(isUseMx);
        if (isUseMx.booleanValue()) {
            if (StringUtils.isEmpty((CharSequence)originalFilePath)) {
                log.error("\u4f7f\u7528MigrationX\u4f46\u672a\u6307\u5b9a\u539f\u59cb\u6587\u4ef6\u8def\u5f84");
                return;
            }
            if (!new File(originalFilePath).exists()) {
                log.error("\u4f7f\u7528MigrationX\u4f46\u539f\u59cb\u6587\u4ef6\u4e0d\u5b58\u5728");
                return;
            }
        } else {
            if (StringUtils.isEmpty((CharSequence)sourceFilePath)) {
                log.error("\u672a\u6307\u5b9aReader\u8f93\u51fa\u6587\u4ef6\u8def\u5f84");
                return;
            }
            if (!new File(sourceFilePath).exists()) {
                log.error("Reader\u8f93\u51fa\u6587\u4ef6\u4e0d\u5b58\u5728");
                return;
            }
        }
        if (StringUtils.isEmpty((CharSequence)exportFilePath)) {
            exportFilePath = "/temp/export/ConvertorOutput.zip";
            log.warn("\u672a\u6307\u5b9a\u8f93\u51fa\u6587\u4ef6\u8def\u5f84\uff0c\u9ed8\u8ba4\u4f7f\u7528{}", (Object)exportFilePath);
            taskContext.getWriterDatasource().getProperties().put("source-file-path", exportFilePath);
        }
        this.converter.init(taskContext);
        this.converter.convert();
        this.converter.makeXlxStatisticOp();
        this.converter.export();
    }

    @Override
    public void execSaas(TaskContext taskContext) throws IOException {
        BwmSaasConfiguration bwmSaasConfiguration = (BwmSaasConfiguration)JSONObject.parseObject((String)taskContext.getSaasConfiguration(), BwmSaasConfiguration.class);
        if (Objects.isNull(bwmSaasConfiguration.getLocal())) {
            log.info("SaaS\u914d\u7f6e\u4e2dlocal\u914d\u7f6e\u4e3a\u7a7a, use default");
            bwmSaasConfiguration.getLocal().useDefault("");
            taskContext.setSaasConfiguration(JSONObject.toJSONString((Object)bwmSaasConfiguration, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        }
        if (Objects.isNull(bwmSaasConfiguration.getOss())) {
            log.warn("SaaS\u914d\u7f6e\u4e2doss\u914d\u7f6e\u4e3a\u7a7a, \u6267\u884c\u5b8c\u6210\u540e\u5c06\u8df3\u8fc7\u4e0a\u4f20");
        }
        String originalFilePath = bwmSaasConfiguration.getLocal().getInputFileReadPath().getMxReaderOutputPackage();
        String sourceFilePath = bwmSaasConfiguration.getLocal().getInputFileReadPath().getMainPackage();
        String exportFilePath = bwmSaasConfiguration.getMigrationPackageZipSavePath();
        if (ObjectUtils.isEmpty((Object)taskContext.getReaderDatasource().getProperties())) {
            taskContext.getReaderDatasource().setProperties(new HashMap());
        }
        if (ObjectUtils.isEmpty((Object)taskContext.getWriterDatasource().getProperties())) {
            taskContext.getWriterDatasource().setProperties(new HashMap());
        }
        taskContext.getReaderDatasource().getProperties().put("source-file-path", originalFilePath);
        taskContext.getReaderDatasource().getProperties().put("export-file-path", sourceFilePath);
        taskContext.getWriterDatasource().getProperties().put("source-file-path", exportFilePath);
        this.execLocal(taskContext);
    }

    @Override
    public void uploadFileToOss(TaskContext taskContext) {
        if (StringUtils.isEmpty((CharSequence)taskContext.getSaasConfiguration())) {
            log.warn("\u672a\u83b7\u53d6\u5230SaaS\u914d\u7f6e\uff0c\u8df3\u8fc7\u4e0a\u4f20");
            return;
        }
        log.info("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6\u5230OSS");
        BwmSaasConfiguration bwmSaasConfiguration = (BwmSaasConfiguration)JSONObject.parseObject((String)taskContext.getSaasConfiguration(), BwmSaasConfiguration.class);
        if (Objects.isNull(bwmSaasConfiguration.getLocal())) {
            log.warn("SaaS\u914d\u7f6e\u4e2dlocal\u914d\u7f6e\u4e3a\u7a7a, \u8df3\u8fc7\u4e0a\u4f20");
            return;
        }
        if (Objects.isNull(bwmSaasConfiguration.getOss())) {
            log.warn("SaaS\u914d\u7f6e\u4e2doss\u914d\u7f6e\u4e3a\u7a7a, \u8df3\u8fc7\u4e0a\u4f20");
            return;
        }
        OssCloudClient ossCloudClient = new OssCloudClient(bwmSaasConfiguration.getOss().getEndpoint(), bwmSaasConfiguration.getOss().getAk(), bwmSaasConfiguration.getOss().getSk());
        ossCloudClient.uploadAndMergeFolder(bwmSaasConfiguration.getOss().getBucket(), bwmSaasConfiguration.getOss().getRootPath(), bwmSaasConfiguration.getLocal().getOutputFileSaveRootPath());
        log.info("\u4e0a\u4f20\u6587\u4ef6\u5230OSS\u5b8c\u6210");
        ossCloudClient.createFile(bwmSaasConfiguration.getOss().getBucket(), bwmSaasConfiguration.getMigrationInstanceStatusFileOssPath(), "{\"status\":\"finish\"}");
    }

    @Override
    public void addOption() {
        this.options.addOption(Option.builder((String)"c").argName("conf").hasArg().desc("\u914d\u7f6e\u6587\u4ef6").required(false).build());
        this.options.addOption(Option.builder((String)"m").argName("file").hasArg().desc("\u539f\u59cb\u6587\u4ef6").required(false).build());
        this.options.addOption(Option.builder((String)"f").argName("file").hasArg().desc("Reader\u8f93\u51fa\u6587\u4ef6").required(false).build());
        this.options.addOption(Option.builder((String)"o").argName("out").hasArg().desc("\u8f93\u51fa\u6587\u4ef6\u540d\u79f0\u53ca\u8def\u5f84").required(false).build());
        this.options.addOption(Option.builder((String)"t").argName("type").hasArg().desc("\u8f6c\u6362\u63d2\u4ef6\u7c7b\u578b").required(true).build());
    }

    @Override
    public String getName() {
        return "convert";
    }

    @Override
    public String desc() {
        return "\u901a\u8fc7\u6307\u5b9a\u914d\u7f6e\u5b8c\u6210\u8c03\u5ea6\u8f6c\u6362";
    }
}

