/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.client;

import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.client.Command;
import com.aliyun.migration.client.ConverterCommand;
import com.aliyun.migration.client.DwDIJobPlainMigrationCommand;
import com.aliyun.migration.client.MergeCommand;
import com.aliyun.migration.client.MigrationSupervisorCommand;
import com.aliyun.migration.client.PluginCommand;
import com.aliyun.migration.client.ReaderCommand;
import com.aliyun.migration.client.WriterCommand;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.cli.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BwmClientApp
extends Command {
    private static final Logger log = LoggerFactory.getLogger(BwmClientApp.class);
    private TreeMap<String, Command> commandTreeMap;

    public BwmClientApp() {
        this.formatter.setOptPrefix("");
        this.commandTreeMap = new TreeMap();
        this.addCommand(new ReaderCommand());
        this.addCommand(new ConverterCommand());
        this.addCommand(new WriterCommand());
        this.addCommand(new PluginCommand());
        this.addCommand(new DwDIJobPlainMigrationCommand());
        this.addCommand(new MergeCommand());
        this.addCommand(new MigrationSupervisorCommand());
        for (Map.Entry<String, Command> entry : this.commandTreeMap.entrySet()) {
            this.options.addOption(entry.getKey(), entry.getValue().desc());
        }
        this.options.addOption("help", "\u6253\u5370\u5e2e\u52a9\u4fe1\u606f");
    }

    private void addCommand(Command command) {
        this.commandTreeMap.put(command.getName().toLowerCase(Locale.ROOT), command);
    }

    public static void main(String[] args) {
        log.info("exec args : {}", (Object[])args);
        BwmClientApp bwmClient = new BwmClientApp();
        try {
            bwmClient.exec(args);
        }
        catch (Exception e) {
            log.error("exec error ", (Throwable)e);
            bwmClient.usage();
            System.exit(-1);
        }
        System.exit(0);
    }

    @Override
    public void exec(String[] args) throws Exception {
        if (null == args || args.length == 0) {
            this.usage();
            return;
        }
        CommandLine cmd = this.parse.parse(this.options, new String[]{args[0]});
        if (cmd.hasOption("help")) {
            this.usage();
            return;
        }
        Command command = this.commandTreeMap.get(args[0].toLowerCase(Locale.ROOT));
        if (null == command) {
            this.usage();
            return;
        }
        if (args.length == 1) {
            command.usage();
            return;
        }
        this.init();
        command.exec(Arrays.asList(args).subList(1, args.length).toArray(new String[0]));
    }

    @Override
    public TaskContext getTaskContext(CommandLine cmd) throws Exception {
        return null;
    }

    @Override
    public void getPlugin(TaskContext taskContext) throws Exception {
    }

    @Override
    public void execLocal(TaskContext taskContext) throws Exception {
    }

    @Override
    public void execSaas(TaskContext taskContext) throws Exception {
    }

    @Override
    public void closePlugin() {
    }

    @Override
    public void addOption() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return "bwmclient";
    }

    @Override
    public String desc() {
        return "\u8c03\u5ea6\u8fc1\u79fb\u5ba2\u6237\u7aef\u5de5\u5177";
    }
}

