/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.azkaban.v3.handler;

import azkaban.utils.Props;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.dataworks.common.spec.domain.dw.types.CalcEngineType;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DataWorksPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNodeIo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwProject;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwResource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Workflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.NodeUseType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.RerunMode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.WorkflowVersion;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DataStudioCodeUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DefaultNodeTypeUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.NodeUtils;
import com.aliyun.dataworks.migrationx.transformer.core.RawNodeType;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.workflow.migration.azkaban.v3.domain.objects.CommandJob;
import com.aliyun.migration.workflow.migration.azkaban.v3.domain.objects.Job;
import com.aliyun.migration.workflow.migration.azkaban.v3.domain.objects.JobType;
import com.aliyun.migration.workflow.migration.azkaban.v3.domain.service.AzkabanPackageParser;
import com.aliyun.migration.workflow.migration.common.convert.DwSpec2WorkflowConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Azkabanv3FileHandler {
    private static final Logger log = LoggerFactory.getLogger(Azkabanv3FileHandler.class);
    private Project project = new Project();
    private AzkabanPackageParser parser;
    private WorkflowProjectPackage workflowProjectPackage;
    private TaskContext taskContext;

    public Azkabanv3FileHandler(File dir, String projectName, TaskContext taskContext) {
        this.project.setName(projectName);
        this.taskContext = taskContext;
        this.parser = new AzkabanPackageParser();
        try {
            if (new File(dir, "flow").exists()) {
                this.parser.parse(new File(dir, "flow"), projectName);
            } else {
                this.parser.parse(dir, projectName);
            }
        }
        catch (Exception e) {
            log.error("parse azkaban package error: ", (Throwable)e);
            throw BizException.of((ErrorCode)ErrorCode.PACKAGE_ANALYZE_FAILED).with(new Object[]{e.getMessage()});
        }
        List<DwWorkflow> mxResult = this.convertAzkabanPackage();
        DataWorksPackage dataWorksPackage = new DataWorksPackage();
        dataWorksPackage.setDwProject(new DwProject());
        dataWorksPackage.getDwProject().setName(projectName);
        dataWorksPackage.getDwProject().setWorkflows(new ArrayList());
        mxResult.forEach(workflow -> dataWorksPackage.getDwProject().getWorkflows().add(workflow));
        DwSpec2WorkflowConvert dwSpec2WorkflowConvert = new DwSpec2WorkflowConvert();
        this.workflowProjectPackage = dwSpec2WorkflowConvert.convertDwPackage2WorkflowPackage(dataWorksPackage);
        if (this.workflowProjectPackage != null && CollectionUtils.isNotEmpty((Collection)this.workflowProjectPackage.getWorkflowList())) {
            this.workflowProjectPackage.getWorkflowList().stream().forEach(wf -> {
                if (StringUtils.isBlank((CharSequence)wf.getWorkflowId())) {
                    wf.setWorkflowId(wf.getWorkflowName());
                }
                if (wf.getWorkflowNodes() != null && !wf.getWorkflowNodes().isEmpty()) {
                    wf.getWorkflowNodes().stream().forEach(node -> {
                        node.setWorkflowId(wf.getWorkflowId());
                        node.setWorkflowName(wf.getWorkflowName());
                    });
                }
            });
        }
        ArrayList files = new ArrayList();
        if (new File(dir, "resource").exists()) {
            FileUtils.listFiles((File)new File(dir, "resource"), null, (boolean)true).stream().forEach(file -> {
                WorkflowFileResource fileResource = new WorkflowFileResource();
                fileResource.setName(file.getName());
                fileResource.setPath(file.getAbsolutePath());
                fileResource.setFolder(file.getAbsolutePath().substring(new File(dir, "resource").getAbsolutePath().length(), file.getAbsolutePath().lastIndexOf("/") + 1));
                files.add(fileResource);
            });
        }
        this.workflowProjectPackage.setFiles(files);
        if (this.workflowProjectPackage != null && CollectionUtils.isNotEmpty((Collection)this.workflowProjectPackage.getWorkflowList())) {
            this.workflowProjectPackage.getWorkflowList().stream().forEach(wf -> wf.setFiles(files));
        }
    }

    public WorkflowProjectPackage getWorkflowProjectPackage() {
        return this.workflowProjectPackage;
    }

    private List<DwWorkflow> convertAzkabanPackage() {
        Map<String, AzkabanPackageParser.FlowSpec> flowJobs = this.parser.getFlowJobs();
        return MapUtils.emptyIfNull(flowJobs).entrySet().stream().map(ent -> {
            String flowName = (String)ent.getKey();
            List<Job> jobs = ((AzkabanPackageParser.FlowSpec)ent.getValue()).getJobs();
            DwWorkflow workflow = new DwWorkflow();
            workflow.setScheduled(Boolean.valueOf(true));
            workflow.setName(NodeUtils.normalizedFileName((String)flowName));
            workflow.setVersion(WorkflowVersion.V3);
            ListUtils.emptyIfNull(jobs).forEach(job -> {
                Props props = Optional.ofNullable(this.parser.getJobProperties(flowName, job.getName())).orElse(new Props());
                List<Node> nodes = this.jobToNode((Job)job, workflow, props.toAllProperties());
                nodes.forEach(n -> ((DwNode)n).setWorkflowRef((Workflow)workflow));
                workflow.getNodes().addAll(nodes);
                List<DwResource> dwResources = this.jobToResource((Job)job, workflow);
                ListUtils.emptyIfNull(dwResources).forEach(r -> r.setWorkflowRef(workflow));
                workflow.getResources().addAll(dwResources);
            });
            workflow.setParameters(JSONObject.from(((AzkabanPackageParser.FlowSpec)ent.getValue()).getFlowProperties()).toJSONString(new JSONWriter.Feature[0]));
            return workflow;
        }).collect(Collectors.toList());
    }

    private List<DwResource> jobToResource(Job job, DwWorkflow workflow) {
        CalcEngineType calcEngineType = CalcEngineType.EMR;
        String nodeMarketEngineType = DefaultNodeTypeUtils.convertToNodeMarketModelEngineTypes((CalcEngineType)calcEngineType);
        return ListUtils.emptyIfNull(job.getRelatedFiles()).stream().map(file -> {
            DwResource dwResource = new DwResource();
            dwResource.setName(file.getName());
            dwResource.setOdps(Boolean.valueOf(false));
            dwResource.setLocalPath(file.getAbsolutePath());
            dwResource.setWorkflowRef(workflow);
            if (file.getName().endsWith(".jar")) {
                CodeProgramType type = DefaultNodeTypeUtils.getJarResourceType((String)nodeMarketEngineType);
                dwResource.setType(type.name());
            } else {
                CodeProgramType type = DefaultNodeTypeUtils.getFileResourceType((String)nodeMarketEngineType);
                dwResource.setType(type.name());
            }
            dwResource.setOriginResourceName(file.getName());
            return dwResource;
        }).collect(Collectors.toList());
    }

    private List<String> parseCodeParameters(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return ListUtils.emptyIfNull(null);
        }
        Pattern pattern = Pattern.compile("\\$\\{[\\w\\.]+\\}");
        Matcher matcher = pattern.matcher(code);
        HashSet<String> params = new HashSet<String>();
        while (matcher.find()) {
            String param = matcher.group();
            param = param.replaceAll("\\$\\{", "").replaceAll("\\}", "");
            params.add(param);
        }
        return new ArrayList<String>(params);
    }

    private String processJobParameters(Job job, Properties jobProperty, String type, List<String> params) {
        AtomicInteger paramIndex = new AtomicInteger(0);
        return Joiner.on((String)" ").join((Iterable)ListUtils.emptyIfNull(params).stream().map(p -> {
            String rawValue = Optional.ofNullable(jobProperty.getProperty((String)p)).orElse("UNDEFINED_VARIABLE_VALUE");
            String value = ListUtils.emptyIfNull(this.parseCodeParameters(rawValue)).stream().filter(StringUtils::isNotBlank).map(paramInValue -> Optional.ofNullable(jobProperty.getProperty((String)paramInValue)).map(val -> StringUtils.replace((String)rawValue, (String)("${" + paramInValue + "}"), (String)val)).orElse(rawValue)).reduce((a, b) -> b).orElse(rawValue);
            int index = paramIndex.incrementAndGet();
            if (!DefaultNodeTypeUtils.isNoCalcEngineShell((String)type)) {
                return Joiner.on((String)"=").join(p, (Object)value, new Object[0]);
            }
            ((CommandJob)job).getCommands().add(index - 1, Joiner.on((String)"=").join(p, (Object)("$" + index), new Object[0]));
            return value;
        }).collect(Collectors.toList()));
    }

    private List<Node> jobToNode(Job job, DwWorkflow workflow, Properties jobProperty) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        DwNode dwNode = new DwNode();
        dwNode.setName(job.getName());
        dwNode.setIsAutoParse(Integer.valueOf(0));
        dwNode.setType(job.getType().name());
        dwNode.setRawNodeType(job.getType().name());
        dwNode.setNodeUseType(BooleanUtils.isTrue((Boolean)workflow.getScheduled()) ? NodeUseType.SCHEDULED : NodeUseType.MANUAL_WORKFLOW);
        dwNode.setWorkflowRef((Workflow)workflow);
        DwNodeIo dwNodeIo = new DwNodeIo();
        dwNodeIo.setNodeRef((Node)dwNode);
        dwNodeIo.setData(Joiner.on((String)".").join((Object)this.project.getName(), (Object)workflow.getName(), new Object[]{dwNode.getName()}));
        dwNodeIo.setParseType(Integer.valueOf(1));
        dwNodeIo.setNodeRef((Node)dwNode);
        dwNode.setOutputs(Collections.singletonList(dwNodeIo));
        dwNode.setCronExpress("day");
        dwNode.setRerunMode(RerunMode.ALL_ALLOWED);
        dwNode.setInputs(ListUtils.emptyIfNull(job.getDependencies()).stream().map(dependency -> {
            DwNodeIo input = new DwNodeIo();
            if (StringUtils.contains((CharSequence)dependency, (CharSequence)"@")) {
                input.setData(StringUtils.replace((String)dependency, (String)"@", (String)"."));
            } else {
                input.setData(Joiner.on((String)".").join((Object)workflow.getName(), dependency, new Object[0]));
            }
            input.setData(Joiner.on((String)".").join((Object)this.project.getName(), (Object)input.getData(), new Object[0]));
            input.setParseType(Integer.valueOf(1));
            input.setNodeRef((Node)dwNode);
            return input;
        }).collect(Collectors.toList()));
        dwNode.setParameter(this.processJobParameters(job, jobProperty, dwNode.getType(), this.parseCodeParameters(job.getCode())));
        dwNode.setCode(job.getCode());
        if (CollectionUtils.isNotEmpty(job.getRelatedFiles())) {
            String bwmConfiguration = this.taskContext.getBwmConfiguration();
            BwmConfiguration Configuration = BwmConfiguration.from((String)bwmConfiguration);
            Boolean isRelatedFileFlat = Configuration.getBool("isRelatedFileFlat");
            if (Objects.nonNull(isRelatedFileFlat) && isRelatedFileFlat.booleanValue()) {
                List<File> relatedFiles = job.getRelatedFiles();
                StringBuilder sb = new StringBuilder();
                try {
                    int count = 0;
                    for (File file : relatedFiles) {
                        ++count;
                        if (relatedFiles.size() > 1) {
                            String fileName = Azkabanv3FileHandler.extractFileName(file);
                            sb.append("-----------fileName:").append(fileName).append("-----------\n");
                        }
                        sb.append(FileUtils.readFileToString((File)file, (String)"UTF-8"));
                        if (relatedFiles.size() <= 1 || count == relatedFiles.size()) continue;
                        sb.append("-----------azkaban-----------");
                    }
                }
                catch (IOException e) {
                    log.error("read related file error,", (Throwable)e);
                    dwNode.setCode(job.getCode());
                }
                dwNode.setCode(sb.toString());
            } else {
                dwNode.setCode(DataStudioCodeUtils.addResourceReference((CodeProgramType)CodeProgramType.SHELL, (String)dwNode.getCode(), (Collection)ListUtils.emptyIfNull(job.getRelatedFiles()).stream().map(File::getName).collect(Collectors.toList())));
            }
        }
        log.info("jobType: {}, jobClz: {}", (Object)job.getType(), job.getClass());
        nodes.add((Node)dwNode);
        return nodes;
    }

    public static String extractFileName(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        String fileNameWithExtension = file.getName();
        int lastDotIndex = fileNameWithExtension.lastIndexOf(46);
        if (lastDotIndex == -1 || lastDotIndex == 0) {
            return fileNameWithExtension;
        }
        return fileNameWithExtension.substring(0, lastDotIndex);
    }

    private RawNodeType getRawNodeType(JobType type) {
        switch (type) {
            case noop: {
                return RawNodeType.AZKABAN_NOOP;
            }
            case command: {
                return RawNodeType.AZKABAN_COMMAND;
            }
            case hive: {
                return RawNodeType.AZKABAN_HIVE;
            }
            case flow: {
                return RawNodeType.AZKABAN_FLOW;
            }
        }
        return null;
    }

    public void setProject(Project project) {
        this.project = project;
    }
}

