/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.azkaban.v3.domain.objects;

import com.aliyun.migration.workflow.migration.azkaban.v3.domain.objects.CommandJob;
import com.aliyun.migration.workflow.migration.azkaban.v3.domain.objects.FlowJob;
import com.aliyun.migration.workflow.migration.azkaban.v3.domain.objects.HiveJob;
import com.aliyun.migration.workflow.migration.azkaban.v3.domain.objects.Job;
import com.aliyun.migration.workflow.migration.azkaban.v3.domain.objects.NoopJob;

public enum JobType {
    noop,
    command,
    hive,
    flow,
    gobblin,
    hadoopJava,
    java,
    pig,
    spark,
    hdfsToTeradata,
    teradataToHdfs,
    unknown;


    public static JobType getByName(String type) {
        for (JobType jobType : JobType.values()) {
            if (!jobType.name().equalsIgnoreCase(type)) continue;
            return jobType;
        }
        return unknown;
    }

    public static Job newJobInstance(JobType jobType) {
        Job job = null;
        switch (jobType) {
            case hive: {
                job = new HiveJob();
                break;
            }
            case command: {
                job = new CommandJob();
                break;
            }
            case noop: {
                job = new NoopJob();
                break;
            }
            case flow: {
                job = new FlowJob();
                break;
            }
            default: {
                job = new Job(){

                    @Override
                    public String getCode() {
                        return null;
                    }
                };
            }
        }
        job.setType(jobType);
        return job;
    }
}

