/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.azkaban.v3.domain.objects;

import com.aliyun.migration.workflow.migration.azkaban.v3.domain.objects.ConfigProperty;
import com.aliyun.migration.workflow.migration.azkaban.v3.domain.objects.Job;
import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveJob
extends Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(HiveJob.class);
    @ConfigProperty(value="user.to.proxy")
    private String userToProxy;
    @ConfigProperty(pattern="hive.query(\\.\\d+)?")
    private List<String> queries;
    @ConfigProperty(value="azk.hive.action")
    private String azkHiveAction;
    @ConfigProperty(value="hive.script")
    private String hiveScript;
    @ConfigProperty(value="hive.query.file")
    private String hiveQueryFile;

    @Override
    public void processJobRelativeFiles() {
        File file;
        if (this.getRelatedFiles() == null) {
            this.setRelatedFiles(new ArrayList<File>());
        }
        for (String query : this.queries) {
            File jobFile;
            String[] tokens = query.split(" ");
            if (tokens == null || (jobFile = this.getJobFile()) == null || !jobFile.exists()) continue;
            File dir = jobFile.getParentFile();
            for (String token : tokens) {
                File file2 = new File(dir, token);
                if (!file2.exists() || !file2.isFile() || file2.isHidden()) continue;
                this.getRelatedFiles().add(file2);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.getHiveScript()) && (file = new File(this.getJobFile().getParentFile(), this.getHiveScript())).exists() && file.isFile() && !file.isHidden()) {
            this.getRelatedFiles().add(file);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getHiveQueryFile()) && (file = new File(this.getJobFile().getParentFile(), this.getHiveQueryFile())).exists() && file.isFile() && !file.isHidden()) {
            this.getRelatedFiles().add(file);
        }
    }

    @Override
    public String getCode() {
        if (CollectionUtils.isNotEmpty(this.getQueries())) {
            return Joiner.on((String)"\n").join(this.getQueries());
        }
        File jobFile = this.getJobFile();
        if (jobFile == null || !jobFile.exists()) {
            return null;
        }
        File file = null;
        if (StringUtils.isNotBlank((CharSequence)this.getHiveScript()) && !(file = new File(this.getJobFile().getParentFile(), this.getHiveScript())).exists()) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getHiveQueryFile()) && !(file = new File(this.getJobFile().getParentFile(), this.getHiveQueryFile())).exists()) {
            return null;
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            StringBuilder sb = new StringBuilder();
            while (br.ready() && (line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            br.close();
            return sb.toString();
        }
        catch (FileNotFoundException e) {
            LOGGER.error("read hive script file failed: ", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            LOGGER.error("read hive script file failed: ", (Throwable)e);
            return null;
        }
    }

    public String getUserToProxy() {
        return this.userToProxy;
    }

    public List<String> getQueries() {
        return this.queries;
    }

    public String getAzkHiveAction() {
        return this.azkHiveAction;
    }

    public String getHiveScript() {
        return this.hiveScript;
    }

    public String getHiveQueryFile() {
        return this.hiveQueryFile;
    }

    public void setUserToProxy(String userToProxy) {
        this.userToProxy = userToProxy;
    }

    public void setQueries(List<String> queries) {
        this.queries = queries;
    }

    public void setAzkHiveAction(String azkHiveAction) {
        this.azkHiveAction = azkHiveAction;
    }

    public void setHiveScript(String hiveScript) {
        this.hiveScript = hiveScript;
    }

    public void setHiveQueryFile(String hiveQueryFile) {
        this.hiveQueryFile = hiveQueryFile;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HiveJob)) {
            return false;
        }
        HiveJob other = (HiveJob)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$userToProxy = this.getUserToProxy();
        String other$userToProxy = other.getUserToProxy();
        if (this$userToProxy == null ? other$userToProxy != null : !this$userToProxy.equals(other$userToProxy)) {
            return false;
        }
        List<String> this$queries = this.getQueries();
        List<String> other$queries = other.getQueries();
        if (this$queries == null ? other$queries != null : !((Object)this$queries).equals(other$queries)) {
            return false;
        }
        String this$azkHiveAction = this.getAzkHiveAction();
        String other$azkHiveAction = other.getAzkHiveAction();
        if (this$azkHiveAction == null ? other$azkHiveAction != null : !this$azkHiveAction.equals(other$azkHiveAction)) {
            return false;
        }
        String this$hiveScript = this.getHiveScript();
        String other$hiveScript = other.getHiveScript();
        if (this$hiveScript == null ? other$hiveScript != null : !this$hiveScript.equals(other$hiveScript)) {
            return false;
        }
        String this$hiveQueryFile = this.getHiveQueryFile();
        String other$hiveQueryFile = other.getHiveQueryFile();
        return !(this$hiveQueryFile == null ? other$hiveQueryFile != null : !this$hiveQueryFile.equals(other$hiveQueryFile));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HiveJob;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $userToProxy = this.getUserToProxy();
        result = result * 59 + ($userToProxy == null ? 43 : $userToProxy.hashCode());
        List<String> $queries = this.getQueries();
        result = result * 59 + ($queries == null ? 43 : ((Object)$queries).hashCode());
        String $azkHiveAction = this.getAzkHiveAction();
        result = result * 59 + ($azkHiveAction == null ? 43 : $azkHiveAction.hashCode());
        String $hiveScript = this.getHiveScript();
        result = result * 59 + ($hiveScript == null ? 43 : $hiveScript.hashCode());
        String $hiveQueryFile = this.getHiveQueryFile();
        result = result * 59 + ($hiveQueryFile == null ? 43 : $hiveQueryFile.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "HiveJob(super=" + super.toString() + ", userToProxy=" + this.getUserToProxy() + ", queries=" + this.getQueries() + ", azkHiveAction=" + this.getAzkHiveAction() + ", hiveScript=" + this.getHiveScript() + ", hiveQueryFile=" + this.getHiveQueryFile() + ")";
    }
}

