/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.azkaban.v3.domain.objects;

import com.aliyun.migration.workflow.migration.azkaban.v3.domain.objects.ConfigProperty;
import com.aliyun.migration.workflow.migration.azkaban.v3.domain.objects.Job;
import com.google.common.base.Joiner;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class CommandJob
extends Job {
    @ConfigProperty(pattern="command(\\.\\d+)?")
    private List<String> commands;

    @Override
    public void processJobRelativeFiles() {
        if (this.getRelatedFiles() == null) {
            this.setRelatedFiles(new ArrayList<File>());
        }
        for (String command : this.commands) {
            File jobFile;
            String[] tokens = command.split(" ");
            if (tokens == null || (jobFile = this.getJobFile()) == null || !jobFile.exists()) continue;
            File dir = jobFile.getParentFile();
            for (String token : tokens) {
                File testFile = new File(dir, token);
                if (!testFile.exists() || !testFile.isFile() || testFile.isHidden()) continue;
                this.getRelatedFiles().add(testFile);
            }
        }
    }

    @Override
    public String getCode() {
        if (CollectionUtils.isNotEmpty(this.commands)) {
            return Joiner.on((String)"\n").join(this.commands);
        }
        return null;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public void setCommands(List<String> commands) {
        this.commands = commands;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandJob)) {
            return false;
        }
        CommandJob other = (CommandJob)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$commands = this.getCommands();
        List<String> other$commands = other.getCommands();
        return !(this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CommandJob;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CommandJob(super=" + super.toString() + ", commands=" + this.getCommands() + ")";
    }
}

