/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.yandex.clickhouse.util.apache.StringUtils;

final class PreparedStatementParser {
    private static final Pattern VALUES = Pattern.compile("(?i)INSERT\\s+INTO\\s+.+VALUES\\s*\\(");
    private List<List<String>> parameters = new ArrayList<List<String>>();
    private List<String> parts = new ArrayList<String>();
    private boolean valuesMode = false;

    private PreparedStatementParser() {
    }

    static PreparedStatementParser parse(String sql) {
        if (StringUtils.isBlank(sql)) {
            throw new IllegalArgumentException("SQL may not be blank");
        }
        PreparedStatementParser parser = new PreparedStatementParser();
        parser.parseSQL(sql);
        return parser;
    }

    List<List<String>> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    List<String> getParts() {
        return Collections.unmodifiableList(this.parts);
    }

    boolean isValuesMode() {
        return this.valuesMode;
    }

    private void reset() {
        this.parameters.clear();
        this.parts.clear();
        this.valuesMode = false;
    }

    private void parseSQL(String sql) {
        int i;
        this.reset();
        ArrayList<String> currentParamList = new ArrayList<String>();
        boolean afterBackSlash = false;
        boolean inQuotes = false;
        boolean inBackQuotes = false;
        boolean inSingleLineComment = false;
        boolean inMultiLineComment = false;
        boolean whiteSpace = false;
        Matcher matcher = VALUES.matcher(sql);
        if (matcher.find()) {
            this.valuesMode = true;
        }
        int currentParensLevel = 0;
        int quotedStart = 0;
        int partStart = 0;
        int idxStart = i = this.valuesMode ? matcher.end() - 1 : 0;
        int idxEnd = i;
        while (i < sql.length()) {
            char c = sql.charAt(i);
            if (inSingleLineComment) {
                if (c == '\n') {
                    inSingleLineComment = false;
                }
            } else if (inMultiLineComment) {
                if (c == '*' && sql.length() > i + 1 && sql.charAt(i + 1) == '/') {
                    inMultiLineComment = false;
                    ++i;
                }
            } else if (afterBackSlash) {
                afterBackSlash = false;
            } else if (c == '\\') {
                afterBackSlash = true;
            } else if (c == '\'') {
                boolean bl = inQuotes = !inQuotes;
                if (inQuotes) {
                    quotedStart = i;
                } else if (!afterBackSlash) {
                    idxStart = quotedStart;
                    idxEnd = i + 1;
                }
            } else if (c == '`') {
                inBackQuotes = !inBackQuotes;
            } else if (!inQuotes && !inBackQuotes) {
                if (c == '?') {
                    if (currentParensLevel > 0) {
                        idxStart = i;
                        idxEnd = i + 1;
                    }
                    if (!this.valuesMode) {
                        this.parts.add(sql.substring(partStart, i));
                        partStart = i + 1;
                        currentParamList.add("?");
                    }
                } else if (c == '-' && sql.length() > i + 1 && sql.charAt(i + 1) == '-') {
                    inSingleLineComment = true;
                    ++i;
                } else if (c == '/' && sql.length() > i + 1 && sql.charAt(i + 1) == '*') {
                    inMultiLineComment = true;
                    ++i;
                } else if (c == ',') {
                    if (this.valuesMode && idxEnd > idxStart) {
                        currentParamList.add(PreparedStatementParser.typeTransformParameterValue(sql.substring(idxStart, idxEnd)));
                        this.parts.add(sql.substring(partStart, idxStart));
                        idxStart = idxEnd = i;
                        partStart = idxEnd;
                    }
                    ++idxStart;
                    ++idxEnd;
                } else if (c == '(') {
                    ++currentParensLevel;
                    ++idxStart;
                    ++idxEnd;
                } else if (c == ')') {
                    if (this.valuesMode && --currentParensLevel == 0) {
                        if (idxEnd > idxStart) {
                            currentParamList.add(PreparedStatementParser.typeTransformParameterValue(sql.substring(idxStart, idxEnd)));
                            this.parts.add(sql.substring(partStart, idxStart));
                            idxStart = idxEnd = i;
                            partStart = idxEnd;
                        }
                        if (!currentParamList.isEmpty()) {
                            this.parameters.add(currentParamList);
                            currentParamList = new ArrayList(currentParamList.size());
                        }
                    }
                } else if (Character.isWhitespace(c)) {
                    whiteSpace = true;
                } else if (currentParensLevel > 0) {
                    if (whiteSpace) {
                        idxStart = i;
                        idxEnd = i + 1;
                    } else {
                        ++idxEnd;
                    }
                    whiteSpace = false;
                }
            }
            ++i;
        }
        if (!this.valuesMode && !currentParamList.isEmpty()) {
            this.parameters.add(currentParamList);
        }
        String lastPart = sql.substring(partStart, sql.length());
        this.parts.add(lastPart);
    }

    private static String typeTransformParameterValue(String paramValue) {
        if (paramValue == null) {
            return null;
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(paramValue)) {
            return "1";
        }
        if (Boolean.FALSE.toString().equalsIgnoreCase(paramValue)) {
            return "0";
        }
        if ("NULL".equalsIgnoreCase(paramValue)) {
            return "\\N";
        }
        return paramValue;
    }
}

