/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.sql;

import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.SpecRefEntity;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.dw.types.LanguageEnum;
import com.aliyun.dataworks.common.spec.domain.enums.DependencyType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.interfaces.Output;
import com.aliyun.dataworks.common.spec.domain.noref.SpecDepend;
import com.aliyun.dataworks.common.spec.domain.noref.SpecFlowDepend;
import com.aliyun.dataworks.common.spec.domain.ref.SpecDatasource;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.sql.SqlParameters;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.AbstractParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.context.DolphinSchedulerV3ConverterContext;
import com.aliyun.migrationx.common.utils.BeanUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;

public class SqlParameterConverter
extends AbstractParameterConverter<SqlParameters> {
    private static final SpecScriptRuntime RUNTIME = new SpecScriptRuntime();

    public SqlParameterConverter(DataWorksWorkflowSpec spec, SpecWorkflow specWorkflow, TaskDefinition taskDefinition, DolphinSchedulerV3ConverterContext context) {
        super(spec, specWorkflow, taskDefinition, context);
    }

    @Override
    protected void convertParameter(SpecNode specNode) {
        List<SpecVariable> specVariableList = this.convertSpecNodeParam(specNode);
        SpecScript script = new SpecScript();
        script.setId(this.generateUuid());
        script.setLanguage(LanguageEnum.ODPS_SQL.getIdentifier());
        script.setRuntime(RUNTIME);
        script.setPath(this.getScriptPath(specNode));
        script.setContent(((SqlParameters)this.parameter).getSql());
        script.setParameters(ListUtils.emptyIfNull(specVariableList).stream().filter(v -> !VariableType.NODE_OUTPUT.equals((Object)v.getType())).collect(Collectors.toList()));
        specNode.setScript(script);
        SpecDatasource datasource = (SpecDatasource)MapUtils.emptyIfNull(this.context.getDataSourceMap()).get(String.valueOf(((SqlParameters)this.parameter).getDatasource()));
        if (Objects.nonNull(datasource)) {
            specNode.setDatasource(datasource);
        }
        this.dealPreAndPostSql(specNode, ((SqlParameters)this.parameter).getPreStatements(), ((SqlParameters)this.parameter).getPostStatements());
    }

    private void dealPreAndPostSql(SpecNode specNodeRef, List<String> preSqlList, List<String> postSqlList) {
        String sql;
        int i;
        ArrayList<SpecNode> specNodeList = new ArrayList<SpecNode>();
        if (CollectionUtils.isNotEmpty(preSqlList)) {
            for (i = 0; i < preSqlList.size(); ++i) {
                sql = preSqlList.get(i);
                SpecNode preNode = this.copySpecNode(specNodeRef, sql, "_pre_" + i);
                specNodeList.add(preNode);
                if (i != 0) continue;
                this.headList.add(this.newWrapper((SpecRefEntity)preNode));
            }
        }
        specNodeList.add(specNodeRef);
        if (CollectionUtils.isNotEmpty(postSqlList)) {
            for (i = 0; i < postSqlList.size(); ++i) {
                sql = postSqlList.get(i);
                SpecNode postNode = this.copySpecNode(specNodeRef, sql, "_post_" + i);
                specNodeList.add(postNode);
                if (i != postSqlList.size() - 1) continue;
                this.tailList.add(this.newWrapper((SpecRefEntity)postNode));
            }
        }
        if (specNodeList.size() > 1) {
            SpecNode pre = (SpecNode)specNodeList.get(0);
            for (int i2 = 1; i2 < specNodeList.size(); ++i2) {
                SpecNode specNode = (SpecNode)specNodeList.get(i2);
                specNode.getInputs().add(this.getDefaultOutput(pre));
                specNode.getInputs().addAll(this.getContextOutputs(pre));
                SpecFlowDepend specFlowDepend = this.newSpecFlowDepend();
                specFlowDepend.setNodeId(specNode);
                specFlowDepend.getDepends().add(new SpecDepend(pre, DependencyType.NORMAL, this.getDefaultOutput(pre)));
                this.getWorkflowDependencyList().add(specFlowDepend);
                pre = specNode;
            }
        }
    }

    private SpecNode copySpecNode(SpecNode specNode, String sql, String suffix) {
        SpecNode specNodeCopy = (SpecNode)BeanUtils.deepCopy((Object)specNode, SpecNode.class);
        specNodeCopy.setId(this.generateUuid());
        specNodeCopy.setName(specNodeCopy.getName() + suffix);
        for (Output output : specNodeCopy.getOutputs()) {
            if (output instanceof SpecNodeOutput && Boolean.TRUE.equals(((SpecNodeOutput)output).getIsDefault())) {
                ((SpecNodeOutput)output).setId(this.generateUuid());
                ((SpecNodeOutput)output).setData(specNodeCopy.getId());
                ((SpecNodeOutput)output).setRefTableName(specNodeCopy.getName());
                continue;
            }
            if (!(output instanceof SpecRefEntity)) continue;
            ((SpecRefEntity)output).setId(this.generateUuid());
        }
        this.getWorkflowNodeList().add(specNodeCopy);
        SpecScript scriptCopy = (SpecScript)BeanUtils.deepCopy((Object)specNodeCopy.getScript(), SpecScript.class);
        scriptCopy.setId(this.generateUuid());
        scriptCopy.setPath(scriptCopy.getPath() + suffix);
        scriptCopy.setContent(sql);
        specNodeCopy.setScript(scriptCopy);
        return specNodeCopy;
    }

    static {
        RUNTIME.setEngine(CodeProgramType.ODPS_SQL.getCalcEngineType().getLabel());
        RUNTIME.setCommand(CodeProgramType.ODPS_SQL.getName());
    }
}

