/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.spark;

import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.OdpsSparkCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.dw.types.LanguageEnum;
import com.aliyun.dataworks.common.spec.domain.enums.SpecFileResourceType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecFileResource;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.utils.SparkArgsUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.spark.SparkParameters;
import com.aliyun.dataworks.migrationx.transformer.core.spark.command.SparkSubmitCommandBuilder;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.AbstractParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.context.DolphinSchedulerV3ConverterContext;
import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import com.google.common.base.Joiner;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;

public class SparkParameterConverter
extends AbstractParameterConverter<SparkParameters> {
    private static final String SQL_EXECUTION_TYPE_FILE = "FILE";
    private static final String RESOURCE_REFERENCE_SQL_PREFIX = "--";

    public SparkParameterConverter(DataWorksWorkflowSpec spec, SpecWorkflow specWorkflow, TaskDefinition taskDefinition, DolphinSchedulerV3ConverterContext context) {
        super(spec, specWorkflow, taskDefinition, context);
    }

    @Override
    protected void convertParameter(SpecNode specNode) {
        List<SpecVariable> specVariableList = this.convertSpecNodeParam(specNode);
        this.convertFileResourceList(specNode);
        ProgramType programType = ((SparkParameters)this.parameter).getProgramType();
        switch (programType) {
            case SQL: {
                this.convertSparkSql(specNode, specVariableList);
                break;
            }
            case JAVA: 
            case PYTHON: 
            case SCALA: {
                this.convertSparkJar(specNode, specVariableList);
                break;
            }
            default: {
                throw new BizException(ErrorCode.UNKNOWN_ENUM_TYPE, new Object[]{"ProgramType", programType});
            }
        }
    }

    private void convertSparkSql(SpecNode specNode, List<SpecVariable> specVariableList) {
        if (SQL_EXECUTION_TYPE_FILE.equals(((SparkParameters)this.parameter).getSqlExecutionType())) {
            return;
        }
        SpecScript script = new SpecScript();
        script.setId(this.generateUuid());
        script.setLanguage(LanguageEnum.SPARK_SQL.getIdentifier());
        SpecScriptRuntime specScriptRuntime = new SpecScriptRuntime();
        specScriptRuntime.setEngine(CodeProgramType.ODPS_SQL.getCalcEngineType().getLabel());
        specScriptRuntime.setCommand(CodeProgramType.ODPS_SQL.getName());
        script.setRuntime(specScriptRuntime);
        script.setParameters(ListUtils.emptyIfNull(specVariableList).stream().filter(v -> !VariableType.NODE_OUTPUT.equals((Object)v.getType())).collect(Collectors.toList()));
        script.setPath(this.getScriptPath(specNode));
        String resourceReference = this.buildFileResourceReference(specNode, RESOURCE_REFERENCE_SQL_PREFIX);
        script.setContent(resourceReference + ((SparkParameters)this.parameter).getRawScript());
        specNode.setScript(script);
    }

    private void convertSparkJar(SpecNode specNode, List<SpecVariable> specVariableList) {
        SpecScript script = new SpecScript();
        script.setId(this.generateUuid());
        script.setLanguage(LanguageEnum.JSON.getIdentifier());
        SpecScriptRuntime specScriptRuntime = new SpecScriptRuntime();
        specScriptRuntime.setEngine(CodeProgramType.ODPS_SPARK.getCalcEngineType().getLabel());
        specScriptRuntime.setCommand(CodeProgramType.ODPS_SPARK.getName());
        script.setRuntime(specScriptRuntime);
        script.setPath(this.getScriptPath(specNode));
        script.setParameters(ListUtils.emptyIfNull(specVariableList).stream().filter(v -> !VariableType.NODE_OUTPUT.equals((Object)v.getType())).collect(Collectors.toList()));
        List<String> args = this.dealArgs(SparkArgsUtils.buildArgs((SparkParameters)((SparkParameters)this.parameter)));
        script.setContent(this.parseOdpsSparkJson(specNode, args));
        specNode.setScript(script);
    }

    private List<String> dealArgs(List<String> args) {
        return ListUtils.emptyIfNull(args).stream().collect(ArrayList::new, (list, arg) -> list.addAll(Arrays.asList(arg.split(" "))), ArrayList::addAll);
    }

    private String parseOdpsSparkJson(SpecNode specNode, List<String> args) {
        SparkSubmitCommandBuilder sparkSubmitCommandBuilder = new SparkSubmitCommandBuilder(args);
        OdpsSparkCode odpsSparkCode = new OdpsSparkCode();
        odpsSparkCode.setProgramType(CodeProgramType.ODPS_SPARK.name());
        List referenceResources = ListUtils.emptyIfNull((List)specNode.getFileResources()).stream().map(SpecFileResource::getName).collect(Collectors.toList());
        odpsSparkCode.setResourceReferences(referenceResources);
        OdpsSparkCode.CodeJson sparkJson = new OdpsSparkCode.CodeJson();
        String mainApp = new File(sparkSubmitCommandBuilder.getAppResource()).getName();
        if (mainApp.endsWith("jar")) {
            sparkJson.setMainJar(mainApp);
            sparkJson.setLanguage("java");
        }
        if (mainApp.endsWith("py")) {
            sparkJson.setMainPy(mainApp);
            sparkJson.setLanguage("python");
        }
        sparkJson.setArgs(Joiner.on((String)" ").join(sparkSubmitCommandBuilder.getAppArgs()));
        Map<SpecFileResourceType, List<SpecFileResource>> specFileResourceTypeListMap = ListUtils.emptyIfNull((List)specNode.getFileResources()).stream().collect(Collectors.groupingBy(SpecFileResource::getType));
        sparkJson.setAssistFiles(this.getReferenceResourceNameList(specFileResourceTypeListMap.get(SpecFileResourceType.FILE), mainApp));
        sparkJson.setAssistJars(this.getReferenceResourceNameList(specFileResourceTypeListMap.get(SpecFileResourceType.JAR), mainApp));
        sparkJson.setAssistPys(this.getReferenceResourceNameList(specFileResourceTypeListMap.get(SpecFileResourceType.PYTHON), mainApp));
        List<String> archiveFileNameList = this.getReferenceResourceNameList(specFileResourceTypeListMap.get(SpecFileResourceType.ARCHIVE), mainApp);
        sparkJson.setAssistArchives(archiveFileNameList);
        sparkJson.setArchivesName(archiveFileNameList);
        sparkJson.setMainClass(sparkSubmitCommandBuilder.getMainClass());
        sparkSubmitCommandBuilder.getConf().put("spark.hadoop.odps.task.major.version", "cupid_v2");
        sparkJson.setConfigs(sparkSubmitCommandBuilder.getConf().entrySet().stream().map(ent -> Joiner.on((String)"=").join(ent.getKey(), ent.getValue(), new Object[0])).collect(Collectors.toList()));
        odpsSparkCode.setSparkJson(sparkJson);
        return odpsSparkCode.getContent();
    }

    private List<String> getReferenceResourceNameList(List<SpecFileResource> specFileResources, String mainApp) {
        return ListUtils.emptyIfNull(specFileResources).stream().map(SpecFileResource::getName).filter(name -> StringUtils.isNotBlank((CharSequence)name) && !name.equals(mainApp)).collect(Collectors.toList());
    }
}

