/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common;

import com.aliyun.dataworks.common.spec.domain.enums.VariableScopeType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.enums.Direct;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.Property;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.AbstractCommonConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.context.DolphinSchedulerV3ConverterContext;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;

public class ParamListConverter
extends AbstractCommonConverter<List<SpecVariable>> {
    public static final String SYSTEM_VARIABLE_TAG = "$";
    private final List<Property> paramList;
    private final TaskDefinition taskDefinition;

    public ParamListConverter(List<Property> paramList, DolphinSchedulerV3ConverterContext context) {
        this(paramList, null, context);
    }

    public ParamListConverter(List<Property> paramList, TaskDefinition taskDefinition, DolphinSchedulerV3ConverterContext context) {
        super(context);
        this.paramList = paramList;
        this.taskDefinition = taskDefinition;
    }

    @Override
    public List<SpecVariable> convert() {
        return ListUtils.emptyIfNull(this.paramList).stream().map(p -> {
            if (Objects.isNull(this.taskDefinition) && Direct.OUT.equals((Object)p.getDirect())) {
                return null;
            }
            SpecVariable specVariable = new SpecVariable();
            specVariable.setId(this.generateUuid());
            specVariable.setName(p.getProp());
            specVariable.setValue(p.getValue());
            specVariable.setDescription(p.getType().name());
            if (Direct.IN.equals((Object)p.getDirect())) {
                if (specVariable.getValue().startsWith(SYSTEM_VARIABLE_TAG)) {
                    specVariable.setType(VariableType.SYSTEM);
                } else {
                    specVariable.setType(VariableType.CONSTANT);
                }
                specVariable.setScope(Objects.isNull(this.taskDefinition) ? VariableScopeType.FLOW : VariableScopeType.NODE_PARAMETER);
            } else {
                specVariable.setType(VariableType.NODE_OUTPUT);
                specVariable.setScope(VariableScopeType.NODE_CONTEXT);
            }
            return specVariable;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

