/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common;

import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.parameters.AbstractParameters;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.AbstractCommonConverter;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.AbstractNodeConverter;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.NodeConverterFactory;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.context.FlowSpecConverterContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;

public class TaskDefinitionListConverter
extends AbstractCommonConverter<List<TaskDefinition>> {
    private final DataWorksWorkflowSpec spec;
    private final SpecWorkflow workflow;

    public TaskDefinitionListConverter(DataWorksWorkflowSpec spec, SpecWorkflow workflow, List<TaskDefinition> result, FlowSpecConverterContext context) {
        super(Objects.nonNull(result) ? result : new ArrayList(), context);
        this.spec = spec;
        this.workflow = workflow;
    }

    public TaskDefinitionListConverter(DataWorksWorkflowSpec spec, SpecWorkflow workflow, FlowSpecConverterContext context) {
        this(spec, workflow, null, context);
    }

    @Override
    public List<TaskDefinition> convert() {
        if (Objects.isNull(this.spec)) {
            return (List)this.result;
        }
        if (Objects.isNull(this.workflow)) {
            return this.convertNodeList(this.spec.getNodes());
        }
        return this.convertNodeList(this.workflow.getNodes());
    }

    private List<TaskDefinition> convertNodeList(List<SpecNode> specNodeList) {
        return ListUtils.emptyIfNull(specNodeList).stream().filter(Objects::nonNull).map(specNode -> {
            AbstractNodeConverter<? extends AbstractParameters> nodeConverter = NodeConverterFactory.create(specNode, this.context);
            return nodeConverter.convert();
        }).collect(Collectors.toList());
    }
}

