/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.transformer;

import com.aliyun.dataworks.common.spec.SpecUtil;
import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.Spec;
import com.aliyun.dataworks.common.spec.domain.Specification;
import com.aliyun.dataworks.common.spec.domain.enums.SpecKind;
import com.aliyun.dataworks.common.spec.domain.enums.SpecVersion;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.utils.JSONUtils;
import com.aliyun.dataworks.migrationx.domain.adf.AdfConf;
import com.aliyun.dataworks.migrationx.domain.adf.AdfPackage;
import com.aliyun.dataworks.migrationx.domain.adf.AdfPackageFileService;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DataWorksPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.standard.objects.Package;
import com.aliyun.dataworks.migrationx.transformer.core.transformer.AbstractPackageTransformer;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.adf.AdfConverter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataWorksAdfTransformer
extends AbstractPackageTransformer<AdfPackage, DataWorksPackage> {
    private static final Logger log = LoggerFactory.getLogger(DataWorksAdfTransformer.class);
    private AdfConf adfConf;
    private List<Specification<DataWorksWorkflowSpec>> specs;

    public DataWorksAdfTransformer(File configFile, AdfPackage sourcePackage, DataWorksPackage targetPackage) {
        super(configFile, sourcePackage, targetPackage);
        this.sourcePackageFileService = new AdfPackageFileService();
        this.adfConf = this.loadConf(configFile);
    }

    public AdfConf loadConf(File configFile) {
        try {
            String config = FileUtils.readFileToString((File)configFile, (Charset)StandardCharsets.UTF_8);
            this.adfConf = (AdfConf)JSONUtils.parseObject((String)config, (TypeReference)new TypeReference<AdfConf>(){});
            return this.adfConf;
        }
        catch (IOException e) {
            log.warn("config file not exists: {}", (Object)configFile);
            return AdfConf.DEFAULT;
        }
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public void load() throws Exception {
        this.sourcePackageFileService.load((Package)((AdfPackage)this.sourcePackage));
    }

    @Override
    public void transform() throws Exception {
        AdfConverter converter = new AdfConverter((AdfPackage)this.sourcePackageFileService.getPackage(), this.adfConf);
        List<SpecWorkflow> workflows = converter.convert();
        this.specs = new ArrayList<Specification<DataWorksWorkflowSpec>>(workflows.size());
        for (SpecWorkflow w : workflows) {
            Specification<DataWorksWorkflowSpec> workflowSpecFile = this.toWorkflowSpecFile(w);
            this.specs.add(workflowSpecFile);
        }
    }

    private Specification<DataWorksWorkflowSpec> toWorkflowSpecFile(SpecWorkflow w) {
        DataWorksWorkflowSpec spec = new DataWorksWorkflowSpec();
        spec.setWorkflows((List)ImmutableList.of((Object)w));
        spec.setName(w.getName());
        Specification sp = new Specification();
        sp.setKind(SpecKind.CYCLE_WORKFLOW.getLabel());
        sp.setVersion(SpecVersion.V_1_1_0.getLabel());
        sp.setSpec((Spec)spec);
        return sp;
    }

    @Override
    public void write() throws Exception {
        File targetTmp;
        File packageFile = ((DataWorksPackage)this.targetPackage).getPackageFile();
        if (!packageFile.exists()) {
            FileUtils.forceMkdir((File)packageFile);
        }
        if ((targetTmp = new File(packageFile, ".tmp")).exists()) {
            FileUtils.deleteDirectory((File)targetTmp);
        }
        FileUtils.forceMkdir((File)targetTmp);
        this.specs.forEach(spec -> {
            String fileName = ((DataWorksWorkflowSpec)spec.getSpec()).getName();
            String pathname = targetTmp + "/" + fileName + ".json";
            File file = new File(pathname);
            try {
                FileUtils.writeStringToFile((File)file, (String)SpecUtil.writeToSpec((Specification)spec), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                log.error("failed to write file");
            }
        });
    }
}

