/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.ide;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.dw.types.ModelTreeRoot;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Asset;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.CostumedDateFormat;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwFolder;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwFunction;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNodeIo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwResource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwUserDefinedNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Function;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.NodeContext;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.NodeIo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Solution;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v2.IdeApplication;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v2.IdeBizInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v2.IdeEngineInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v2.IdeExportVersion;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v2.IdeFile;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v2.IdeNodeInputOutput;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v2.IdeSolution;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v2.IdeUdfContent;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v2.IdeUserDefinedNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.AssetType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.DmMajorVersion;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.NodeUseType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.RerunMode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.WorkflowVersion;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DefaultNodeTypeUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.NodeUtils;
import com.aliyun.dataworks.migrationx.transformer.core.annotation.DependsOn;
import com.aliyun.dataworks.migrationx.transformer.core.loader.ConfigPropertiesLoader;
import com.aliyun.dataworks.migrationx.transformer.core.report.ReportItem;
import com.aliyun.dataworks.migrationx.transformer.core.report.ReportItemType;
import com.aliyun.dataworks.migrationx.transformer.core.report.ReportRiskLevel;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.AbstractBaseConverter;
import com.aliyun.migrationx.common.utils.BeanUtils;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdeExportProjectConverter
extends AbstractBaseConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdeExportProjectConverter.class);
    public static final String DIR_FILE_CONTENT = "file_content";
    public static final String DIR_RESOURCE = "resource";
    public static final String FILE_ENGINE_INFO = "engineinfo.txt";
    public static final String FILE_USER_NODE_INFO = "userNodeInfo.txt";
    public static final String FILE_VERSION = "version.txt";
    public static final Pattern IO_PATTERN_ID = Pattern.compile("(\\w+)\\.\\d+_out");
    @DependsOn
    private ConfigPropertiesLoader propertiesLoader;
    private Project project;
    private File unzippedPath;

    public IdeExportProjectConverter() {
        super(AssetType.DW_EXPORT, IdeExportProjectConverter.class.getSimpleName());
    }

    private void convertWorkflow(IdeApplication ideApp) {
        this.project.setWorkflows(ListUtils.emptyIfNull((List)ideApp.getBizInfos()).stream().map(ideBizInfo -> this.convertBizInfo(ideApp, (IdeBizInfo)ideBizInfo)).collect(Collectors.toList()));
        this.project.setAdHocQueries(ListUtils.emptyIfNull((List)ideApp.getOtherFiles()).stream().filter(ideFile -> ideFile.getUseType().equals(NodeUseType.AD_HOC.getValue())).map(ideFile -> this.convertIdeFileToNode((IdeFile)ideFile)).collect(Collectors.toList()));
        File fileContentDir = new File(this.unzippedPath, DIR_FILE_CONTENT);
        this.project.setComponents(this.restoreOthers(fileContentDir, NodeUseType.COMPONENT, ModelTreeRoot.COMPONENT_ROOT.getRootKey()));
        this.processOldWorkflow(this.project, ideApp);
    }

    private List<Node> restoreOthers(File unzippedDir, NodeUseType nodeUseType, String dirName) {
        File tablesDir = new File(unzippedDir, dirName);
        if (!tablesDir.exists()) {
            return null;
        }
        List<Node> nodes = FileUtils.listFiles((File)tablesDir, (String[])new String[]{"xml"}, (boolean)false).stream().map(file -> {
            try {
                XmlMapper xmlMapper = new XmlMapper();
                xmlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                DwNode node = (DwNode)xmlMapper.readValue(file, DwNode.class);
                node.setNodeUseType(nodeUseType);
                return node;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        return nodes;
    }

    private void processOldWorkflow(Project project, IdeApplication ideApp) {
        boolean hasOldWorkflow = ListUtils.emptyIfNull((List)ideApp.getFolders()).stream().anyMatch(ideFolder -> StringUtils.startsWith((CharSequence)ideFolder.getFolderItemPath(), (CharSequence)"workflowroot"));
        if (!hasOldWorkflow) {
            return;
        }
        DwWorkflow oldWorkflow = new DwWorkflow();
        oldWorkflow.setScheduled(Boolean.valueOf(true));
        oldWorkflow.setName("OLD_VERSION_WORKFLOW");
        oldWorkflow.setProjectRef(project);
        ListUtils.emptyIfNull((List)ideApp.getOtherFiles()).stream().filter(ideFile -> StringUtils.isBlank((CharSequence)ideFile.getBizIdStr()) && StringUtils.startsWith((CharSequence)ideFile.getFolderPath(), (CharSequence)"workflowroot")).forEach(ideFile -> this.convertIdeFile(oldWorkflow, (IdeFile)ideFile));
        ListUtils.emptyIfNull((List)ideApp.getInnerFiles()).stream().filter(ideFile -> StringUtils.isNotBlank((CharSequence)ideFile.getOuterFile()) && StringUtils.startsWith((CharSequence)ideFile.getOuterFile(), (CharSequence)"workflowroot")).forEach(ideFile -> this.convertInnerFile(oldWorkflow, (IdeFile)ideFile));
        ListUtils.emptyIfNull((List)ideApp.getUdfFiles()).stream().filter(ideFile -> StringUtils.isBlank((CharSequence)ideFile.getBizIdStr()) && StringUtils.startsWith((CharSequence)ideFile.getFolderPath(), (CharSequence)"workflowroot")).forEach(ideFile -> this.convertIdeFile(oldWorkflow, (IdeFile)ideFile));
        ListUtils.emptyIfNull((List)ideApp.getResourceFiles()).stream().filter(ideFile -> StringUtils.isBlank((CharSequence)ideFile.getBizIdStr()) && StringUtils.startsWith((CharSequence)ideFile.getFolderPath(), (CharSequence)"workflowroot")).forEach(ideFile -> this.convertIdeFile(oldWorkflow, (IdeFile)ideFile));
        project.getWorkflows().add(oldWorkflow);
    }

    private Solution convertSolution(IdeSolution ideSolution) {
        Solution solution = new Solution();
        solution.setName(ideSolution.getSolutionName());
        solution.setDescription(ideSolution.getSolDesc());
        solution.setOwner(ideSolution.getOwner());
        solution.setDmMajorVersion(this.project.getDmMajorVersion());
        return solution;
    }

    private DwWorkflow convertBizInfo(IdeApplication ideApp, IdeBizInfo ideBizInfo) {
        DwWorkflow dwWorkflow = new DwWorkflow();
        dwWorkflow.setScheduled(Boolean.valueOf(ideBizInfo.getUseType() == 0));
        dwWorkflow.setName(ideBizInfo.getBizName());
        dwWorkflow.setProjectRef(this.project);
        dwWorkflow.setDmMajorVersion(this.project.getDmMajorVersion());
        dwWorkflow.setOwner(ideBizInfo.getOwner());
        dwWorkflow.setParameters(ideBizInfo.getParameters());
        if (ideBizInfo.getVersion() != null && Integer.valueOf(1).equals(ideBizInfo.getVersion())) {
            dwWorkflow.setVersion(WorkflowVersion.V3);
        } else {
            dwWorkflow.setVersion(WorkflowVersion.V2);
        }
        LOGGER.debug("dwWorkflow: {}", (Object)dwWorkflow);
        ListUtils.emptyIfNull((List)ideApp.getUdfFiles()).stream().filter(ideFile -> ideBizInfo.getBizName().equals(ideFile.getBizIdStr())).filter(ideFile -> ideFile.getBizUseType().equals(ideBizInfo.getUseType())).forEach(ideFile -> this.convertIdeFile(dwWorkflow, (IdeFile)ideFile));
        ListUtils.emptyIfNull((List)ideApp.getResourceFiles()).stream().filter(ideFile -> ideBizInfo.getBizName().equals(ideFile.getBizIdStr())).filter(ideFile -> ideFile.getBizUseType().equals(ideBizInfo.getUseType())).forEach(ideFile -> this.convertIdeFile(dwWorkflow, (IdeFile)ideFile));
        ListUtils.emptyIfNull((List)ideApp.getOtherFiles()).stream().filter(ideFile -> ideBizInfo.getBizName().equals(ideFile.getBizIdStr())).filter(ideFile -> ideFile.getBizUseType().equals(ideBizInfo.getUseType())).forEach(ideFile -> this.convertIdeFile(dwWorkflow, (IdeFile)ideFile));
        ListUtils.emptyIfNull((List)ideApp.getInnerFiles()).stream().filter(ideFile -> StringUtils.isNotBlank((CharSequence)ideFile.getOuterFile())).forEach(ideFile -> this.convertInnerFile(dwWorkflow, (IdeFile)ideFile));
        return dwWorkflow;
    }

    private void convertInnerFile(DwWorkflow dwWorkflow, IdeFile ideFile) {
        String outerFile = ideFile.getOuterFile();
        String[] folders = StringUtils.split((String)outerFile, (String)"/");
        if (!StringUtils.startsWith((CharSequence)outerFile, (CharSequence)"workflowroot")) {
            if (folders.length < 4) {
                LOGGER.warn("outer file path folder invalid: {}", (Object)outerFile);
                return;
            }
            String workflowName = folders[1];
            if (!workflowName.equals(dwWorkflow.getName())) {
                return;
            }
        }
        String nodeName = folders[folders.length - 1];
        dwWorkflow.getNodes().stream().filter(node -> node.getName().equals(nodeName)).filter(node -> outerFile.startsWith(node.getFolder())).findAny().ifPresent(node -> node.getInnerNodes().add(this.convertIdeFileToNode(ideFile)));
    }

    private void convertIdeFile(DwWorkflow dwWorkflow, IdeFile ideFile) {
        if (DefaultNodeTypeUtils.isResource((Integer)ideFile.getFileType())) {
            dwWorkflow.getResources().add(this.convertResource(dwWorkflow, ideFile));
        } else if (DefaultNodeTypeUtils.isFunction((Integer)ideFile.getFileType())) {
            dwWorkflow.getFunctions().add(this.convertFunction(dwWorkflow, ideFile));
        } else {
            dwWorkflow.getNodes().add(this.convertIdeFileToNode(ideFile));
        }
        dwWorkflow.setDmMajorVersion(this.project.getDmMajorVersion());
    }

    private DwNode convertIdeFileToNode(IdeFile ideFile) {
        LOGGER.debug("ideFile: {}", (Object)ideFile);
        DwNode node = new DwNode();
        node.setDmMajorVersion(this.project.getDmMajorVersion());
        node.setName(ideFile.getFileName());
        CodeProgramType type = CodeProgramType.getNodeTypeByCode((int)ideFile.getFileType());
        if (type == null) {
            node.setType(CodeProgramType.VIRTUAL.name());
            ReportItem reportItem = new ReportItem();
            reportItem.setName(ideFile.getFileName());
            reportItem.setType(ReportItemType.UNSUPPORTED_JOB_TYPE.name());
            reportItem.setMessage("set node as default virtual type: " + CodeProgramType.VIRTUAL.name());
            this.reportItems.add(reportItem);
        } else {
            node.setType(type.name());
        }
        node.setCode(ideFile.getContent());
        if (CollectionUtils.isNotEmpty((Collection)ideFile.getFileRelations())) {
            node.setFileRelations(GsonUtils.gson.toJson((Object)ideFile.getFileRelations()));
        }
        if (ideFile.getNodeDef() != null) {
            List outputs;
            List inputs;
            node.setPauseSchedule(Boolean.valueOf(ideFile.getNodeDef().getIsStop() != null && ideFile.getNodeDef().getIsStop() == 1));
            node.setStartRightNow(ideFile.getNodeDef().getStartRightNow());
            node.setCronExpress(ideFile.getNodeDef().getCronExpress());
            node.setParameter(ideFile.getNodeDef().getParaValue());
            if (ideFile.getNodeDef().getReRunAble() == null) {
                node.setRerunMode(RerunMode.ALL_ALLOWED);
            } else {
                node.setRerunMode(RerunMode.getByValue((int)ideFile.getNodeDef().getReRunAble()));
            }
            node.setResourceGroup(ideFile.getNodeDef().getResgroupId());
            node.setCycleType(ideFile.getNodeDef().getCycleType());
            node.setLastModifyTime(ideFile.getNodeDef().getLastModifyTime());
            node.setLastModifyUser(ideFile.getNodeDef().getLastModifyUser());
            node.setMultiInstCheckType(ideFile.getNodeDef().getMultiinstCheckType());
            node.setPriority(ideFile.getNodeDef().getPriority());
            node.setDependentType(ideFile.getNodeDef().getDependentType());
            node.setStartEffectDate(ideFile.getNodeDef().getStartEffectDate());
            node.setEndEffectDate(ideFile.getNodeDef().getEndEffectDate());
            node.setTaskRerunInterval(ideFile.getNodeDef().getTaskRerunInterval());
            node.setTaskRerunTime(ideFile.getNodeDef().getTaskRerunTime());
            node.setDependentDataNode(ideFile.getNodeDef().getDependentDataNode());
            Type typeToken = new TypeToken<List<IdeNodeInputOutput>>(){}.getType();
            ArrayList nodeDefIos = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)ideFile.getNodeDef().getInput()) && CollectionUtils.isNotEmpty((Collection)(inputs = (List)GsonUtils.gson.fromJson(ideFile.getNodeDef().getInput(), typeToken)))) {
                inputs.stream().forEach(i -> i.setType(Integer.valueOf(0)));
                nodeDefIos.addAll(inputs);
            }
            if (StringUtils.isNotBlank((CharSequence)ideFile.getNodeDef().getOutput()) && CollectionUtils.isNotEmpty((Collection)(outputs = (List)GsonUtils.gson.fromJson(ideFile.getNodeDef().getOutput(), typeToken)))) {
                outputs.stream().forEach(o -> o.setType(Integer.valueOf(1)));
                nodeDefIos.addAll(outputs);
            }
            ideFile.setNodeInputOutputs(ListUtils.emptyIfNull((List)ideFile.getNodeInputOutputs()));
            nodeDefIos.stream().forEach(nodeDefIo -> {
                if (!ideFile.getNodeInputOutputs().stream().filter(io -> io.getType() != null && io.getStr() != null).anyMatch(io -> io.getType().equals(nodeDefIo.getType()) && io.getStr().equalsIgnoreCase(nodeDefIo.getStr()))) {
                    ideFile.getNodeInputOutputs().add(nodeDefIo);
                }
            });
        }
        LOGGER.debug("ideFile: {}", (Object)ideFile);
        node.setInputs(ListUtils.emptyIfNull((List)ideFile.getNodeInputOutputs()).stream().filter(io -> Integer.valueOf(0).equals(io.getType())).map(io -> this.convertIdeNodeInputOutput((IdeNodeInputOutput)io)).collect(Collectors.toList()));
        node.setOutputs(ListUtils.emptyIfNull((List)ideFile.getNodeInputOutputs()).stream().filter(io -> Integer.valueOf(1).equals(io.getType())).map(io -> this.convertIdeNodeInputOutput((IdeNodeInputOutput)io)).collect(Collectors.toList()));
        LOGGER.debug("node: {}", (Object)node);
        node.getInputs().stream().forEach(nodeIo -> this.convertIoStr(node, (NodeIo)nodeIo));
        node.getOutputs().stream().forEach(nodeIo -> this.convertIoStr(node, (NodeIo)nodeIo));
        node.setOwner(ideFile.getOwner());
        node.setExtend(ideFile.getExtend());
        node.setFileDelete(ideFile.getFileDelete());
        node.setIsAutoParse(ideFile.getIsAutoParse());
        node.setCommitStatus(ideFile.getCommitStatus());
        node.setIsUserNode(ideFile.getIsUserNode());
        node.setSourcePath(ideFile.getSourcePath());
        node.setFolder(ideFile.getFolderPath());
        node.setNodeUseType(NodeUseType.getNodeUseTypeByValue((int)ideFile.getUseType()));
        node.setConnection(ideFile.getConnName());
        node.setInputContexts(CollectionUtils.emptyIfNull((Collection)ideFile.getNodeInputOutputContexts()).stream().filter(io -> Integer.valueOf(0).equals(io.getType())).map(io -> {
            NodeContext ctx = new NodeContext();
            BeanUtils.copyProperties((Object)io, (Object)ctx);
            return ctx;
        }).collect(Collectors.toList()));
        node.setOutputContexts(CollectionUtils.emptyIfNull((Collection)ideFile.getNodeInputOutputContexts()).stream().filter(io -> Integer.valueOf(1).equals(io.getType())).map(io -> {
            NodeContext ctx = new NodeContext();
            BeanUtils.copyProperties((Object)io, (Object)ctx);
            return ctx;
        }).collect(Collectors.toList()));
        NodeUtils.parseNodeDiResGroupInfo((DwNode)node);
        return node;
    }

    private void convertIoStr(DwNode node, NodeIo nodeIo) {
        if (this.project == null || this.project.getExportProject() == null) {
            return;
        }
        Matcher m = IO_PATTERN_ID.matcher(nodeIo.getData());
        String io = nodeIo.getData();
        if (m.matches()) {
            io = RegExUtils.replaceFirst((String)io, (String)"^\\w+", (String)this.project.getName());
        }
        String exportProjectIdentifier = this.project.getExportProject().getName();
        String nodeName = node.getName();
        String pattern = exportProjectIdentifier + "." + nodeName;
        if (Pattern.matches(pattern, io)) {
            io = RegExUtils.replaceFirst((String)io, (String)exportProjectIdentifier, (String)this.project.getName());
        }
        if (Pattern.matches(exportProjectIdentifier + "_root", io)) {
            io = RegExUtils.replaceFirst((String)io, (String)exportProjectIdentifier, (String)this.project.getName());
        }
        nodeIo.setData(io);
    }

    private NodeIo convertIdeNodeInputOutput(IdeNodeInputOutput ideNodeInputOutput) {
        DwNodeIo nodeIo = new DwNodeIo();
        nodeIo.setRefTableName(ideNodeInputOutput.getRefTableName());
        nodeIo.setData(ideNodeInputOutput.getStr());
        nodeIo.setParseType(ideNodeInputOutput.getParseType());
        nodeIo.setParentId(ideNodeInputOutput.getParentId());
        nodeIo.setIsDifferentApp(ideNodeInputOutput.getIsDifferentApp());
        return nodeIo;
    }

    private Function convertFunction(DwWorkflow dwWorkflow, IdeFile ideFile) {
        DwFunction function = new DwFunction();
        function.setName(ideFile.getFileName());
        function.setType(CodeProgramType.getNodeTypeNameByCode((int)ideFile.getFileType()));
        if (StringUtils.isNotBlank((CharSequence)ideFile.getContent())) {
            IdeUdfContent ideUdfContent = (IdeUdfContent)GsonUtils.gson.fromJson(ideFile.getContent(), new TypeToken<IdeUdfContent>(){}.getType());
            function.setArguments(ideUdfContent.getParamDesc());
            function.setDescription(ideUdfContent.getDescription());
            function.setCommand(ideUdfContent.getCmdDesc());
            function.setClazz(ideUdfContent.getClassName());
            function.setResource(ideUdfContent.getResources());
            function.setExample(ideUdfContent.getExample());
            function.setReturnValue(ideUdfContent.getReturnValue());
        }
        function.setFolder(ideFile.getFolderPath());
        function.setOwner(this.project.getOpUser());
        function.setWorkflowRef(dwWorkflow);
        function.setDmMajorVersion(this.project.getDmMajorVersion());
        return function;
    }

    private DwResource convertResource(DwWorkflow dwWorkflow, IdeFile resource) {
        DwResource dwResource = new DwResource();
        dwResource.setOriginResourceName(resource.getOriginResourceName());
        dwResource.setLocalPath(resource.getSourcePath());
        dwResource.setName(resource.getFileName());
        dwResource.setType(CodeProgramType.getNodeTypeByCode((int)resource.getFileType()).name());
        dwResource.setLargeFile(Boolean.valueOf(resource.getIsLarge() != null && resource.getIsLarge() == 1));
        dwResource.setOdps(Boolean.valueOf(resource.getIsOdps() != null && resource.getIsOdps() == 1));
        dwResource.setOwner(this.project.getOpUser());
        dwResource.setWorkflowRef(dwWorkflow);
        dwResource.setDmMajorVersion(this.project.getDmMajorVersion());
        dwResource.setFolder(resource.getFolderPath());
        return dwResource;
    }

    private File getApplicationXml(File unzippedPath) {
        File[] xmlFiles = unzippedPath.listFiles(f -> f.isFile() && f.getName().endsWith(".xml"));
        if (xmlFiles.length == 0) {
            throw new RuntimeException("application xml not found in path: " + unzippedPath.getAbsolutePath());
        }
        if (xmlFiles.length > 1) {
            throw new RuntimeException("multiple xml found in path: " + unzippedPath.getAbsolutePath());
        }
        return xmlFiles[0];
    }

    private IdeApplication readIdeApplication(File unzippedPath) throws IOException {
        String wholeXmlContent = IOUtils.toString((InputStream)new FileInputStream(this.getApplicationXml(unzippedPath)), (String)"utf-8");
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        xmlMapper.setDateFormat((DateFormat)new CostumedDateFormat());
        IdeApplication ideApp = (IdeApplication)xmlMapper.readValue(wholeXmlContent, IdeApplication.class);
        Optional.ofNullable(ideApp.getUdfFiles()).ifPresent(list -> list.stream().forEach(ideFile -> this.readIdeFileContent(unzippedPath, (IdeFile)ideFile)));
        Optional.ofNullable(ideApp.getOtherFiles()).ifPresent(list -> list.stream().forEach(ideFile -> this.readIdeFileContent(unzippedPath, (IdeFile)ideFile)));
        Optional.ofNullable(ideApp.getInnerFiles()).ifPresent(list -> list.stream().forEach(ideFile -> this.readIdeFileContent(unzippedPath, (IdeFile)ideFile)));
        CollectionUtils.union((Iterable)ListUtils.emptyIfNull((List)ideApp.getResourceFiles()), (Iterable)ListUtils.emptyIfNull((List)ideApp.getOtherFiles())).stream().filter(f -> DefaultNodeTypeUtils.isResource((Integer)f.getFileType())).forEach(ideFile -> {
            try {
                this.adjustSourcePath(unzippedPath, (IdeFile)ideFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        this.readIdeEngineInfos(unzippedPath, ideApp);
        this.readIdeUseDefinedNodes(unzippedPath, ideApp);
        this.readIdeExportVersion(unzippedPath, ideApp);
        return ideApp;
    }

    private void readIdeExportVersion(File unzippedPath, IdeApplication ideApp) throws IOException {
        File versionTxtFile = new File(Joiner.on((String)File.separator).join((Object)unzippedPath.getAbsolutePath(), (Object)FILE_VERSION, new Object[0]));
        if (versionTxtFile.exists()) {
            String versionTxt = IOUtils.toString((Reader)new FileReader(versionTxtFile));
            IdeExportVersion ideExportVersion = IdeExportVersion.valueOf((String)versionTxt);
            ideApp.setVersion(ideExportVersion);
        }
    }

    private void readIdeUseDefinedNodes(File unzippedPath, IdeApplication ideApp) throws IOException {
        File userNodeInfoTxtFile = new File(Joiner.on((String)File.separator).join((Object)unzippedPath.getAbsolutePath(), (Object)FILE_USER_NODE_INFO, new Object[0]));
        if (userNodeInfoTxtFile.exists()) {
            String userNodeInfoTxt = IOUtils.toString((Reader)new FileReader(userNodeInfoTxtFile));
            Map userNodeInfo = (Map)GsonUtils.gson.fromJson(userNodeInfoTxt, new TypeToken<HashMap<String, List<IdeUserDefinedNode>>>(){}.getType());
            ideApp.setUserDefinedNodeList((List)userNodeInfo.get("userNodeList"));
        }
    }

    private void readIdeEngineInfos(File unzippedPath, IdeApplication ideApp) throws IOException {
        File engineInfoTxtFile = new File(Joiner.on((String)File.separator).join((Object)unzippedPath.getAbsolutePath(), (Object)FILE_ENGINE_INFO, new Object[0]));
        if (engineInfoTxtFile.exists()) {
            String engineInfoTxt = IOUtils.toString((Reader)new FileReader(engineInfoTxtFile));
            IdeEngineInfo engineInfo = (IdeEngineInfo)GsonUtils.gson.fromJson(engineInfoTxt, new TypeToken<IdeEngineInfo>(){}.getType());
            ideApp.setEngineInfo(engineInfo);
        }
    }

    private void adjustSourcePath(File unzippedPath, IdeFile ideFile) throws IOException {
        File sourcePath;
        String resourceName;
        String string = resourceName = StringUtils.isNotBlank((CharSequence)ideFile.getOriginResourceName()) ? ideFile.getOriginResourceName() : ideFile.getFileName();
        if (Integer.valueOf(CodeProgramType.ODPS_PYTHON.getCode()).equals(ideFile.getFileType()) || Integer.valueOf(CodeProgramType.ODPS_FILE.getCode()).equals(ideFile.getFileType())) {
            resourceName = resourceName + ".txt";
        }
        if (!(sourcePath = new File(unzippedPath, Joiner.on((String)File.separator).join((Object)DIR_RESOURCE, (Object)resourceName, new Object[0]))).exists() && StringUtils.isNotBlank((CharSequence)ideFile.getSourcePath()) && ideFile.getSourcePath().startsWith(File.separator)) {
            sourcePath = new File(unzippedPath, ideFile.getSourcePath());
        }
        if (!sourcePath.exists()) {
            sourcePath = new File(unzippedPath, Joiner.on((String)File.separator).join((Object)DIR_FILE_CONTENT, (Object)ideFile.getFolderPath(), new Object[]{resourceName}));
        }
        if (!sourcePath.exists()) {
            String msg = String.format("resource file not found: %s, fake it instead.", sourcePath.getAbsoluteFile());
            LOGGER.warn(msg);
            sourcePath.getParentFile().mkdirs();
            FileUtils.writeStringToFile((File)sourcePath, (String)"this is a fake file for not existed resource", (String)"utf-8");
            ReportItem reportItem = new ReportItem();
            reportItem.setName(ideFile.getFileName());
            reportItem.setMessage(msg);
            reportItem.setRiskLevel(ReportRiskLevel.STRONG_WARNINGS);
            reportItem.setType(ReportItemType.RESOURCE_FILE_NOT_FOUND.name());
            this.reportItems.add(reportItem);
        }
        ideFile.setSourcePath(sourcePath.getAbsolutePath());
    }

    private void readIdeFileContent(File unzippedPath, IdeFile ideFile) {
        if (StringUtils.isBlank((CharSequence)ideFile.getSourcePath())) {
            return;
        }
        File contentFile = new File(unzippedPath, Joiner.on((String)File.separator).join((Object)DIR_FILE_CONTENT, (Object)ideFile.getSourcePath(), new Object[0]));
        if (contentFile.exists()) {
            try {
                String content = IOUtils.toString((InputStream)new FileInputStream(contentFile), (String)"utf-8");
                ideFile.setContent(content);
            }
            catch (IOException e) {
                LOGGER.warn("ide file content not found: {}", (Object)ideFile.getSourcePath());
            }
        }
    }

    @Override
    public List<DwWorkflow> convert(Asset asset) throws Exception {
        Preconditions.checkNotNull((Object)asset, (Object)"asset is null");
        Preconditions.checkNotNull((Object)asset.getPath(), (Object)"dw export unzipped directory is null");
        File unzippedPath = asset.getPath();
        Preconditions.checkArgument((boolean)unzippedPath.exists(), (Object)"unzipped export project directory not exists");
        this.unzippedPath = unzippedPath;
        IdeApplication ideApp = this.readIdeApplication(unzippedPath);
        Preconditions.checkNotNull((Object)ideApp, (Object)"read null IdeApplication");
        this.convertProject(ideApp);
        this.convertWorkflow(ideApp);
        this.convertFolder(ideApp);
        this.convertUserDefinedNodes(ideApp);
        this.convertSolution(ideApp);
        this.workflowList = ListUtils.emptyIfNull((List)this.project.getWorkflows()).stream().map(workflow -> {
            DwWorkflow dwWorkflow = new DwWorkflow();
            BeanUtils.copyProperties((Object)workflow, (Object)dwWorkflow);
            return dwWorkflow;
        }).collect(Collectors.toList());
        return this.workflowList;
    }

    private void convertSolution(IdeApplication ideApp) {
        this.project.setSolutions(ListUtils.emptyIfNull((List)ideApp.getSolutions()).stream().map(ideSolution -> this.convertSolution((IdeSolution)ideSolution)).collect(Collectors.toList()));
    }

    private void convertProject(IdeApplication ideApp) {
        this.project.setEngineInfo(ideApp.getEngineInfo());
        this.project.setDmMajorVersion(DmMajorVersion.DATAWORKS_V2.name());
        if (IdeExportVersion.V2.equals((Object)ideApp.getVersion())) {
            this.project.setDmMajorVersion(DmMajorVersion.DATAWORKS_V2.name());
        }
        if (IdeExportVersion.V3.equals((Object)ideApp.getVersion())) {
            this.project.setDmMajorVersion(DmMajorVersion.DATAWORKS_V3.name());
        }
        if (StringUtils.isNotBlank((CharSequence)ideApp.getProjectIdentifier())) {
            this.project.setName(ideApp.getProjectIdentifier());
        }
    }

    private void convertUserDefinedNodes(IdeApplication ideApp) {
        List userDefinedNodes = ideApp.getUserDefinedNodeList();
        this.project.setUserDefinedNodes(ListUtils.emptyIfNull((List)userDefinedNodes).stream().map(ideUserDefinedNode -> {
            DwUserDefinedNode userDefinedNode = new DwUserDefinedNode();
            BeanUtils.copyProperties((Object)ideUserDefinedNode, (Object)userDefinedNode);
            userDefinedNode.setProjectRef(this.project);
            userDefinedNode.setDmMajorVersion(this.project.getDmMajorVersion());
            return userDefinedNode;
        }).collect(Collectors.toList()));
    }

    private void convertFolder(IdeApplication ideApp) {
        this.project.setFolders(ListUtils.emptyIfNull((List)ideApp.getFolders()).stream().map(ideFolder -> {
            DwFolder folder = new DwFolder();
            BeanUtils.copyProperties((Object)ideFolder, (Object)folder);
            folder.setDmMajorVersion(this.project.getDmMajorVersion());
            return folder;
        }).collect(Collectors.toList()));
        this.project.getWorkflows().stream().forEach(workflow -> this.project.getFolders().stream().filter(folder -> workflow.getName().equals(folder.getBizId())).forEach(folder -> ((DwFolder)folder).setWorkflowRef((DwWorkflow)workflow)));
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }
}

