/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.emr;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrAllocationSpec;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrCode;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrJobMode;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrJobType;
import com.aliyun.dataworks.common.spec.domain.dw.types.CalcEngineType;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.dw.types.ModelTreeRoot;
import com.aliyun.dataworks.migrationx.domain.dataworks.aliyunemr.AliyunEmrProject;
import com.aliyun.dataworks.migrationx.domain.dataworks.aliyunemr.Flow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Asset;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwDatasource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.NodeIo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Workflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.AssetType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.NodeUseType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.WorkflowVersion;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.tenant.EnvType;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.CronExpressUtil;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DefaultNodeTypeUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.NodeUtils;
import com.aliyun.dataworks.migrationx.transformer.core.RawNodeType;
import com.aliyun.dataworks.migrationx.transformer.core.loader.ProjectAssetLoader;
import com.aliyun.dataworks.migrationx.transformer.core.report.ReportItem;
import com.aliyun.dataworks.migrationx.transformer.core.report.ReportItemType;
import com.aliyun.dataworks.migrationx.transformer.core.report.ReportRiskLevel;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DICode;
import com.aliyun.dataworks.migrationx.transformer.core.utils.DiCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.core.utils.EmrCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.AbstractBaseConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.WorkflowConverter;
import com.aliyun.migrationx.common.utils.DateUtils;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.aliyuncs.emr.model.v20160408.DescribeClusterBasicInfoResponse;
import com.aliyuncs.emr.model.v20160408.DescribeFlowResponse;
import com.aliyuncs.emr.model.v20160408.ListFlowJobResponse;
import com.aliyuncs.emr.model.v20160408.ListFlowProjectResponse;
import com.aliyuncs.emr.model.v20160408.ListFlowResponse;
import com.google.common.base.Joiner;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunEmrWorkflowConverter
extends AbstractBaseConverter
implements WorkflowConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AliyunEmrWorkflowConverter.class);
    private static final String FLOW_NODE_DEF_TYPE_ACTION = ":action:";
    private List<ReportItem> reportItems = new ArrayList<ReportItem>();
    private ArrayList<DwWorkflow> workflowList;
    private Properties properties;
    private Map<EmrJobType, CodeProgramType> nodeTypeMap = new HashMap<EmrJobType, CodeProgramType>();
    private Project project;
    private List<AliyunEmrProject> emrProjects = new ArrayList<AliyunEmrProject>();
    private Function<ListFlowResponse.FlowItem, DescribeClusterBasicInfoResponse.ClusterInfo> getClusterInfoHook = flowItem -> null;

    public AliyunEmrWorkflowConverter setGetClusterInfoHook(Function<ListFlowResponse.FlowItem, DescribeClusterBasicInfoResponse.ClusterInfo> getClusterInfoHook) {
        this.getClusterInfoHook = getClusterInfoHook;
        return this;
    }

    public AliyunEmrWorkflowConverter() {
        super(AssetType.EMR, "AliyunEmrWorkflowConverter");
    }

    public AliyunEmrWorkflowConverter(AssetType assetType, String name, ProjectAssetLoader projectAssetLoader) {
        super(assetType, name, projectAssetLoader);
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public static String getWorkflowName(ListFlowProjectResponse.Project project, ListFlowResponse.FlowItem flowItem) {
        return Joiner.on((String)"__").join((Object)project.getName(), (Object)flowItem.getName(), new Object[0]);
    }

    @Override
    public List<DwWorkflow> convert(Asset asset) throws Exception {
        LOGGER.info("convert asset: {}, path: {}", (Object)asset.getType().name(), (Object)asset.getPath().getAbsolutePath());
        if (this.properties != null && this.properties.containsKey("workflow.converter.aliyunEmr.nodeTypeMapping")) {
            String mapJson = this.properties.getProperty("workflow.converter.aliyunEmr.nodeTypeMapping", "{}");
            this.nodeTypeMap = (Map)GsonUtils.fromJsonString((String)mapJson, (Type)new TypeToken<Map<EmrJobType, CodeProgramType>>(){}.getType());
        }
        this.emrProjects = AliyunEmrWorkflowConverter.load(asset.getPath().getAbsolutePath());
        this.workflowList = new ArrayList();
        for (AliyunEmrProject project : this.emrProjects) {
            List<DwWorkflow> workflowArray = this.convertProject(project);
            this.workflowList.addAll(workflowArray);
        }
        return this.workflowList;
    }

    private List<DwWorkflow> convertProject(AliyunEmrProject project) throws Exception {
        this.convertProjectJobList(project);
        List<DwWorkflow> scheduled = this.convertProjectFlowList(project);
        return scheduled;
    }

    private List<DwWorkflow> convertProjectFlowList(AliyunEmrProject project) throws Exception {
        ArrayList<DwWorkflow> workflowList = new ArrayList<DwWorkflow>();
        for (ListFlowResponse.FlowItem flowItem : project.getFlows().keySet()) {
            DwWorkflow workflow = new DwWorkflow();
            workflow.setName(AliyunEmrWorkflowConverter.getWorkflowName(project.getProject(), flowItem));
            workflow.setScheduled(Boolean.valueOf(true));
            workflow.setVersion(WorkflowVersion.V3);
            DescribeFlowResponse flowDetail = (DescribeFlowResponse)project.getFlows().get(flowItem);
            Map app = (Map)GsonUtils.gson.fromJson(flowDetail.getApplication(), new TypeToken<Map<String, Map<String, FlowNodeDef>>>(){}.getType());
            if (app != null) {
                List<Node> nodes = this.parseFlowNodes(project, flowItem, (Map)app.get("nodeDefMap"), (Workflow)workflow);
                workflow.setNodes(nodes);
            }
            this.processFlowDependency(workflow, flowDetail);
            ListUtils.emptyIfNull((List)workflow.getNodes()).forEach(node -> {
                if (CollectionUtils.isEmpty((Collection)node.getInputs())) {
                    NodeIo root = new NodeIo();
                    root.setData(NodeUtils.getProjectRootOutput((Project)this.project));
                    root.setParseType(Integer.valueOf(1));
                    node.getInputs().add(root);
                }
            });
            workflowList.add(workflow);
        }
        return workflowList;
    }

    private void processFlowDependency(DwWorkflow workflow, DescribeFlowResponse flowDetail) {
        if (CollectionUtils.isEmpty((Collection)flowDetail.getParentFlowList())) {
            return;
        }
        List parentFlows = flowDetail.getParentFlowList();
        workflow.getNodes().stream().filter(this::isStart).findFirst().ifPresent(start -> ListUtils.emptyIfNull((List)parentFlows).forEach(parentFlow -> {
            String inStr = this.getNodeDefaultOutput(parentFlow.getProjectName(), parentFlow.getParentFlowName(), "end");
            ArrayList<NodeIo> inputs = start.getInputs();
            if (CollectionUtils.isEmpty((Collection)start.getInputs())) {
                inputs = new ArrayList<NodeIo>();
                start.setInputs(inputs);
            }
            NodeIo input = new NodeIo();
            input.setData(inStr);
            input.setParseType(Integer.valueOf(1));
            inputs.add(input);
        }));
    }

    private boolean isStart(Node n) {
        return "start".equalsIgnoreCase(((DwNode)n).getRawNodeType()) && CodeProgramType.VIRTUAL.name().equalsIgnoreCase(n.getType());
    }

    private String getNodeName(Map<String, List<FlowNodeDef>> groupByJobId, ListFlowJobResponse.Job job, FlowNodeDef nodeDef) {
        if (!groupByJobId.containsKey(job.getId())) {
            return NodeUtils.normalizedFileName((String)job.getName());
        }
        if (CollectionUtils.size(groupByJobId.get(job.getId())) > 1) {
            return NodeUtils.normalizedFileName((String)Joiner.on((String)"_").join((Object)job.getName(), (Object)nodeDef.getName(), new Object[0]));
        }
        return NodeUtils.normalizedFileName((String)job.getName());
    }

    private String getStartEndNodeName(ListFlowResponse.FlowItem flowItem, FlowNodeDef flowNodeDef) {
        return Joiner.on((String)"_").join((Object)this.getStartEndRawNodeName(flowNodeDef), (Object)flowItem.getName(), new Object[0]);
    }

    private String getStartEndRawNodeName(FlowNodeDef flowNodeDef) {
        return flowNodeDef.getType().replaceAll(":", "");
    }

    private List<Node> parseFlowNodes(AliyunEmrProject project, ListFlowResponse.FlowItem flowItem, Map<String, FlowNodeDef> app, Workflow workflow) {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        Map<String, List<FlowNodeDef>> groupByJobId = app.values().stream().filter(nd -> Objects.nonNull(nd.getJobId())).collect(Collectors.groupingBy(FlowNodeDef::getJobId));
        for (FlowNodeDef nodeDef : app.values()) {
            DwNode node = new DwNode();
            try {
                node.setStartRightNow(this.supplyStartRightNow());
                node.setCronExpress(CronExpressUtil.normalize((String)((String)StringUtils.defaultIfBlank((CharSequence)flowItem.getCronExpr(), (CharSequence)"day"))));
                DescribeFlowResponse flowDetail = (DescribeFlowResponse)project.getFlows().get(flowItem);
                if (FLOW_NODE_DEF_TYPE_ACTION.equals(nodeDef.getType())) {
                    ListFlowJobResponse.Job job = project.getJobById(nodeDef.getJobId());
                    node.setName(this.getNodeName(groupByJobId, job, nodeDef));
                    node.setType(this.getNodeType(workflow, (Node)node, job));
                    node.setCode(this.convertCode(job));
                    node.setRawNodeType(RawNodeType.valueOf(job.getType()).name());
                    node.setTaskRerunTime(job.getMaxRetry());
                    node.setTaskRerunInterval(Integer.valueOf((int)(job.getRetryInterval() * 1000L)));
                    node.setParameter(this.getNodeParameter(node, job));
                    NodeIo output = new NodeIo();
                    output.setData(this.getNodeDefaultOutput(project, flowItem, node.getName()));
                    output.setParseType(Integer.valueOf(1));
                    node.getOutputs().add(output);
                    node.setDescription(job.getDescription());
                    node.setCode(this.handleJobCode(flowItem, node, job));
                    node.setResourceGroup(this.properties.getProperty("workflow.converter.target.schedule.resGroupIdentifier", null));
                } else {
                    node.setName(this.getStartEndNodeName(flowItem, nodeDef));
                    node.setType(CodeProgramType.VIRTUAL.name());
                    node.setRawNodeType(this.getStartEndRawNodeName(nodeDef));
                    NodeIo output = new NodeIo();
                    output.setData(this.getNodeDefaultOutput(project, flowItem, this.getStartEndRawNodeName(nodeDef)));
                    output.setParseType(Integer.valueOf(1));
                    node.getOutputs().add(output);
                }
                node.setPauseSchedule(Boolean.valueOf(StringUtils.equalsIgnoreCase((CharSequence)"STOP_SCHEDULE", (CharSequence)flowItem.getStatus())));
                if (flowDetail.getStartSchedule() != null) {
                    node.setStartEffectDate(DateUtils.convertLongToDate((long)flowDetail.getStartSchedule()));
                }
                if (flowDetail.getEndSchedule() != null) {
                    node.setEndEffectDate(DateUtils.convertLongToDate((long)flowDetail.getEndSchedule()));
                }
                node.setNodeUseType(NodeUseType.SCHEDULED);
                node.setOwner(this.project.getOpUser());
                node.setIsAutoParse(Integer.valueOf(0));
                nodeList.add((Node)node);
            }
            catch (Exception e) {
                ReportItem reportItem = new ReportItem();
                reportItem.setMessage(e.getMessage());
                reportItem.setException(ExceptionUtils.getStackTrace((Throwable)e));
                reportItem.setRiskLevel(ReportRiskLevel.ERROR);
                reportItem.setNode((Node)node);
                reportItem.setWorkflow(workflow);
                reportItem.setType(ReportItemType.EMR_JOB_TO_DATAWORKS_NODE.name());
                reportItem.setName(workflow.getName() + "/" + node.getName());
                this.reportItems.add(reportItem);
                LOGGER.error("convert node error: ", (Throwable)e);
            }
        }
        for (FlowNodeDef nodeDef : app.values()) {
            String name;
            ListFlowJobResponse.Job job = project.getJobById(nodeDef.getJobId());
            String string = name = job != null ? this.getNodeName(groupByJobId, job, nodeDef) : this.getStartEndNodeName(flowItem, nodeDef);
            Node node = nodeList.stream().filter(n -> n.getName().equals(name)).findFirst().orElse(null);
            if (node == null || nodeDef.getTransitions() == null) continue;
            for (String nodeKey : nodeDef.getTransitions()) {
                FlowNodeDef downstreamNodeDef = app.get(nodeKey);
                ListFlowJobResponse.Job downstreamJob = project.getJobById(downstreamNodeDef.getJobId());
                String downstreamNodeName = downstreamJob != null ? this.getNodeName(groupByJobId, downstreamJob, downstreamNodeDef) : this.getStartEndNodeName(flowItem, downstreamNodeDef);
                Node downstreamNode = nodeList.stream().filter(n -> n.getName().equals(downstreamNodeName)).findFirst().orElse(null);
                if (downstreamNode == null) continue;
                downstreamNode.getInputs().add((NodeIo)node.getOutputs().get(0));
            }
        }
        return nodeList;
    }

    private Boolean supplyStartRightNow() {
        return BooleanUtils.toBoolean((String)this.properties.getProperty("workflow.converter.aliyunEmr.startRightNow", Boolean.FALSE.toString()));
    }

    private String handleJobCode(ListFlowResponse.FlowItem flowItem, DwNode node, ListFlowJobResponse.Job job) {
        JsonObject runConfJson;
        String runConfJsonStr;
        DescribeClusterBasicInfoResponse.ClusterInfo clusterInfo = Optional.ofNullable(flowItem).map(this.getClusterInfoHook).orElse(null);
        String useGatewayMode = this.properties.getProperty("workflow.converter.aliyunEmr.jobSubmitMode");
        Boolean gatewayAvailable = Optional.ofNullable(clusterInfo).map(c -> CollectionUtils.isNotEmpty((Collection)c.getGatewayClusterInfoList())).orElse(false);
        if (!gatewayAvailable.booleanValue()) {
            useGatewayMode = EmrJobMode.YARN.name();
        }
        node.setCode(EmrCodeUtils.toEmrCode((Node)node));
        EmrCode emrCode = EmrCodeUtils.asEmrCode((Node)node);
        if (emrCode == null || emrCode.getLauncher() == null || emrCode.getLauncher().getAllocationSpec() == null) {
            return node.getCode();
        }
        EmrAllocationSpec allocSpec = EmrAllocationSpec.of((Map)emrCode.getLauncher().getAllocationSpec());
        EmrJobMode jobMode = EmrJobMode.getByValue((String)((String)StringUtils.defaultIfBlank((CharSequence)((String)StringUtils.defaultIfBlank((CharSequence)useGatewayMode, (CharSequence)job.getMode())), (CharSequence)EmrJobMode.YARN.getValue())));
        switch (jobMode) {
            case LOCAL: {
                allocSpec.setUseGateway(Boolean.valueOf(true));
                break;
            }
            default: {
                allocSpec.setUseGateway(Boolean.valueOf(false));
            }
        }
        String reuseSessionStr = this.properties.getProperty("workflow.converter.aliyunEmr.reuseSession");
        if (StringUtils.isNotBlank((CharSequence)reuseSessionStr)) {
            allocSpec.setReuseSession(Boolean.valueOf(BooleanUtils.toBoolean((String)reuseSessionStr)));
        }
        if (StringUtils.isNotBlank((CharSequence)(runConfJsonStr = job.getRunConf())) && (runConfJson = (JsonObject)GsonUtils.fromJsonString((String)runConfJsonStr, (Type)new TypeToken<JsonObject>(){}.getType())) != null && runConfJson.size() > 0) {
            if (runConfJson.has("cores")) {
                allocSpec.setVcores(runConfJson.get("cores").getAsString());
            }
            if (runConfJson.has("memory")) {
                allocSpec.setMemory(runConfJson.get("memory").getAsString());
            }
            if (runConfJson.has("priority")) {
                allocSpec.setPriority(runConfJson.get("priority").getAsString());
            }
            if (runConfJson.has("userName")) {
                allocSpec.setUserName(runConfJson.get("userName").getAsString());
            }
            if (runConfJson.has("queue")) {
                allocSpec.setQueue(runConfJson.get("queue").getAsString());
            }
        }
        emrCode.getLauncher().setAllocationSpec(allocSpec.toMap());
        return EmrCodeUtils.toString(emrCode);
    }

    private String convertCode(ListFlowJobResponse.Job job) {
        String originalCode;
        EmrJobType jobType = EmrJobType.getJobType((String)job.getType());
        String finalCode = originalCode = job.getParams();
        switch (jobType) {
            case SQOOP: {
                finalCode = this.convertSqoopCode(originalCode);
                break;
            }
            case HIVE: {
                finalCode = Joiner.on((String)" ").join((Object)"hive", (Object)originalCode, new Object[0]);
                break;
            }
        }
        return finalCode;
    }

    private String convertSqoopCode(String originalCode) {
        String datasourceName = this.getDefaultCalcEngineDatasource(this.properties, this.project.getName());
        CalcEngineType engineType = this.getDefaultCalcEngineType(this.properties, CalcEngineType.ODPS);
        DICode diCode = DICode.parseDiCode(originalCode, engineType, datasourceName, DefaultNodeTypeUtils.getDatasourceTypeByEngineType((CalcEngineType)engineType));
        List<DwDatasource> dsList = DiCodeUtils.processSqoopDatasource(diCode);
        ListUtils.emptyIfNull(dsList).stream().forEach(ds -> {
            ds.setProjectRef(this.project);
            ds.setEnvType(EnvType.PRD.name());
            if (this.project.getDatasources().stream().noneMatch(d -> d.getName().equals(ds.getName()))) {
                this.project.getDatasources().add(ds);
            }
        });
        return diCode.getCode();
    }

    private String getNodeParameter(DwNode node, ListFlowJobResponse.Job job) {
        if (job != null && StringUtils.isNotBlank((CharSequence)job.getParamConf())) {
            CodeProgramType nodeType = CodeProgramType.valueOf((String)node.getType());
            Map paramMap = (Map)GsonUtils.fromJsonString((String)job.getParamConf(), (Type)new TypeToken<Map<String, String>>(){}.getType());
            if (MapUtils.isEmpty((Map)paramMap)) {
                return null;
            }
            switch (nodeType) {
                case DIDE_SHELL: {
                    return Joiner.on((String)" ").join(paramMap.values());
                }
            }
            return Joiner.on((String)" ").join((Iterable)paramMap.entrySet().stream().map(e -> Joiner.on((String)"=").join(e.getKey(), e.getValue(), new Object[0])).collect(Collectors.toList()));
        }
        return null;
    }

    private String getNodeDefaultOutput(AliyunEmrProject project, ListFlowResponse.FlowItem flowItem, String jobName) {
        return Joiner.on((String)".").join((Object)this.project.getName(), (Object)project.getProject().getName(), new Object[]{flowItem.getName(), jobName});
    }

    private String getNodeDefaultOutput(String emrProjectName, String emrFlowName, String emrJobName) {
        return Joiner.on((String)".").join((Object)this.project.getName(), (Object)emrProjectName, new Object[]{emrFlowName, emrJobName});
    }

    private void convertProjectJobList(AliyunEmrProject project) {
        this.project.setAdHocQueries(ListUtils.emptyIfNull((List)project.getJobs()).stream().filter(job -> BooleanUtils.toBoolean((String)job.getAdhoc())).map(job -> {
            DwNode node = new DwNode();
            node.setName(job.getName());
            node.setCode(job.getParams());
            node.setRawNodeType(RawNodeType.valueOf(job.getType()).name());
            node.setType(this.getNodeType(null, (Node)node, (ListFlowJobResponse.Job)job));
            node.setOwner(this.project.getOpUser());
            node.setNodeUseType(NodeUseType.AD_HOC);
            node.setFolder(ModelTreeRoot.QUERY_ROOT.getRootKey());
            node.setCode(EmrCodeUtils.toEmrCode((Node)node));
            return node;
        }).collect(Collectors.toList()));
    }

    private String getNodeType(Workflow workflow, Node node, ListFlowJobResponse.Job job) {
        EmrJobType jobType = EmrJobType.getJobType((String)job.getType());
        if (this.nodeTypeMap.containsKey(jobType)) {
            return this.nodeTypeMap.get(jobType).getName();
        }
        if (EmrJobType.HIVE_SQL.equals((Object)jobType)) {
            return CodeProgramType.ODPS_SQL.name();
        }
        if (EmrJobType.SPARK_SQL.equals((Object)jobType)) {
            return CodeProgramType.ODPS_SQL.name();
        }
        if (EmrJobType.SPARK_SQL.equals((Object)jobType)) {
            return CodeProgramType.ODPS_SQL.name();
        }
        if (EmrJobType.SHELL.equals((Object)jobType)) {
            return CodeProgramType.DIDE_SHELL.name();
        }
        if (workflow != null) {
            ReportItem reportItem = new ReportItem();
            reportItem.setWorkflow(workflow);
            reportItem.setNode(node);
            reportItem.setRiskLevel(ReportRiskLevel.ERROR);
            reportItem.setMessage("unsupported job type:" + job.getType());
            reportItem.setName(workflow.getName() + "/" + node.getName());
            reportItem.setType(ReportItemType.UNSUPPORTED_JOB_TYPE.name());
            this.reportItems.add(reportItem);
        }
        return this.getDefaultTypeIfNotSupported(this.properties, CodeProgramType.DIDE_SHELL);
    }

    public static List<AliyunEmrProject> load(String fromFolder) throws IOException {
        File folderPath = new File(fromFolder);
        ArrayList<AliyunEmrProject> projects = new ArrayList<AliyunEmrProject>();
        File[] subDirs = folderPath.listFiles(File::isDirectory);
        if (subDirs == null) {
            return ListUtils.emptyIfNull(null);
        }
        for (File projectPath : subDirs) {
            File projectJsonFile = new File(projectPath.getAbsolutePath() + File.separator + projectPath.getName() + ".json");
            if (!projectJsonFile.exists()) {
                LOGGER.error("project json file not exists: {}", (Object)projectJsonFile);
                continue;
            }
            String prjJson = FileUtils.readFileToString((File)projectJsonFile, (Charset)Charset.forName("utf-8"));
            ListFlowProjectResponse.Project project = (ListFlowProjectResponse.Project)GsonUtils.gson.fromJson(prjJson, new TypeToken<ListFlowProjectResponse.Project>(){}.getType());
            List<ListFlowJobResponse.Job> jobs = AliyunEmrWorkflowConverter.loadProjectJobs(projectPath);
            Map<ListFlowResponse.FlowItem, Flow> flows = AliyunEmrWorkflowConverter.loadProjectFlows(projectPath);
            AliyunEmrProject aliyunEmrProject = new AliyunEmrProject();
            aliyunEmrProject.setProject(project);
            aliyunEmrProject.setFlows(flows);
            aliyunEmrProject.setJobs(jobs);
            projects.add(aliyunEmrProject);
        }
        return projects;
    }

    private static Map<ListFlowResponse.FlowItem, Flow> loadProjectFlows(File projectPath) throws IOException {
        File flowFolder = new File(projectPath.getAbsolutePath() + File.separator + "flow");
        HashMap<ListFlowResponse.FlowItem, Flow> flows = new HashMap<ListFlowResponse.FlowItem, Flow>(100);
        File[] files = flowFolder.listFiles(f -> f.isFile() && f.getName().endsWith(".json"));
        if (files == null) {
            return flows;
        }
        for (File flowJsonFile : files) {
            if (flowJsonFile.getName().contains(".detail")) continue;
            String flowJson = FileUtils.readFileToString((File)flowJsonFile, (Charset)Charset.forName("utf-8"));
            ListFlowResponse.FlowItem flowItem = (ListFlowResponse.FlowItem)GsonUtils.gson.fromJson(flowJson, new TypeToken<ListFlowResponse.FlowItem>(){}.getType());
            File jobDetailFile = new File(flowJsonFile.getAbsolutePath().replaceAll(".json$", "") + ".detail" + ".json");
            Flow flowDetail = null;
            if (jobDetailFile.exists()) {
                String jobDetailJson = FileUtils.readFileToString((File)jobDetailFile, (Charset)Charset.forName("utf-8"));
                flowDetail = (Flow)GsonUtils.gson.fromJson(jobDetailJson, new TypeToken<Flow>(){}.getType());
            }
            flows.put(flowItem, flowDetail);
        }
        return flows;
    }

    private static List<ListFlowJobResponse.Job> loadProjectJobs(File projectPath) throws IOException {
        File jobFolder = new File(projectPath.getAbsolutePath() + File.separator + "job");
        ArrayList<ListFlowJobResponse.Job> jobs = new ArrayList<ListFlowJobResponse.Job>(100);
        File[] files = jobFolder.listFiles(f -> f.isFile() && f.getName().endsWith(".json"));
        if (files == null) {
            return jobs;
        }
        for (File jobJsonFile : files) {
            String jobJson = FileUtils.readFileToString((File)jobJsonFile, (Charset)Charset.forName("utf-8"));
            ListFlowJobResponse.Job jobItem = (ListFlowJobResponse.Job)GsonUtils.gson.fromJson(jobJson, new TypeToken<ListFlowJobResponse.Job>(){}.getType());
            jobs.add(jobItem);
        }
        return jobs;
    }

    class FlowNodeDef {
        private String jobId;
        private String name;
        private String clusterId;
        private String hostName;
        private String type;
        private Integer dependencies;
        private List<String> transitions;

        FlowNodeDef() {
        }

        public String getJobId() {
            return this.jobId;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getHostName() {
            return this.hostName;
        }

        public void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Integer getDependencies() {
            return this.dependencies;
        }

        public void setDependencies(Integer dependencies) {
            this.dependencies = dependencies;
        }

        public List<String> getTransitions() {
            return this.transitions;
        }

        public void setTransitions(List<String> transitions) {
            this.transitions = transitions;
        }
    }
}

