/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.workflow.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DolphinSchedulerV3Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.sqoop.SqoopParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.sqoop.sources.SourceHdfsParameter;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.sqoop.sources.SourceHiveParameter;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.sqoop.sources.SourceMysqlParameter;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.sqoop.targets.TargetHdfsParameter;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.sqoop.targets.TargetHiveParameter;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.sqoop.targets.TargetMysqlParameter;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.CodeModeType;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DIConfigTemplate;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DIJsonProcessor;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.workflow.parameters.AbstractParameterConverter;
import com.aliyun.migrationx.common.utils.JSONUtils;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;

public class SqoopParameterConverter
extends AbstractParameterConverter<SqoopParameters> {
    public SqoopParameterConverter(Properties properties, SpecWorkflow specWorkflow, DagData processMeta, TaskDefinition taskDefinition) {
        super(properties, specWorkflow, processMeta, taskDefinition);
    }

    @Override
    protected void convertParameter(SpecNode specNode) {
        List<SpecVariable> specVariableList = this.convertSpecNodeParam(specNode);
        CodeProgramType codeProgramType = CodeProgramType.DI;
        SpecScript script = new SpecScript();
        String language = this.codeToLanguageIdentifier(codeProgramType);
        script.setLanguage(language);
        SpecScriptRuntime runtime = new SpecScriptRuntime();
        runtime.setEngine(codeProgramType.getCalcEngineType().getLabel());
        runtime.setCommand(codeProgramType.getName());
        script.setRuntime(runtime);
        script.setPath(this.getScriptPath(specNode));
        String content = this.convertCode();
        script.setContent(content);
        script.setParameters(ListUtils.emptyIfNull(specVariableList).stream().filter(v -> !VariableType.NODE_OUTPUT.equals((Object)v.getType())).collect(Collectors.toList()));
        specNode.setScript(script);
        this.postHandle("SQOOP", script);
    }

    public String convertCode() {
        CodeProgramType codeProgramType = CodeProgramType.DI;
        DIJsonProcessor diProcessor = DIJsonProcessor.from(DIConfigTemplate.DI_CODE_TEMPLATE);
        DIJsonProcessor readerJp = diProcessor.getConfiguration("steps[0]");
        DIJsonProcessor writerJp = diProcessor.getConfiguration("steps[1]");
        this.processSqoopSource(readerJp);
        this.processSqoopTarget(writerJp);
        diProcessor.set("extend.mode", CodeModeType.CODE.getValue());
        return diProcessor.toJSON();
    }

    private void processSqoopTarget(DIJsonProcessor writerJp) {
        List dataSources = DolphinSchedulerV3Context.getContext().getDataSources();
        writerJp.set("stepType", StringUtils.lowerCase((String)((SqoopParameters)this.parameter).getTargetType()));
        if (StringUtils.equalsIgnoreCase((CharSequence)((SqoopParameters)this.parameter).getTargetType(), (CharSequence)"mysql")) {
            TargetMysqlParameter targetMysqlParameter = (TargetMysqlParameter)JSONUtils.parseObject((String)((SqoopParameters)this.parameter).getTargetParams(), TargetMysqlParameter.class);
            Optional.ofNullable(targetMysqlParameter).ifPresent(p -> {
                String[] stringArray;
                ListUtils.emptyIfNull((List)dataSources).stream().filter(ds -> Objects.equals(ds.getId(), targetMysqlParameter.getTargetDatasource())).findFirst().ifPresent(ds -> writerJp.set("parameter.datasource", ds.getName()));
                writerJp.set("parameter.table", targetMysqlParameter.getTargetTable());
                writerJp.set("parameter.preSql", Optional.ofNullable(StringUtils.split((String)targetMysqlParameter.getPreQuery(), (String)",")).orElse(new String[0]));
                if (StringUtils.isBlank((CharSequence)targetMysqlParameter.getTargetColumns())) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "*";
                } else {
                    stringArray = StringUtils.split((String)targetMysqlParameter.getTargetColumns(), (String)",");
                }
                writerJp.set("parameter.column", stringArray);
                if (StringUtils.equalsIgnoreCase((CharSequence)targetMysqlParameter.getTargetUpdateMode(), (CharSequence)"updateonly")) {
                    writerJp.set("parameter.writeMode", "update");
                } else {
                    writerJp.set("parameter.writeMode", "replace");
                }
            });
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)((SqoopParameters)this.parameter).getTargetType(), (CharSequence)"hive")) {
            TargetHiveParameter targetHiveParameter = (TargetHiveParameter)JSONUtils.parseObject((String)((SqoopParameters)this.parameter).getTargetParams(), TargetHiveParameter.class);
            Optional.ofNullable(targetHiveParameter).ifPresent(p -> {
                ListUtils.emptyIfNull((List)dataSources).stream().filter(ds -> StringUtils.equals((CharSequence)String.valueOf(ds.getId()), (CharSequence)targetHiveParameter.getHiveDatabase())).findFirst().ifPresent(ds -> writerJp.set("parameter.datasource", ds.getName()));
                writerJp.set("parameter.table", targetHiveParameter.getHiveTable());
                String[] keys = Optional.ofNullable(StringUtils.split((String)targetHiveParameter.getHivePartitionKey(), (String)",")).orElse(new String[0]);
                String[] values = Optional.ofNullable(StringUtils.split((String)targetHiveParameter.getHivePartitionValue(), (String)",")).orElse(new String[0]);
                ArrayList<String> partitions = new ArrayList<String>();
                for (int i = 0; i < Math.min(keys.length, values.length); ++i) {
                    partitions.add(Joiner.on((String)"=").join((Object)keys[i], (Object)values[i], new Object[0]));
                }
                writerJp.set("parameter.partition", Joiner.on((String)",").join(partitions));
                writerJp.set("parameter.hdfsUsername", "hdfs");
                writerJp.set("parameter.writeMode", "append");
            });
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)((SqoopParameters)this.parameter).getTargetType(), (CharSequence)"hdfs")) {
            TargetHdfsParameter targetHdfsParameter = (TargetHdfsParameter)JSONUtils.parseObject((String)((SqoopParameters)this.parameter).getSourceParams(), TargetHdfsParameter.class);
            Optional.ofNullable(targetHdfsParameter).ifPresent(p -> {
                writerJp.set("parameter.path", p.getTargetPath());
                writerJp.set("parameter.compress", targetHdfsParameter.getCompressionCodec());
                writerJp.set("parameter.datasource", "hdfs");
                writerJp.set("parameter.fileType", targetHdfsParameter.getFileType());
                if (StringUtils.equalsIgnoreCase((CharSequence)"parquet", (CharSequence)targetHdfsParameter.getFileType())) {
                    writerJp.set("parameter.writeMode", "noConflict");
                } else {
                    writerJp.set("parameter.writeMode", "append");
                }
            });
        }
    }

    private void processSqoopSource(DIJsonProcessor readerJp) {
        List dataSources = DolphinSchedulerV3Context.getContext().getDataSources();
        readerJp.set("stepType", StringUtils.lowerCase((String)((SqoopParameters)this.parameter).getSourceType()));
        if (StringUtils.equalsIgnoreCase((CharSequence)((SqoopParameters)this.parameter).getSourceType(), (CharSequence)"mysql")) {
            SourceMysqlParameter mysqlParameter = (SourceMysqlParameter)JSONUtils.parseObject((String)((SqoopParameters)this.parameter).getSourceParams(), SourceMysqlParameter.class);
            Optional.ofNullable(mysqlParameter).ifPresent(p -> {
                String[] stringArray;
                ListUtils.emptyIfNull((List)dataSources).stream().filter(ds -> Objects.equals(ds.getId(), mysqlParameter.getSrcDatasource())).findFirst().ifPresent(ds -> readerJp.set("parameter.datasource", ds.getName()));
                readerJp.set("parameter.table", mysqlParameter.getSrcTable());
                readerJp.set("parameter.where", StringUtils.substringAfter((String)StringUtils.lowerCase((String)mysqlParameter.getSrcQuerySql()), (String)"where"));
                if (StringUtils.isBlank((CharSequence)mysqlParameter.getSrcColumns())) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "*";
                } else {
                    stringArray = StringUtils.split((String)mysqlParameter.getSrcColumns(), (String)",");
                }
                readerJp.set("parameter.column", stringArray);
            });
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)((SqoopParameters)this.parameter).getSourceType(), (CharSequence)"hive")) {
            SourceHiveParameter sourceHiveParameter = (SourceHiveParameter)JSONUtils.parseObject((String)((SqoopParameters)this.parameter).getSourceParams(), SourceHiveParameter.class);
            Optional.ofNullable(sourceHiveParameter).ifPresent(p -> {
                ListUtils.emptyIfNull((List)dataSources).stream().filter(ds -> StringUtils.equals((CharSequence)String.valueOf(ds.getId()), (CharSequence)sourceHiveParameter.getHiveDatabase())).findFirst().ifPresent(ds -> readerJp.set("parameter.datasource", ds.getName()));
                readerJp.set("parameter.table", sourceHiveParameter.getHiveTable());
                String[] keys = Optional.ofNullable(StringUtils.split((String)sourceHiveParameter.getHivePartitionKey(), (String)",")).orElse(new String[0]);
                String[] values = Optional.ofNullable(StringUtils.split((String)sourceHiveParameter.getHivePartitionValue(), (String)",")).orElse(new String[0]);
                ArrayList<String> partitions = new ArrayList<String>();
                for (int i = 0; i < Math.min(keys.length, values.length); ++i) {
                    partitions.add(Joiner.on((String)"=").join((Object)keys[i], (Object)values[i], new Object[0]));
                }
                readerJp.set("parameter.partition", Joiner.on((String)",").join(partitions));
                readerJp.set("parameter.readMode", "hdfs");
                readerJp.set("parameter.hdfsUsername", "hdfs");
                List columns = Arrays.stream(keys).map(key -> {
                    HashMap<String, String> column = new HashMap<String, String>();
                    column.put("type", "string");
                    column.put("value", (String)key);
                    return column;
                }).collect(Collectors.toList());
                readerJp.set("parameter.hivePartitionColumn", columns);
            });
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)((SqoopParameters)this.parameter).getSourceType(), (CharSequence)"hdfs")) {
            SourceHdfsParameter sourceHdfsParameter = (SourceHdfsParameter)JSONUtils.parseObject((String)((SqoopParameters)this.parameter).getSourceParams(), SourceHdfsParameter.class);
            Optional.ofNullable(sourceHdfsParameter).ifPresent(p -> readerJp.set("parameter.path", p.getExportDir()));
        }
    }
}

