/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.workflow.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecDatasource;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.enums.DbType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.sql.SqlParameters;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.workflow.parameters.AbstractParameterConverter;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlParameterConverter
extends AbstractParameterConverter<SqlParameters> {
    private static final Logger log = LoggerFactory.getLogger(SqlParameterConverter.class);

    public SqlParameterConverter(Properties properties, SpecWorkflow specWorkflow, DagData processMeta, TaskDefinition taskDefinition) {
        super(properties, specWorkflow, processMeta, taskDefinition);
    }

    @Override
    protected void convertParameter(SpecNode specNode) {
        List<SpecVariable> specVariableList = this.convertSpecNodeParam(specNode);
        String sqlNodeMapStr = this.properties.getProperty("workflow.converter.dolphinscheduler.sqlNodeTypeMapping", "{}");
        Map sqlTypeNodeTypeMapping = (Map)GsonUtils.fromJsonString((String)sqlNodeMapStr, (Type)new TypeToken<Map<String, String>>(){}.getType());
        String type = Optional.ofNullable(sqlTypeNodeTypeMapping).map(s -> (String)s.get(((SqlParameters)this.parameter).getType())).orElseGet(() -> {
            if (DbType.HIVE.name().equalsIgnoreCase(((SqlParameters)this.parameter).getType())) {
                return CodeProgramType.EMR_HIVE.name();
            }
            if (DbType.SPARK.name().equalsIgnoreCase(((SqlParameters)this.parameter).getType())) {
                return CodeProgramType.EMR_SPARK.name();
            }
            if (DbType.CLICKHOUSE.name().equalsIgnoreCase(((SqlParameters)this.parameter).getType())) {
                return CodeProgramType.CLICK_SQL.name();
            }
            if (DbType.ofName((String)((SqlParameters)this.parameter).getType()) != null) {
                return ((SqlParameters)this.parameter).getType();
            }
            String defaultNodeTypeIfNotSupport = this.getSQLConverterType();
            log.warn("using default node Type {} for node {}", (Object)defaultNodeTypeIfNotSupport, (Object)specNode.getName());
            return defaultNodeTypeIfNotSupport;
        });
        CodeProgramType codeProgramType = CodeProgramType.getNodeTypeByName((String)type);
        SpecScript script = new SpecScript();
        String language = this.codeToLanguageIdentifier(codeProgramType);
        script.setLanguage(language);
        SpecScriptRuntime runtime = new SpecScriptRuntime();
        runtime.setEngine(codeProgramType.getCalcEngineType().getLabel());
        runtime.setCommand(codeProgramType.getName());
        script.setRuntime(runtime);
        script.setPath(this.getScriptPath(specNode));
        String content = ((SqlParameters)this.parameter).getSql();
        content = this.replaceCodeWithParams(content, specVariableList);
        script.setContent(content);
        script.setParameters(ListUtils.emptyIfNull(specVariableList).stream().filter(v -> !VariableType.NODE_OUTPUT.equals((Object)v.getType())).collect(Collectors.toList()));
        specNode.setScript(script);
        SpecDatasource specDatasource = this.getDataSource(codeProgramType);
        specNode.setDatasource(specDatasource);
        this.postHandle("SQL", script);
    }

    private SpecDatasource getDataSource(CodeProgramType codeProgramType) {
        DataSource dataSource = this.getDataSourceById(((SqlParameters)this.parameter).getDatasource());
        String connName = null;
        if (dataSource != null) {
            connName = dataSource.getName();
        }
        String type = null;
        switch (codeProgramType) {
            case MYSQL: {
                type = "mysql";
                break;
            }
            case POSTGRESQL: {
                type = "postgresql";
                break;
            }
            case EMR_HIVE: {
                type = "emr";
                break;
            }
            case CLICK_SQL: {
                type = "clickhouse";
                break;
            }
            case Oracle: {
                type = "oracle";
                break;
            }
            case ODPS_SQL: {
                type = "odps";
                break;
            }
            case StarRocks: {
                type = "starrocks";
                break;
            }
            default: {
                type = codeProgramType.getName();
            }
        }
        if (connName != null) {
            SpecDatasource datasource = new SpecDatasource();
            datasource.setName(connName);
            datasource.setType(type);
            return datasource;
        }
        return null;
    }

    private String getSQLConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.commandSqlAs");
        return this.getConverterType(convertType, CodeProgramType.SQL_COMPONENT.name());
    }
}

