/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow;

import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.enums.TaskType;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.parameters.AbstractParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.parameters.CustomParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.parameters.DataxParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.parameters.DependentParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.parameters.MrParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.parameters.ProcedureParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.parameters.PythonParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.parameters.ShellParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.parameters.SparkParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.parameters.SqlParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.parameters.SqoopParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.parameters.SubProcessParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.parameters.SwitchParameterConverter;
import com.aliyun.migrationx.common.exception.UnSupportedTypeException;
import com.aliyun.migrationx.common.utils.Config;
import java.util.Properties;

public class TaskConverterFactoryV2 {
    public static AbstractParameterConverter create(Properties properties, SpecWorkflow specWorkflow, DagData processMeta, TaskDefinition taskDefinition) throws Throwable {
        if (Config.get().getTempTaskTypes().contains(taskDefinition.getTaskType())) {
            return new CustomParameterConverter(properties, specWorkflow, processMeta, taskDefinition);
        }
        TaskType taskType = TaskType.of((String)taskDefinition.getTaskType());
        if (taskType == null) {
            throw new UnSupportedTypeException(taskDefinition.getTaskType());
        }
        switch (taskType) {
            case SHELL: {
                return new ShellParameterConverter(properties, specWorkflow, processMeta, taskDefinition);
            }
            case PYTHON: {
                return new PythonParameterConverter(properties, specWorkflow, processMeta, taskDefinition);
            }
            case SQL: {
                return new SqlParameterConverter(properties, specWorkflow, processMeta, taskDefinition);
            }
            case MR: {
                return new MrParameterConverter(properties, specWorkflow, processMeta, taskDefinition);
            }
            case SPARK: {
                return new SparkParameterConverter(properties, specWorkflow, processMeta, taskDefinition);
            }
            case SUB_PROCESS: {
                return new SubProcessParameterConverter(properties, specWorkflow, processMeta, taskDefinition);
            }
            case DEPENDENT: {
                return new DependentParameterConverter(properties, specWorkflow, processMeta, taskDefinition);
            }
            case SWITCH: {
                return new SwitchParameterConverter(properties, specWorkflow, processMeta, taskDefinition);
            }
            case SQOOP: {
                return new SqoopParameterConverter(properties, specWorkflow, processMeta, taskDefinition);
            }
            case DATAX: {
                return new DataxParameterConverter(properties, specWorkflow, processMeta, taskDefinition);
            }
            case PROCEDURE: {
                return new ProcedureParameterConverter(properties, specWorkflow, processMeta, taskDefinition);
            }
        }
        throw new UnSupportedTypeException(taskDefinition.getTaskType());
    }
}

