/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.nodes.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DolphinSchedulerV2Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.ProcessDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.process.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.subprocess.SubProcessParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNodeIo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.NodeIo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Workflow;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.nodes.parameters.AbstractParameterConverter;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;

public class SubProcessParameterConverter
extends AbstractParameterConverter<SubProcessParameters> {
    public SubProcessParameterConverter(DagData processMeta, TaskDefinition taskDefinition, DolphinSchedulerConverterContext<Project, DagData, DataSource, ResourceInfo, UdfFunc> converterContext) {
        super(processMeta, taskDefinition, converterContext);
    }

    @Override
    public List<DwNode> convertParameter() {
        DwNode end = this.newDwNode(this.taskDefinition);
        end.setType(CodeProgramType.VIRTUAL.name());
        if (end.getInputs() == null) {
            end.setInputs(new ArrayList());
        }
        end.getInputs().addAll(this.inputIoList());
        super.setOutputs(end);
        DwNode start = this.newDwNode(this.taskDefinition);
        start.setName(start.getName() + "_start");
        start.setType(CodeProgramType.VIRTUAL.name());
        if (start.getInputs() == null) {
            start.setInputs(new ArrayList());
        }
        super.setInputs(start, this.listPreTasks());
        String out = this.getDefaultNodeOutput(this.processMeta, this.taskDefinition.getName()) + ".virtual.start";
        this.setBeginNodeOutputs(start, out);
        return Arrays.asList(start, end);
    }

    private void setBeginNodeOutputs(DwNode dwNode, String out) {
        DwNodeIo output = new DwNodeIo();
        output.setData(out);
        output.setParseType(Integer.valueOf(1));
        output.setNodeRef((Node)dwNode);
        dwNode.setOutputs(new ArrayList<DwNodeIo>(Collections.singletonList(output)));
    }

    @Override
    public void setOutputs(DwNode dwNode) {
    }

    @Override
    public void setInputs(DwNode dwNode, Set<TaskDefinition> preTasks) {
    }

    public List<NodeIo> inputIoList() {
        DolphinSchedulerV2Context context = DolphinSchedulerV2Context.getContext();
        ArrayList<NodeIo> dwNodeIos = new ArrayList<NodeIo>();
        long relationProcessCode = ((SubProcessParameters)this.parameter).getProcessDefinitionCode();
        ProcessDefinition depProcessDefinition = (ProcessDefinition)context.getProcessCodeMap().get(relationProcessCode);
        List taskDefinitions = (List)context.getProcessCodeTaskRelationMap().get(relationProcessCode);
        Set<Long> preTasks = this.findPreTaskNodes(relationProcessCode);
        for (TaskDefinition task : CollectionUtils.emptyIfNull((Collection)taskDefinitions)) {
            if (!this.isLeafNode(preTasks, task.getCode())) continue;
            DwNodeIo dwNodeIo = this.taskToNodeIo(task, depProcessDefinition);
            dwNodeIos.add((NodeIo)dwNodeIo);
        }
        return dwNodeIos;
    }

    private boolean isLeafNode(Set<Long> preTasks, Long code) {
        return !preTasks.contains(code);
    }

    private DwNodeIo taskToNodeIo(TaskDefinition depTask, ProcessDefinition processDefinition) {
        DwNodeIo crossProjectDepend = new DwNodeIo();
        crossProjectDepend.setParseType(Integer.valueOf(1));
        crossProjectDepend.setData(Joiner.on((String)".").join((Object)this.converterContext.getProject().getName(), (Object)depTask.getProjectName(), new Object[]{processDefinition.getName(), depTask.getName()}));
        return crossProjectDepend;
    }

    private Set<Long> findPreTaskNodes(Long code) {
        return DolphinSchedulerV2Context.getContext().getDagDatas().stream().filter(dag -> dag.getProcessDefinition().getCode() == code.longValue()).map(dag -> dag.getProcessTaskRelationList()).flatMap(Collection::stream).map(s -> s.getPreTaskCode()).collect(Collectors.toSet());
    }

    private DwNodeIo addStartEndNodeToDependedWorkflow(Node subProcessNode, ProcessDefinition proDef, DwWorkflow wf) {
        DwNode startNode = new DwNode();
        startNode.setType(CodeProgramType.VIRTUAL.name());
        startNode.setWorkflowRef((Workflow)wf);
        DwNodeIo startNodeOutput = new DwNodeIo();
        startNodeOutput.setData(Joiner.on((String)".").join((Object)this.converterContext.getProject(), (Object)wf.getName(), new Object[]{"start"}));
        startNodeOutput.setParseType(Integer.valueOf(1));
        startNode.setOutputs(Collections.singletonList(startNodeOutput));
        startNode.setInputs(new ArrayList());
        ListUtils.emptyIfNull((List)subProcessNode.getOutputs()).stream().findFirst().ifPresent(depOut -> startNode.getInputs().add(depOut));
        DwNode endNode = new DwNode();
        endNode.setType(CodeProgramType.VIRTUAL.name());
        endNode.setWorkflowRef((Workflow)wf);
        DwNodeIo endNodeOutput = new DwNodeIo();
        endNodeOutput.setData(Joiner.on((String)".").join((Object)this.converterContext.getProject(), (Object)wf.getName(), new Object[]{"end"}));
        endNodeOutput.setParseType(Integer.valueOf(1));
        endNode.setOutputs(Collections.singletonList(endNodeOutput));
        endNode.setInputs(new ArrayList());
        ListUtils.emptyIfNull((List)wf.getNodes()).forEach(node -> {
            String prefix = Joiner.on((String)".").join((Object)this.converterContext.getProject().getName(), (Object)proDef.getProjectName(), new Object[0]);
            if (ListUtils.emptyIfNull((List)node.getInputs()).stream().noneMatch(in -> StringUtils.startsWithIgnoreCase((CharSequence)in.getData(), (CharSequence)prefix))) {
                node.getInputs().add(startNodeOutput);
            }
            if (ListUtils.emptyIfNull((List)wf.getNodes()).stream().map(Node::getInputs).flatMap(Collection::stream).noneMatch(in -> ListUtils.emptyIfNull((List)node.getOutputs()).stream().anyMatch(out -> StringUtils.equalsIgnoreCase((CharSequence)in.getData(), (CharSequence)out.getData())))) {
                ListUtils.emptyIfNull((List)node.getOutputs()).stream().findFirst().ifPresent(out -> endNode.getInputs().add(out));
            }
        });
        wf.getNodes().add(startNode);
        wf.getNodes().add(endNode);
        return endNodeOutput;
    }
}

