/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.nodes.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.ControllerJoinCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DolphinSchedulerV2Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.model.DependentTaskModel;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.process.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.conditions.ConditionsParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.dependent.DependentParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.NodeIo;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.nodes.parameters.AbstractParameterConverter;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionsParameterConverter
extends AbstractParameterConverter<ConditionsParameters> {
    private static final Logger log = LoggerFactory.getLogger(ConditionsParameterConverter.class);

    public ConditionsParameterConverter(DagData processMeta, TaskDefinition taskDefinition, DolphinSchedulerConverterContext<Project, DagData, DataSource, ResourceInfo, UdfFunc> converterContext) {
        super(processMeta, taskDefinition, converterContext);
    }

    @Override
    public List<DwNode> convertParameter() throws IOException {
        log.info("params : {}", (Object)this.taskDefinition.getTaskParams());
        JsonObject param = (JsonObject)GsonUtils.fromJsonString((String)this.taskDefinition.getTaskParams(), JsonObject.class);
        DependentParameters dependentParameters = null;
        if (param.get("dependence") != null) {
            dependentParameters = (DependentParameters)GsonUtils.fromJson((JsonObject)param.getAsJsonObject("dependence"), DependentParameters.class);
        }
        if (dependentParameters == null || dependentParameters.getDependTaskList() == null || dependentParameters.getDependTaskList().isEmpty()) {
            log.warn("no dependence param {}", (Object)this.taskDefinition.getTaskParams());
            return Collections.emptyList();
        }
        List dependencies = dependentParameters.getDependTaskList();
        AtomicInteger outerRelationIndex = new AtomicInteger(0);
        List taskDepJoinNodes = ListUtils.emptyIfNull((List)dependencies).stream().map(dependentTaskModel -> this.conditionNodeToJoinNode((DependentTaskModel)dependentTaskModel, outerRelationIndex.getAndIncrement())).collect(Collectors.toList());
        DependentParameters dependency = dependentParameters;
        DwNode joinSuccessNode = this.newDwNode(this.taskDefinition);
        joinSuccessNode.setType(CodeProgramType.CONTROLLER_JOIN.name());
        joinSuccessNode.setName(Joiner.on((String)"_").join((Object)joinSuccessNode.getName(), (Object)"join", new Object[]{"success"}));
        ControllerJoinCode joinSuccessCode = new ControllerJoinCode();
        joinSuccessCode.setBranchList(ListUtils.emptyIfNull(taskDepJoinNodes).stream().map(Node::getOutputs).flatMap(Collection::stream).map(NodeIo::getData).distinct().map(out -> {
            ControllerJoinCode.Branch branch = new ControllerJoinCode.Branch();
            switch (dependency.getRelation()) {
                case OR: {
                    branch.setLogic(Integer.valueOf(1));
                    break;
                }
                case AND: {
                    branch.setLogic(Integer.valueOf(0));
                }
            }
            branch.setNode(out);
            branch.setRunStatus(Collections.singletonList("1"));
            return branch;
        }).collect(Collectors.toList()));
        joinSuccessCode.setResultStatus("1");
        joinSuccessNode.setCode(joinSuccessCode.getContent());
        ListUtils.emptyIfNull((List)joinSuccessNode.getOutputs()).stream().findFirst().ifPresent(out -> out.setData(this.getDefaultNodeOutput(this.processMeta, joinSuccessNode.getName())));
        joinSuccessNode.setInputs(ListUtils.emptyIfNull(taskDepJoinNodes).stream().map(Node::getOutputs).flatMap(Collection::stream).collect(Collectors.toList()));
        DwNode joinFailureNode = this.newDwNode(this.taskDefinition);
        joinFailureNode.setType(CodeProgramType.CONTROLLER_JOIN.name());
        joinFailureNode.setName(Joiner.on((String)"_").join((Object)joinFailureNode.getName(), (Object)"join", new Object[]{"failure"}));
        ControllerJoinCode joinFailureCode = new ControllerJoinCode();
        joinFailureCode.setBranchList(ListUtils.emptyIfNull(taskDepJoinNodes).stream().map(Node::getOutputs).flatMap(Collection::stream).map(NodeIo::getData).distinct().map(out -> {
            ControllerJoinCode.Branch branch = new ControllerJoinCode.Branch();
            switch (dependency.getRelation()) {
                case OR: {
                    branch.setLogic(Integer.valueOf(1));
                    break;
                }
                case AND: {
                    branch.setLogic(Integer.valueOf(0));
                }
            }
            branch.setNode(out);
            branch.setRunStatus(Collections.singletonList("1"));
            return branch;
        }).collect(Collectors.toList()));
        joinFailureCode.setResultStatus("0");
        joinFailureNode.setCode(joinFailureCode.getContent());
        ListUtils.emptyIfNull((List)joinFailureNode.getOutputs()).stream().findFirst().ifPresent(out -> out.setData(this.getDefaultNodeOutput(this.processMeta, joinFailureNode.getName())));
        joinFailureNode.setInputs(ListUtils.emptyIfNull(taskDepJoinNodes).stream().map(Node::getOutputs).flatMap(Collection::stream).collect(Collectors.toList()));
        return Arrays.asList(joinSuccessNode, joinFailureNode);
    }

    private DwNode conditionNodeToJoinNode(DependentTaskModel dependentTaskModel, int index) {
        DwNode joinNode = this.newDwNode(this.taskDefinition);
        joinNode.setType(CodeProgramType.CONTROLLER_JOIN.name());
        joinNode.setName(Joiner.on((String)"_").join((Object)joinNode.getName(), (Object)"join", new Object[]{index}));
        ListUtils.emptyIfNull((List)joinNode.getOutputs()).stream().findFirst().ifPresent(out -> out.setData(this.getDefaultNodeOutput(this.processMeta, joinNode.getName())));
        List branchList = ListUtils.emptyIfNull((List)dependentTaskModel.getDependItemList()).stream().filter(dependentItem -> dependentItem.getStatus() != null).map(dependentItem -> {
            ControllerJoinCode.Branch branch = new ControllerJoinCode.Branch();
            switch (dependentTaskModel.getRelation()) {
                case OR: {
                    branch.setLogic(Integer.valueOf(1));
                    break;
                }
                case AND: {
                    branch.setLogic(Integer.valueOf(0));
                }
            }
            TaskDefinition definition = (TaskDefinition)DolphinSchedulerV2Context.getContext().getTaskCodeMap().get(dependentItem.getDepTaskCode());
            if (definition == null) {
                log.error("can not get task definition by code {}", (Object)dependentItem.getDepTaskCode());
                return null;
            }
            branch.setNode(this.getDefaultNodeOutput(this.processMeta, definition.getName()));
            switch (dependentItem.getStatus()) {
                case FAILURE: {
                    branch.setRunStatus(Collections.singletonList("0"));
                    break;
                }
                case SUCCESS: {
                    branch.setRunStatus(Collections.singletonList("1"));
                }
            }
            return branch;
        }).collect(Collectors.toList());
        ControllerJoinCode joinCode = new ControllerJoinCode();
        joinCode.setBranchList(branchList);
        switch (dependentTaskModel.getRelation()) {
            case AND: {
                joinCode.setResultStatus("0");
                break;
            }
            case OR: {
                joinCode.setResultStatus("1");
            }
        }
        joinNode.setCode(joinCode.getContent());
        return joinNode;
    }
}

