/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.workflow.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerV1Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.ProcessMeta;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.TaskNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.enums.DbType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.procedure.ProcedureParameters;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.workflow.parameters.AbstractParameterConverter;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;

public class ProcedureParameterConverter
extends AbstractParameterConverter<ProcedureParameters> {
    public ProcedureParameterConverter(Properties properties, SpecWorkflow specWorkflow, ProcessMeta processMeta, TaskNode taskDefinition) {
        super(properties, specWorkflow, processMeta, taskDefinition);
    }

    @Override
    protected void convertParameter(SpecNode specNode) {
        List<SpecVariable> specVariableList = this.convertSpecNodeParam(specNode);
        this.convertFileResourceList(specNode);
        String convertType = this.properties.getProperty("workflow.converter.shellNodeType", CodeProgramType.DIDE_SHELL.name());
        CodeProgramType codeProgramType = CodeProgramType.getNodeTypeByName((String)convertType);
        SpecScript script = new SpecScript();
        String language = this.codeToLanguageIdentifier(codeProgramType);
        script.setLanguage(language);
        SpecScriptRuntime runtime = new SpecScriptRuntime();
        runtime.setEngine(codeProgramType.getCalcEngineType().getLabel());
        runtime.setCommand(codeProgramType.getName());
        script.setRuntime(runtime);
        script.setPath(this.getScriptPath(specNode));
        script.setContent(this.getCode());
        script.setParameters(ListUtils.emptyIfNull(specVariableList).stream().filter(v -> !VariableType.NODE_OUTPUT.equals((Object)v.getType())).collect(Collectors.toList()));
        specNode.setScript(script);
    }

    public String getCode() {
        String sqlNodeMapStr = this.properties.getProperty("workflow.converter.dolphinscheduler.sqlNodeTypeMapping", "{}");
        Map sqlTypeNodeTypeMapping = (Map)GsonUtils.fromJsonString((String)sqlNodeMapStr, (Type)new TypeToken<Map<String, DbType>>(){}.getType());
        sqlTypeNodeTypeMapping = Optional.ofNullable(sqlTypeNodeTypeMapping).orElse(new HashMap(1));
        String defaultNodeTypeIfNotSupport = this.getConverterType();
        DbType codeProgramType = (DbType)sqlTypeNodeTypeMapping.get(((ProcedureParameters)this.parameter).getType());
        if (((ProcedureParameters)this.parameter).getDatasource() > 0) {
            List list = DolphinSchedulerV1Context.getContext().getDataSources();
        }
        String code = ((ProcedureParameters)this.parameter).getMethod();
        return code;
    }

    private String getConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.target.unknownNodeTypeAs");
        return this.getConverterType(convertType, CodeProgramType.VIRTUAL.name());
    }
}

