/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.workflow.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerV1Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.ProcessMeta;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.TaskNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.dependent.DependentParameters;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.workflow.parameters.AbstractParameterConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependentParameterConverter
extends AbstractParameterConverter<DependentParameters> {
    private static final Logger log = LoggerFactory.getLogger(DependentParameterConverter.class);

    public DependentParameterConverter(Properties properties, SpecWorkflow specWorkflow, ProcessMeta processMeta, TaskNode taskDefinition) {
        super(properties, specWorkflow, processMeta, taskDefinition);
    }

    @Override
    protected void convertParameter(SpecNode specNode) {
        List<SpecVariable> specVariableList = this.convertSpecNodeParam(specNode);
        this.convertFileResourceList(specNode);
        CodeProgramType codeProgramType = CodeProgramType.VIRTUAL;
        SpecScript script = new SpecScript();
        String language = this.codeToLanguageIdentifier(codeProgramType);
        script.setLanguage(language);
        SpecScriptRuntime runtime = new SpecScriptRuntime();
        runtime.setEngine(codeProgramType.getCalcEngineType().getLabel());
        runtime.setCommand(codeProgramType.getName());
        script.setRuntime(runtime);
        script.setPath(this.getScriptPath(specNode));
        script.setParameters(ListUtils.emptyIfNull(specVariableList).stream().filter(v -> !VariableType.NODE_OUTPUT.equals((Object)v.getType())).collect(Collectors.toList()));
        specNode.setScript(script);
        DolphinSchedulerV1Context context = DolphinSchedulerV1Context.getContext();
        List<String> deps = this.convertDeps();
        context.getSpecNodeProcessCodeMap().put(specNode, deps);
    }

    public List<String> convertDeps() {
        log.info("params : {}", (Object)this.taskDefinition.getParams());
        DependentParameters dependentParameters = this.taskDefinition.getDependence();
        if (dependentParameters == null || dependentParameters.getDependTaskList() == null || dependentParameters.getDependTaskList().isEmpty()) {
            log.warn("no dependence param {}", (Object)this.taskDefinition.getParams());
            return Collections.emptyList();
        }
        DolphinSchedulerV1Context context = DolphinSchedulerV1Context.getContext();
        List dependencies = dependentParameters.getDependTaskList();
        ArrayList<String> taskIds = new ArrayList<String>();
        ListUtils.emptyIfNull((List)dependencies).forEach(dependModel -> ListUtils.emptyIfNull((List)dependModel.getDependItemList()).forEach(depItem -> {
            String tasks = depItem.getDepTasks();
            if (StringUtils.equalsIgnoreCase((CharSequence)"all", (CharSequence)tasks)) {
                List taskDefinitions = (List)context.getProcessCodeTaskRelationMap().get(depItem.getDefinitionId());
                for (Object task : CollectionUtils.emptyIfNull((Collection)taskDefinitions)) {
                    TaskNode taskNode = (TaskNode)task;
                    if (taskIds.contains(taskNode.getId())) continue;
                    taskIds.add(taskNode.getId());
                }
            } else if (!taskIds.contains(depItem.getDepTasks())) {
                taskIds.add(depItem.getDepTasks());
            }
        }));
        return taskIds;
    }
}

