/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.workflow;

import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.Spec;
import com.aliyun.dataworks.common.spec.domain.Specification;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.DependencyType;
import com.aliyun.dataworks.common.spec.domain.enums.SpecKind;
import com.aliyun.dataworks.common.spec.domain.noref.SpecDepend;
import com.aliyun.dataworks.common.spec.domain.noref.SpecFlowDepend;
import com.aliyun.dataworks.common.spec.domain.noref.SpecSubFlow;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.DolphinSchedulerPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerV1Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.ProcessData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.ProcessMeta;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.entity.ResourceInfo;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.workflow.V1ProcessDefinitionConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class DolphinSchedulerV1WorkflowConverter {
    public static final String SPEC_VERSION = "1.2.0";
    protected List<ProcessMeta> processMetaList;
    protected Map<String, CodeProgramType> nodeTypeMap = new HashMap<String, CodeProgramType>();
    private DolphinSchedulerPackage<Project, ProcessMeta, DataSource, ResourceInfo, UdfFunc> dolphinSchedulerPackage;
    private final Properties converterProperties;

    public DolphinSchedulerV1WorkflowConverter(DolphinSchedulerPackage dolphinSchedulerPackage, Properties converterProperties) {
        this.dolphinSchedulerPackage = dolphinSchedulerPackage;
        this.converterProperties = converterProperties;
    }

    public List<Specification<DataWorksWorkflowSpec>> convert() {
        this.processMetaList = this.dolphinSchedulerPackage.getProcessDefinitions().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        ArrayList<Specification<DataWorksWorkflowSpec>> specifications = new ArrayList<Specification<DataWorksWorkflowSpec>>();
        for (ProcessMeta processMeta : this.processMetaList) {
            ArrayList<SpecWorkflow> workflows = new ArrayList<SpecWorkflow>();
            Specification specification = new Specification();
            specification.setKind(SpecKind.CYCLE_WORKFLOW.getLabel());
            specification.setVersion(SPEC_VERSION);
            DataWorksWorkflowSpec spec = new DataWorksWorkflowSpec();
            String processName = processMeta.getProcessDefinitionName();
            spec.setName(processName);
            ProcessData processData = processMeta.getProcessDefinitionJson();
            V1ProcessDefinitionConverter converter = new V1ProcessDefinitionConverter(processMeta, processData.getTasks(), this.converterProperties);
            SpecWorkflow workflow = converter.convert();
            workflows.add(workflow);
            spec.setWorkflows(workflows);
            specification.setSpec((Spec)spec);
            specifications.add((Specification<DataWorksWorkflowSpec>)specification);
        }
        this.handleSubprocess();
        this.handleDependents(specifications);
        return specifications;
    }

    private void handleSubprocess() {
        Map codeWorkflowMap = DolphinSchedulerV1Context.getContext().getSubProcessCodeWorkflowMap();
        Map codeNodeMap = DolphinSchedulerV1Context.getContext().getSubProcessCodeNodeMap();
        for (Map.Entry entry : codeNodeMap.entrySet()) {
            SpecNodeOutput specNodeOutput;
            SpecWorkflow specWorkflow = (SpecWorkflow)codeWorkflowMap.get(entry.getKey());
            if (specWorkflow.getOutputs().isEmpty()) {
                specNodeOutput = new SpecNodeOutput();
                specNodeOutput.setData(specWorkflow.getId());
                specWorkflow.getOutputs().add(specNodeOutput);
            } else {
                specNodeOutput = (SpecNodeOutput)specWorkflow.getOutputs().get(0);
            }
            SpecNode subprocess = (SpecNode)entry.getValue();
            SpecSubFlow subflow = new SpecSubFlow();
            subflow.setOutput(specNodeOutput.getData());
            subprocess.setSubflow(subflow);
        }
    }

    private void handleDependents(List<Specification<DataWorksWorkflowSpec>> specifications) {
        HashMap nodeIdWorkflowMap = new HashMap();
        for (Specification<DataWorksWorkflowSpec> specification : specifications) {
            ((DataWorksWorkflowSpec)specification.getSpec()).getWorkflows().forEach(workflow -> workflow.getNodes().forEach(node -> nodeIdWorkflowMap.put(node.getId(), workflow)));
        }
        Map taskCodeSpecNodeMap = DolphinSchedulerV1Context.getContext().getTaskCodeSpecNodeMap();
        Map depMap = DolphinSchedulerV1Context.getContext().getSpecNodeProcessCodeMap();
        for (Map.Entry entry : depMap.entrySet()) {
            SpecNode specNode = (SpecNode)entry.getKey();
            SpecWorkflow workflow2 = (SpecWorkflow)nodeIdWorkflowMap.get(specNode.getId());
            SpecFlowDepend specFlowDepend = new SpecFlowDepend();
            List dependents = (List)entry.getValue();
            ArrayList<SpecDepend> depends = new ArrayList<SpecDepend>();
            for (String id : dependents) {
                SpecNode depNode = (SpecNode)taskCodeSpecNodeMap.get(id);
                SpecNodeOutput specNodeOutput = new SpecNodeOutput();
                specNodeOutput.setData(depNode.getId());
                SpecDepend specDepend = new SpecDepend(null, DependencyType.NORMAL, specNodeOutput);
                depends.add(specDepend);
            }
            specFlowDepend.setDepends(depends);
            specFlowDepend.setNodeId(specNode);
            workflow2.getDependencies().add(specFlowDepend);
        }
    }
}

