/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.types.CalcEngineType;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.ProcessMeta;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.TaskNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.entity.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.python.PythonParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwResource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DataStudioCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.core.utils.EmrCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters.AbstractParameterConverter;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonParameterConverter
extends AbstractParameterConverter<PythonParameters> {
    private static final Logger log = LoggerFactory.getLogger(PythonParameterConverter.class);

    public PythonParameterConverter(ProcessMeta processMeta, TaskNode taskDefinition, DolphinSchedulerConverterContext<Project, ProcessMeta, DataSource, ResourceInfo, UdfFunc> converterContext) {
        super(processMeta, taskDefinition, converterContext);
    }

    @Override
    public List<DwNode> convertParameter() throws IOException {
        DwNode dwNode = this.newDwNode(this.processMeta, this.taskDefinition);
        String type = this.getConverterType();
        dwNode.setType(type);
        DwResource pyRes = new DwResource();
        pyRes.setName(Joiner.on((String)"_").join((Object)this.processMeta.getProcessDefinitionName(), (Object)this.taskDefinition.getName(), new Object[0]) + ".py");
        pyRes.setWorkflowRef(this.dwWorkflow);
        this.dwWorkflow.getResources().add(pyRes);
        List resources = ListUtils.emptyIfNull((List)((PythonParameters)this.parameter).getResourceList()).stream().map(ResourceInfo::getName).distinct().collect(Collectors.toList());
        resources.add(pyRes.getName());
        dwNode.setCode(Joiner.on((String)"\n").join((Object)DataStudioCodeUtils.addResourceReference((CodeProgramType)CodeProgramType.valueOf((String)dwNode.getType()), (String)"", resources), (Object)("python ./" + pyRes.getName()), new Object[0]));
        String engineType = this.properties.getProperty("workflow.converter.target.engine.type", "");
        if (StringUtils.equalsIgnoreCase((CharSequence)CalcEngineType.EMR.name(), (CharSequence)engineType)) {
            pyRes.setType(CodeProgramType.EMR_FILE.name());
            dwNode.setCode(EmrCodeUtils.toEmrCode((Node)dwNode));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)CalcEngineType.HADOOP_CDH.name(), (CharSequence)engineType)) {
            pyRes.setType(CodeProgramType.CDH_FILE.name());
        } else {
            pyRes.setType(CodeProgramType.ODPS_PYTHON.name());
        }
        File tmpFIle = new File(FileUtils.getTempDirectory(), pyRes.getName());
        FileUtils.writeStringToFile((File)tmpFIle, (String)((PythonParameters)this.parameter).getRawScript(), (Charset)StandardCharsets.UTF_8);
        pyRes.setLocalPath(tmpFIle.getAbsolutePath());
        return Arrays.asList(dwNode);
    }

    private String getConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.shellNodeType");
        String defaultConvertType = CodeProgramType.DIDE_SHELL.name();
        return this.getConverterType(convertType, defaultConvertType);
    }
}

