/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.DolphinSchedulerPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.DolphinSchedulerVersion;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.ProcessMeta;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.BaseDataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.DataSourceFactory;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.entity.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.enums.DbType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.enums.TaskType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.subprocess.SubProcessParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Asset;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwDatasource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNodeIo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Workflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.connection.JdbcConnection;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.AssetType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.NodeUseType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.tenant.EnvType;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.AbstractDolphinSchedulerConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.V1ProcessDefinitionConverter;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DolphinSchedulerV1Converter
extends AbstractDolphinSchedulerConverter {
    private static final Logger log = LoggerFactory.getLogger(DolphinSchedulerV1Converter.class);
    public static final DolphinSchedulerVersion version = DolphinSchedulerVersion.V1;
    protected List<ProcessMeta> processMetaList = new ArrayList<ProcessMeta>();
    protected List<DwWorkflow> dwWorkflowList = new ArrayList<DwWorkflow>();
    protected Map<String, CodeProgramType> nodeTypeMap = new HashMap<String, CodeProgramType>();
    private DolphinSchedulerPackage<com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.Project, ProcessMeta, DataSource, ResourceInfo, UdfFunc> dolphinSchedulerPackage;

    public DolphinSchedulerV1Converter(DolphinSchedulerPackage dolphinSchedulerPackage) {
        super(AssetType.DOLPHINSCHEDULER, DolphinSchedulerV1Converter.class.getSimpleName());
        this.dolphinSchedulerPackage = dolphinSchedulerPackage;
    }

    @Override
    public List<DwWorkflow> convert(Asset asset) throws Exception {
        this.processMetaList = this.dolphinSchedulerPackage.getProcessDefinitions().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        this.dwWorkflowList = this.convertProcessMetaListToDwWorkflowList(this.processMetaList);
        this.processSubProcessDefinitionDepends();
        this.setProjectRootDependForNoInputNode(this.project, this.dwWorkflowList);
        this.convertDatasources(this.project);
        return this.dwWorkflowList;
    }

    private void convertDatasources(Project project) {
        project.setDatasources(ListUtils.emptyIfNull((List)this.dolphinSchedulerPackage.getDatasources()).stream().map(ds -> {
            DwDatasource dwDatasource = new DwDatasource();
            dwDatasource.setName(ds.getName());
            dwDatasource.setType(StringUtils.lowerCase((String)ds.getType().name()));
            DbType dbType = DbType.valueOf((String)ds.getType().name());
            BaseDataSource baseDataSource = DataSourceFactory.getDatasource((String)ds.getType().name(), (String)ds.getConnectionParams());
            Optional.ofNullable(baseDataSource).ifPresent(datasource -> {
                switch (dbType) {
                    case MYSQL: 
                    case POSTGRESQL: 
                    case ORACLE: 
                    case H2: 
                    case DB2: 
                    case CLICKHOUSE: 
                    case SQLSERVER: {
                        this.setJdbcConnection((BaseDataSource)datasource, dwDatasource);
                        break;
                    }
                }
            });
            dwDatasource.setEnvType(EnvType.PRD.name());
            dwDatasource.setDescription(ds.getNote());
            return dwDatasource;
        }).collect(Collectors.toList()));
    }

    private void setJdbcConnection(BaseDataSource datasource, DwDatasource dwDatasource) {
        JdbcConnection conn = new JdbcConnection();
        conn.setUsername(datasource.getUser());
        conn.setPassword(datasource.getPassword());
        conn.setDatabase(datasource.getDatabase());
        conn.setJdbcUrl(datasource.getAddress());
        conn.setTag("public");
        dwDatasource.setConnection(GsonUtils.defaultGson.toJson((Object)conn));
    }

    private void processSubProcessDefinitionDepends() {
        ListUtils.emptyIfNull(this.dwWorkflowList).forEach(workflow -> ListUtils.emptyIfNull((List)workflow.getNodes()).stream().filter(n -> StringUtils.equalsIgnoreCase((CharSequence)TaskType.SUB_PROCESS.name(), (CharSequence)((DwNode)n).getRawNodeType())).forEach(subProcessNode -> {
            SubProcessParameters subProcessParameter = (SubProcessParameters)GsonUtils.fromJsonString((String)subProcessNode.getCode(), (Type)new TypeToken<SubProcessParameters>(){}.getType());
            this.dolphinSchedulerPackage.getProcessDefinitions().values().stream().map(defList -> ListUtils.emptyIfNull((List)defList).stream().filter(df -> subProcessParameter != null).filter(df -> Objects.equals(df.getProcessDefinitionId(), subProcessParameter.getProcessDefinitionId())).findFirst().flatMap(proDef -> this.dwWorkflowList.stream().filter(wf -> StringUtils.equals((CharSequence)V1ProcessDefinitionConverter.toWorkflowName(proDef), (CharSequence)wf.getName())).findFirst().map(wf -> this.addStartEndNodeToDependedWorkflow((Node)subProcessNode, (ProcessMeta)proDef, (DwWorkflow)wf))).orElse(new DwNodeIo())).filter(io -> StringUtils.isNotBlank((CharSequence)io.getData())).findFirst().ifPresent(endNodeOut -> ListUtils.emptyIfNull((List)workflow.getNodes()).stream().filter(n -> ListUtils.emptyIfNull((List)n.getInputs()).stream().anyMatch(in -> ListUtils.emptyIfNull((List)subProcessNode.getOutputs()).stream().anyMatch(out -> StringUtils.equalsIgnoreCase((CharSequence)out.getData(), (CharSequence)in.getData())))).forEach(child -> ListUtils.emptyIfNull((List)child.getInputs()).stream().filter(in -> ListUtils.emptyIfNull((List)subProcessNode.getOutputs()).stream().anyMatch(depOut -> StringUtils.equalsIgnoreCase((CharSequence)in.getData(), (CharSequence)depOut.getData()))).forEach(in -> in.setData(endNodeOut.getData()))));
        }));
    }

    private DwNodeIo addStartEndNodeToDependedWorkflow(Node subProcessNode, ProcessMeta proDef, DwWorkflow wf) {
        DwNode startNode = new DwNode();
        startNode.setDescription("node added by dataworks migration service");
        startNode.setRawNodeType(CodeProgramType.VIRTUAL.name());
        startNode.setDependentType(Integer.valueOf(0));
        startNode.setCycleType(Integer.valueOf(0));
        startNode.setNodeUseType(NodeUseType.SCHEDULED);
        startNode.setCronExpress("day");
        startNode.setName(Joiner.on((String)"_").join((Object)"start", (Object)proDef.getProjectName(), new Object[]{proDef.getProcessDefinitionName()}));
        startNode.setType(CodeProgramType.VIRTUAL.name());
        startNode.setWorkflowRef((Workflow)wf);
        DwNodeIo startNodeOutput = new DwNodeIo();
        startNodeOutput.setData(Joiner.on((String)".").join((Object)this.project.getName(), (Object)proDef.getProjectName(), new Object[]{proDef.getProcessDefinitionName(), "start"}));
        startNodeOutput.setParseType(Integer.valueOf(1));
        startNode.setOutputs(Collections.singletonList(startNodeOutput));
        startNode.setInputs(new ArrayList());
        ListUtils.emptyIfNull((List)subProcessNode.getOutputs()).stream().findFirst().ifPresent(depOut -> startNode.getInputs().add(depOut));
        DwNode endNode = new DwNode();
        endNode.setDescription("node added by dataworks migration service");
        endNode.setRawNodeType(CodeProgramType.VIRTUAL.name());
        endNode.setDependentType(Integer.valueOf(0));
        endNode.setCycleType(Integer.valueOf(0));
        endNode.setNodeUseType(NodeUseType.SCHEDULED);
        endNode.setCronExpress("day");
        endNode.setName(Joiner.on((String)"_").join((Object)"end", (Object)proDef.getProjectName(), new Object[]{proDef.getProcessDefinitionName()}));
        endNode.setType(CodeProgramType.VIRTUAL.name());
        endNode.setWorkflowRef((Workflow)wf);
        DwNodeIo endNodeOutput = new DwNodeIo();
        endNodeOutput.setData(Joiner.on((String)".").join((Object)this.project.getName(), (Object)proDef.getProjectName(), new Object[]{proDef.getProcessDefinitionName(), "end"}));
        endNodeOutput.setParseType(Integer.valueOf(1));
        endNode.setOutputs(Collections.singletonList(endNodeOutput));
        endNode.setInputs(new ArrayList());
        ListUtils.emptyIfNull((List)wf.getNodes()).forEach(node -> {
            String prefix = Joiner.on((String)".").join((Object)this.project.getName(), (Object)proDef.getProjectName(), new Object[0]);
            if (ListUtils.emptyIfNull((List)node.getInputs()).stream().noneMatch(in -> StringUtils.startsWithIgnoreCase((CharSequence)in.getData(), (CharSequence)prefix))) {
                node.getInputs().add(startNodeOutput);
            }
            if (ListUtils.emptyIfNull((List)wf.getNodes()).stream().map(Node::getInputs).flatMap(Collection::stream).noneMatch(in -> ListUtils.emptyIfNull((List)node.getOutputs()).stream().anyMatch(out -> StringUtils.equalsIgnoreCase((CharSequence)in.getData(), (CharSequence)out.getData())))) {
                ListUtils.emptyIfNull((List)node.getOutputs()).stream().findFirst().ifPresent(out -> endNode.getInputs().add(out));
            }
        });
        wf.getNodes().add(startNode);
        wf.getNodes().add(endNode);
        return endNodeOutput;
    }

    protected Map<String, CodeProgramType> getNodeTypeMap() {
        String map = this.properties.getProperty("workflow.converter.dolphinscheduler.nodeTypeMapping", "{}");
        Map mapping = (Map)GsonUtils.fromJsonString((String)map, (Type)new TypeToken<Map<String, CodeProgramType>>(){}.getType());
        return MapUtils.emptyIfNull((Map)mapping);
    }

    private List<DwWorkflow> convertProcessMetaListToDwWorkflowList(List<ProcessMeta> processMetaList) {
        return ListUtils.emptyIfNull(processMetaList).stream().map(this::convertProcessMetaToDwWorkflow).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<DwWorkflow> convertProcessMetaToDwWorkflow(ProcessMeta processMeta) {
        DolphinSchedulerConverterContext<com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.Project, ProcessMeta, DataSource, ResourceInfo, UdfFunc> converterContext = new DolphinSchedulerConverterContext<com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.Project, ProcessMeta, DataSource, ResourceInfo, UdfFunc>();
        converterContext.setProject(this.project);
        converterContext.setProperties(this.properties);
        converterContext.setDolphinSchedulerPackage(this.dolphinSchedulerPackage);
        V1ProcessDefinitionConverter converter = new V1ProcessDefinitionConverter(converterContext, processMeta);
        return converter.convert();
    }
}

