/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.filters;

import com.aliyun.migrationx.common.utils.Config;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class DolphinSchedulerConverterFilter {
    private final List<String> filters = Config.get().getFilterTasks();
    private final boolean skip = CollectionUtils.isEmpty(this.filters) || this.filters.size() == 1 && this.filters.get(0).equals("*");

    public boolean filterTasks(String projectName, String processName, String taskName) {
        if (this.skip) {
            return true;
        }
        String taskIdentity = String.format("%s.%s.%s", projectName, processName, taskName);
        if (this.filters.contains(taskIdentity)) {
            return true;
        }
        String processIdentity = String.format("%s.%s.*", projectName, processName);
        if (this.filters.contains(processIdentity)) {
            return true;
        }
        String projectIdentity = String.format("%s.*", projectName, processName);
        return this.filters.contains(projectIdentity);
    }
}

