/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.utils;

import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipUtils.class);
    private static String SUFFIX_TAR_GZ = ".tar.gz";
    private static String SUFFIX_GZIP = ".gzip";
    private static String SUFFIX_TGZ = ".tgz";
    private static String SUFFIX_ZIP = ".zip";
    private static String SUFFIX_TAR = ".tar";
    private static String SUFFIX_GZ = ".gz";
    private static String TYPE_TGZ = "tgz";
    private static String TYPE_TAR = "tar";
    private static String TYPE_ZIP = "zip";
    private static String TYPE_GZIP = "gzip";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unzipExportFile(File localFile) throws IOException {
        File localDir = new File(localFile.getAbsolutePath().replaceAll("\\.\\w+$", ""));
        if (!localDir.getParentFile().exists()) {
            localDir.getParentFile().mkdirs();
        }
        LOGGER.info("unzip export file to: {}", (Object)localDir);
        LOGGER.info("force delete dir: {} ", (Object)localDir);
        if (localDir.exists()) {
            FileUtils.forceDelete((File)localDir);
        }
        File unzippedDir = localDir;
        byte[] buffer = new byte[10240];
        ZipInputStream zis = new ZipInputStream(new FileInputStream(localFile));
        java.util.zip.ZipEntry zipEntry = zis.getNextEntry();
        try {
            while (zipEntry != null) {
                int len;
                File newFile = new File(localDir, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    FileUtils.forceMkdir((File)newFile);
                    zipEntry = zis.getNextEntry();
                    continue;
                }
                if (!newFile.getParentFile().exists()) {
                    newFile.getParentFile().mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                zipEntry = zis.getNextEntry();
            }
        }
        finally {
            zis.closeEntry();
            zis.close();
        }
        return unzippedDir;
    }

    public static File _zipDir(File zipDir, File zipFile) {
        ZipUtils.zipDeploymentPackage(zipDir.getAbsolutePath(), zipFile.getAbsolutePath(), "gbk");
        if (!zipFile.exists()) {
            throw new RuntimeException("zip file failed, zip not found: " + zipFile.getAbsolutePath());
        }
        return zipFile;
    }

    public static void zipDeploymentPackage(String deploymentPath, String zipPath, String encoding) {
        File zipFile = new File(zipPath);
        if (!zipFile.getParentFile().exists() && !zipFile.getParentFile().mkdirs()) {
            LOGGER.error(String.format("Zip File [%s] Failed", zipPath));
            throw new RuntimeException("Zip File Error");
        }
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream((OutputStream)new FileOutputStream(new File(zipPath)));
            zos.setEncoding(encoding);
            ZipUtils.handleDir(new File(deploymentPath), zos, "");
        }
        catch (Exception e) {
            try {
                LOGGER.error(String.format("File path [%s] not valid", zipPath), (Throwable)e);
                throw new RuntimeException("zip file error", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)zos);
    }

    private static void handleDir(File file, ZipOutputStream zos, String parentDir) {
        ZipUtils.handleDir(file, zos, parentDir, new byte[4096]);
    }

    private static void handleDir(File file, ZipOutputStream zos, String parentDir, byte[] zipInputBuf) {
        File[] fileList = file.listFiles();
        if (fileList == null) {
            LOGGER.error(String.format("may be path [%s] is not directory or I/O error occurs", file.getAbsolutePath()));
            throw new RuntimeException("zip file path error");
        }
        try {
            if (fileList.length == 0) {
                zos.putNextEntry(new ZipEntry(parentDir + "/"));
                zos.closeEntry();
            } else {
                int readBytes = 0;
                for (File subFile : fileList) {
                    if (subFile.isDirectory()) {
                        ZipUtils.handleDir(subFile, zos, parentDir + subFile.getName() + "/", zipInputBuf);
                        continue;
                    }
                    BufferedInputStream fileIns = new BufferedInputStream(new FileInputStream(subFile));
                    try {
                        zos.putNextEntry(new ZipEntry(parentDir + subFile.getName()));
                        while ((readBytes = ((InputStream)fileIns).read(zipInputBuf)) > 0) {
                            zos.write(zipInputBuf, 0, readBytes);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("zip file create failed");
                        throw new RuntimeException("zip file create failed", e);
                    }
                    finally {
                        ((InputStream)fileIns).close();
                        zos.closeEntry();
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Creating Zip File Failed");
            throw new RuntimeException("zip file create failed", e);
        }
    }

    public static void unzipDeploymentPackage(String zipPath, String deploymentPath, String encoding) {
        InputStream zipInputStream = null;
        FileOutputStream fileOutputStream = null;
        int readBytes = 0;
        byte[] byteBuf = new byte[4096];
        try {
            ZipFile zipFile = new ZipFile(zipPath, encoding);
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)entries.nextElement();
                File file = new File(deploymentPath + "/" + zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    if (file.mkdirs()) continue;
                    LOGGER.error(String.format("Make Dirs [%s] Failed", file.getName()));
                    throw new RuntimeException("unzip file failed");
                }
                File parentFile = file.getParentFile();
                if (!parentFile.exists() && !parentFile.mkdirs()) {
                    LOGGER.error(String.format("Make Dirs [%s] Failed", parentFile.getName()));
                    throw new RuntimeException("unzip file failed");
                }
                try {
                    zipInputStream = zipFile.getInputStream(zipEntry);
                    fileOutputStream = new FileOutputStream(file);
                    while ((readBytes = zipInputStream.read(byteBuf)) > 0) {
                        ((OutputStream)fileOutputStream).write(byteBuf, 0, readBytes);
                    }
                }
                catch (Exception e) {
                    try {
                        LOGGER.error(String.format("unzip file [%s] failed", zipPath));
                        throw new RuntimeException("unzip file failed", e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fileOutputStream);
                        IOUtils.closeQuietly((InputStream)zipInputStream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)fileOutputStream);
                IOUtils.closeQuietly((InputStream)zipInputStream);
            }
            zipFile.close();
        }
        catch (IOException e) {
            LOGGER.error(String.format("Unzip File [%s] failed", zipPath));
            throw new RuntimeException("unzip file failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unzipExportFile(File zipFile, File targetDir) throws IOException {
        LOGGER.info("unzip export file to: {}", (Object)targetDir);
        if (targetDir.exists() && !targetDir.isDirectory()) {
            targetDir = targetDir.getParentFile();
        }
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        File unzippedDir = targetDir;
        byte[] buffer = new byte[10240];
        ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
        java.util.zip.ZipEntry zipEntry = zis.getNextEntry();
        try {
            while (zipEntry != null) {
                int len;
                File newFile = new File(unzippedDir, zipEntry.getName());
                if (!newFile.getParentFile().exists()) {
                    newFile.getParentFile().mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                zipEntry = zis.getNextEntry();
            }
        }
        finally {
            zis.closeEntry();
            zis.close();
        }
        return unzippedDir;
    }

    private static ArchiveInputStream createArchiveInputByType(String packageFile, String type) throws FileNotFoundException, CompressorException, ArchiveException {
        if (TYPE_TGZ.equals(type)) {
            ArchiveInputStream archiveInput = new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)new CompressorStreamFactory().createCompressorInputStream("gz", (InputStream)new FileInputStream(packageFile)));
            return archiveInput;
        }
        if (TYPE_ZIP.equals(type)) {
            ArchiveInputStream archiveInput = new ArchiveStreamFactory().createArchiveInputStream("zip", (InputStream)new FileInputStream(packageFile));
            return archiveInput;
        }
        if (TYPE_GZIP.equals(type)) {
            ArchiveInputStream archiveInput = new ArchiveStreamFactory().createArchiveInputStream("zip", (InputStream)new CompressorStreamFactory().createCompressorInputStream("gz", (InputStream)new FileInputStream(packageFile)));
            return archiveInput;
        }
        if (TYPE_TAR.equals(type)) {
            ArchiveInputStream archiveInput = new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)new FileInputStream(packageFile));
            return archiveInput;
        }
        return null;
    }

    private static String inferType(String packageFile, String defaultType) {
        if (packageFile.endsWith(SUFFIX_TAR_GZ)) {
            return TYPE_TGZ;
        }
        if (packageFile.endsWith(SUFFIX_GZIP)) {
            return TYPE_GZIP;
        }
        if (packageFile.endsWith(SUFFIX_TGZ)) {
            return TYPE_TGZ;
        }
        if (packageFile.endsWith(SUFFIX_TAR)) {
            return TYPE_TAR;
        }
        if (packageFile.endsWith(SUFFIX_ZIP)) {
            return TYPE_ZIP;
        }
        if (packageFile.endsWith(SUFFIX_GZ)) {
            return TYPE_GZIP;
        }
        return defaultType;
    }

    public static File decompress(File packageFile) throws IOException {
        return ZipUtils.decompress(packageFile, TYPE_ZIP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File decompress(File packageFile, String defaultType) throws IOException {
        File localDir = new File(packageFile.getAbsolutePath().replaceAll("\\.\\w+$", ""));
        if (localDir.equals(packageFile)) {
            localDir = new File(packageFile.getParentFile(), localDir.getName() + "_unzipped");
        }
        if (!localDir.getParentFile().exists()) {
            localDir.getParentFile().mkdirs();
        }
        LOGGER.info("unzip export file to: {}", (Object)localDir);
        LOGGER.info("force delete dir: {} ", (Object)localDir);
        if (localDir.exists()) {
            FileUtils.forceDelete((File)localDir);
        }
        File dirPath = localDir;
        ArchiveInputStream archiveInput = null;
        try {
            ArchiveEntry entry;
            archiveInput = ZipUtils.createArchiveInputByType(packageFile.getAbsolutePath(), ZipUtils.inferType(packageFile.getName(), defaultType));
            ArchiveEntry archiveEntry = entry = archiveInput == null ? null : archiveInput.getNextEntry();
            while (entry != null) {
                File file = new File(dirPath, entry.getName());
                if (entry.isDirectory()) {
                    file.mkdirs();
                } else if (!file.isHidden()) {
                    file.getParentFile().mkdirs();
                    ByteStreams.copy((InputStream)archiveInput, (OutputStream)new FileOutputStream(file));
                }
                entry = archiveInput.getNextEntry();
            }
        }
        catch (ArchiveException | CompressorException e) {
            LOGGER.error(ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        catch (FileNotFoundException e) {
            LOGGER.error("decompress file " + packageFile + " failed:", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("decompress file " + packageFile + " exception: ", (Throwable)e);
            LOGGER.error(ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        finally {
            if (archiveInput != null) {
                try {
                    archiveInput.close();
                }
                catch (IOException e) {
                    LOGGER.error("close archive exception: " + e.getMessage());
                }
            }
        }
        return dirPath;
    }

    public static File zipDir(File zipPath, File zipFile) throws IOException {
        if (!zipFile.getParentFile().exists() && !zipFile.getParentFile().mkdirs()) {
            LOGGER.error(String.format("Zip File [%s] Failed", zipPath));
            throw new RuntimeException("Zip File Error");
        }
        if (zipFile.exists()) {
            FileUtils.forceDelete((File)zipFile);
        }
        try (ZipArchiveOutputStream zipArchiveOutputStream = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(zipFile));){
            ZipUtils.zipDirectory(zipPath, zipArchiveOutputStream, "");
        }
        catch (Exception e) {
            LOGGER.error("zip directory error: {}, exception: ", (Object)zipPath, (Object)e);
            throw new RuntimeException("zip file error", e);
        }
        if (!zipFile.exists()) {
            throw new RuntimeException("zip file failed, zip not found: " + zipFile.getAbsolutePath());
        }
        return zipFile;
    }

    private static void zipDirectory(File zipPath, ZipArchiveOutputStream zipArchiveOutputStream, String parentDir) throws IOException {
        if (zipPath == null || !zipPath.isDirectory()) {
            return;
        }
        File[] subFiles = zipPath.listFiles();
        if (subFiles == null || subFiles.length == 0) {
            zipArchiveOutputStream.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(parentDir + "/"));
            zipArchiveOutputStream.closeArchiveEntry();
            return;
        }
        for (File subFile : subFiles) {
            if (subFile.isDirectory()) {
                ZipUtils.zipDirectory(subFile, zipArchiveOutputStream, parentDir + subFile.getName() + "/");
                continue;
            }
            try (BufferedInputStream fileIns = new BufferedInputStream(new FileInputStream(subFile));){
                int readBytes;
                zipArchiveOutputStream.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(parentDir + subFile.getName()));
                byte[] bytes = new byte[4096];
                while ((readBytes = ((InputStream)fileIns).read(bytes)) > 0) {
                    zipArchiveOutputStream.write(bytes, 0, readBytes);
                }
            }
            catch (Exception e) {
                LOGGER.error("zip file {} failed", (Object)subFile);
                throw new RuntimeException("zip file error: " + subFile, e);
            }
            finally {
                zipArchiveOutputStream.closeArchiveEntry();
            }
        }
    }
}

