/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.translator;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.OdpsSparkCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwResource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Resource;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.ResourceUtils;
import com.aliyun.dataworks.migrationx.transformer.core.report.ReportItem;
import com.aliyun.dataworks.migrationx.transformer.core.report.Reportable;
import com.aliyun.dataworks.migrationx.transformer.core.spark.command.SparkSubmitCommandBuilder;
import com.aliyun.dataworks.migrationx.transformer.core.translator.NodePropertyTranslator;
import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import com.google.common.base.Joiner;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkSubmitTranslator
implements Reportable,
NodePropertyTranslator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkSubmitTranslator.class);
    public static Pattern SPARK_SUBMIT_PATTERN = Pattern.compile("[\\s|\\n|\\t]*spark-submit.*");
    private List<ReportItem> reportItems = new ArrayList<ReportItem>();

    @Override
    public List<ReportItem> getReport() {
        return this.reportItems;
    }

    @Override
    public boolean match(DwWorkflow workflow, DwNode node) {
        if (StringUtils.isBlank((String)node.getCode())) {
            return false;
        }
        Matcher matcher = SPARK_SUBMIT_PATTERN.matcher(node.getCode());
        boolean matched = matcher.find();
        LOGGER.debug("pattern: {}, matched: {}, code: {}", new Object[]{SPARK_SUBMIT_PATTERN, matched, node.getCode()});
        return matched;
    }

    @Override
    public boolean translate(DwWorkflow workflow, DwNode node) {
        if (!this.match(workflow, node)) {
            return false;
        }
        CodeProgramType defaultNodeType = CodeProgramType.valueOf((String)node.getType());
        LOGGER.info("node type: {}", (Object)defaultNodeType);
        switch (defaultNodeType) {
            case ODPS_SPARK: {
                this.convertToOdpsSpark(workflow, node);
                break;
            }
            case EMR_SPARK: 
            case CDH_SPARK: {
                this.convertSpark(workflow, node, defaultNodeType.getCalcEngineType().name());
                node.setType(defaultNodeType.name());
            }
        }
        return true;
    }

    private void convertSpark(DwWorkflow workflow, DwNode node, String calcEngineType) {
        SparkSubmitCommandBuilder sparkSubmitCommandBuilder = this.getSparkSubmitCommandBuilder(node.getCode());
        if (sparkSubmitCommandBuilder == null) {
            return;
        }
        List<String> appResources = this.handleResources(workflow, Arrays.asList(sparkSubmitCommandBuilder.getAppResource()), calcEngineType);
        List jars = this.handleResources(workflow, sparkSubmitCommandBuilder.getJars(), calcEngineType).stream().filter(str -> str.endsWith("jar")).collect(Collectors.toList());
        List assistFiles = this.handleResources(workflow, sparkSubmitCommandBuilder.getFiles(), calcEngineType).stream().filter(str -> str.split("\\.").length == 1).collect(Collectors.toList());
        List pyFiles = this.handleResources(workflow, sparkSubmitCommandBuilder.getPyFiles(), calcEngineType).stream().filter(str -> str.endsWith("py")).collect(Collectors.toList());
        List assistArchives = this.handleResources(workflow, sparkSubmitCommandBuilder.getFiles(), calcEngineType).stream().filter(str -> str.split("\\.").length == 2 && ResourceUtils.FILE_EXT_ARCHIVE.contains(str.split("\\.")[1].toLowerCase())).collect(Collectors.toList());
        ArrayList<String> referenceResources = new ArrayList<String>();
        referenceResources.addAll(appResources);
        referenceResources.addAll(jars);
        referenceResources.addAll(assistFiles);
        referenceResources.addAll(pyFiles);
        referenceResources.addAll(assistArchives);
        String resReferenceCode = referenceResources.stream().map(res -> "##@resource_reference{\"" + res + "\"}").collect(Collectors.joining("\n"));
        referenceResources.stream().forEach(res -> {
            String code = Arrays.stream(StringUtils.split((String)node.getCode(), (String)" ")).map(arg -> arg.contains((CharSequence)res) ? res : arg).collect(Collectors.joining(" "));
            node.setCode(code);
        });
        node.setCode(Joiner.on((String)"\n").join((Object)resReferenceCode, (Object)node.getCode(), new Object[0]).trim());
    }

    private void convertToOdpsSpark(DwWorkflow workflow, DwNode node) {
        SparkSubmitCommandBuilder sparkSubmitCommandBuilder = this.getSparkSubmitCommandBuilder(node.getCode());
        String calcEngineType = "odps";
        List<String> appResources = this.handleResources(workflow, Arrays.asList(sparkSubmitCommandBuilder.getAppResource()), calcEngineType);
        String main = ListUtils.emptyIfNull(appResources).stream().findFirst().orElse("");
        List jars = this.handleResources(workflow, sparkSubmitCommandBuilder.getJars(), calcEngineType).stream().filter(str -> str.endsWith("jar")).collect(Collectors.toList());
        List assistFiles = this.handleResources(workflow, sparkSubmitCommandBuilder.getFiles(), calcEngineType).stream().filter(str -> str.split("\\.").length == 1).collect(Collectors.toList());
        List pyFiles = this.handleResources(workflow, sparkSubmitCommandBuilder.getPyFiles(), calcEngineType).stream().filter(str -> str.endsWith("py")).collect(Collectors.toList());
        List assistArchives = this.handleResources(workflow, sparkSubmitCommandBuilder.getFiles(), calcEngineType).stream().filter(str -> str.split("\\.").length == 2 && ResourceUtils.FILE_EXT_ARCHIVE.contains(str.split("\\.")[1].toLowerCase())).collect(Collectors.toList());
        OdpsSparkCode odpsSparkCode = new OdpsSparkCode();
        ArrayList<String> referenceResources = new ArrayList<String>();
        referenceResources.add(main);
        referenceResources.addAll(this.handleResources(workflow, sparkSubmitCommandBuilder.getJars(), calcEngineType));
        odpsSparkCode.setResourceReferences(referenceResources);
        OdpsSparkCode.CodeJson sparkJson = new OdpsSparkCode.CodeJson();
        sparkJson.setArgs(Joiner.on((String)" ").join(sparkSubmitCommandBuilder.getAppArgs()));
        sparkJson.setAssistFiles(assistFiles);
        sparkJson.setAssistJars(jars);
        sparkJson.setAssistPys(pyFiles);
        sparkJson.setAssistArchives(assistArchives);
        sparkJson.setArchivesName(assistArchives);
        sparkJson.setMainClass(sparkSubmitCommandBuilder.getMainClass());
        if (main.endsWith("jar")) {
            sparkJson.setMainJar(main);
            sparkJson.setLanguage("java");
        }
        if (main.endsWith("py")) {
            sparkJson.setMainPy(main);
            sparkJson.setLanguage("python");
        }
        sparkSubmitCommandBuilder.getConf().put("spark.hadoop.odps.task.major.version", "cupid_v2");
        sparkJson.setConfigs(sparkSubmitCommandBuilder.getConf().entrySet().stream().map(ent -> Joiner.on((String)"=").join(ent.getKey(), ent.getValue(), new Object[0])).collect(Collectors.toList()));
        odpsSparkCode.setSparkJson(sparkJson);
        node.setCode(odpsSparkCode.toString());
        node.setType(CodeProgramType.ODPS_SPARK.name());
    }

    private SparkSubmitCommandBuilder getSparkSubmitCommandBuilder(String code) {
        List<String> args = new ArrayList<String>(Arrays.asList(code.split(" ")).stream().filter(str -> str.trim().length() > 0).map(String::trim).collect(Collectors.toList()));
        if (!args.isEmpty() && SPARK_SUBMIT_PATTERN.matcher((CharSequence)args.get(0)).find()) {
            args = args.subList(1, args.size());
        }
        try {
            SparkSubmitCommandBuilder sparkSubmitCommandBuilder = new SparkSubmitCommandBuilder(args);
            return sparkSubmitCommandBuilder;
        }
        catch (Exception e) {
            LOGGER.warn("code: {}, exception: ", (Object)code, (Object)e);
            return null;
        }
    }

    private List<String> handleResources(DwWorkflow workflow, List<String> files, String calcEngineType) {
        if (workflow == null || CollectionUtils.isEmpty(files)) {
            return Collections.emptyList();
        }
        List resources = CollectionUtils.isEmpty((Collection)workflow.getResources()) ? new ArrayList() : workflow.getResources();
        List resourceNames = resources.stream().map(Resource::getName).collect(Collectors.toList());
        List<String> fileNames = files.stream().map(file -> new File((String)file).getName()).collect(Collectors.toList());
        fileNames.stream().filter(fileName -> !resourceNames.contains(fileName)).forEach(fileName -> this.addPlaceholderResource(workflow, (String)fileName, calcEngineType));
        return fileNames;
    }

    private void addPlaceholderResource(DwWorkflow workflow, String fileName, String calcEngineType) {
        DwResource resource = new DwResource();
        resource.setName(fileName);
        resource.setType(ResourceUtils.getFileResourceType((String)fileName, (String)calcEngineType));
        resource.setOdps(Boolean.valueOf(true));
        String filePath = ResourceUtils.getPlaceholderFile((String)fileName);
        try {
            resource.setLocalPath(new File(filePath).getAbsolutePath());
            resource.setWorkflowRef(workflow);
            workflow.getResources().add(resource);
        }
        catch (Exception e) {
            throw new BizException(ErrorCode.TRANSLATE_NODE_ERROR, (Throwable)e, new Object[0]);
        }
    }
}

