/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.sqoop;

import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DataSyncException;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.ExceptionTracker;
import com.aliyun.migrationx.common.utils.JSONUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DIJsonProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DIJsonProcessor.class);
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("(\\$)\\{?(\\w+)\\}?");
    private Object root = null;

    public static DIJsonProcessor newDefault() {
        return DIJsonProcessor.from("{}");
    }

    public static DIJsonProcessor from(String json) {
        json = DIJsonProcessor.replaceVariable(json);
        DIJsonProcessor.checkJSON(json);
        try {
            return new DIJsonProcessor(json);
        }
        catch (Exception e) {
            throw DataSyncException.asDataSyncException(e.getMessage(), e);
        }
    }

    private static String replaceVariable(String param) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        Matcher matcher = VARIABLE_PATTERN.matcher(param);
        while (matcher.find()) {
            String variable = matcher.group(2);
            String value = System.getProperty(variable);
            if (StringUtils.isBlank((String)value)) {
                value = matcher.group();
            }
            mapping.put(matcher.group(), value);
        }
        String retString = param;
        for (Map.Entry entry : mapping.entrySet()) {
            retString = retString.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return retString;
    }

    public static DIJsonProcessor from(File file) {
        try {
            return DIJsonProcessor.from(IOUtils.toString((InputStream)new FileInputStream(file)));
        }
        catch (FileNotFoundException e) {
            LOGGER.warn(ExceptionTracker.trace(e));
            throw DataSyncException.asDataSyncException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw DataSyncException.asDataSyncException(e.getMessage(), e);
        }
    }

    public static DIJsonProcessor from(InputStream is) {
        try {
            return DIJsonProcessor.from(IOUtils.toString((InputStream)is));
        }
        catch (IOException e) {
            throw DataSyncException.asDataSyncException(e.getMessage(), e);
        }
    }

    public static <T> DIJsonProcessor from(Map<String, T> object) {
        return DIJsonProcessor.from(DIJsonProcessor.toJSONString(object));
    }

    public static <T> DIJsonProcessor from(List<T> object) {
        return DIJsonProcessor.from(DIJsonProcessor.toJSONString(object));
    }

    public String getNecessaryValue(String key) {
        String value = this.getString(key, null);
        if (StringUtils.isBlank((String)value)) {
            throw DataSyncException.asDataSyncException(key + " 's value is blank");
        }
        return value;
    }

    public Object get(String path) {
        this.checkPath(path);
        return this.findObject(path);
    }

    public DIJsonProcessor getConfiguration(String path) {
        Object object = this.get(path);
        if (null == object) {
            return null;
        }
        DIJsonProcessor subJsonProcessor = new DIJsonProcessor(object);
        return subJsonProcessor;
    }

    public String getString(String path) {
        Object string = this.get(path);
        if (null == string) {
            return null;
        }
        return String.valueOf(string);
    }

    public String getString(String path, String defaultValue) {
        String result = this.getString(path);
        if (null == result) {
            return defaultValue;
        }
        return result;
    }

    public Character getChar(String path) {
        String result = this.getString(path);
        if (null == result) {
            return null;
        }
        try {
            return Character.valueOf(CharUtils.toChar((String)result));
        }
        catch (Exception e) {
            LOGGER.warn(ExceptionTracker.trace(e));
            throw DataSyncException.asDataSyncException(e.getMessage(), e);
        }
    }

    public Character getChar(String path, char defaultValue) {
        Character result = this.getChar(path);
        if (null == result) {
            return Character.valueOf(defaultValue);
        }
        return result;
    }

    public Boolean getBool(String path) {
        String result = this.getString(path);
        Boolean nullResult = null;
        if (null == result) {
            return nullResult;
        }
        if ("true".equalsIgnoreCase(result)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(result)) {
            return Boolean.FALSE;
        }
        throw DataSyncException.asDataSyncException("error:" + path + result);
    }

    public Boolean getBool(String path, boolean defaultValue) {
        Boolean result = this.getBool(path);
        if (null == result) {
            return defaultValue;
        }
        return result;
    }

    public Integer getInt(String path) {
        String result = this.getString(path);
        if (null == result) {
            return null;
        }
        try {
            return Integer.valueOf(result);
        }
        catch (Exception e) {
            LOGGER.warn(ExceptionTracker.trace(e));
            throw DataSyncException.asDataSyncException(e.getMessage(), e);
        }
    }

    public Integer getInt(String path, int defaultValue) {
        Integer object = this.getInt(path);
        if (null == object) {
            return defaultValue;
        }
        return object;
    }

    public Long getLong(String path) {
        String result = this.getString(path);
        if (null == result) {
            return null;
        }
        try {
            return Long.valueOf(result);
        }
        catch (Exception e) {
            LOGGER.warn(ExceptionTracker.trace(e));
            throw DataSyncException.asDataSyncException(e.getMessage(), e);
        }
    }

    public Long getLong(String path, long defaultValue) {
        Long result = this.getLong(path);
        if (null == result) {
            return defaultValue;
        }
        return result;
    }

    public Double getDouble(String path) {
        String result = this.getString(path);
        if (null == result) {
            return null;
        }
        try {
            return Double.valueOf(result);
        }
        catch (Exception e) {
            LOGGER.warn(ExceptionTracker.trace(e));
            throw DataSyncException.asDataSyncException(e.getMessage());
        }
    }

    public Double getDouble(String path, double defaultValue) {
        Double result = this.getDouble(path);
        if (null == result) {
            return defaultValue;
        }
        return result;
    }

    public List<Object> getList(String path) {
        List list = this.get(path, List.class);
        if (null == list) {
            return null;
        }
        return list;
    }

    public <T> List<T> getList(String path, Class<T> t) {
        List object = this.get(path, List.class);
        if (null == object) {
            return null;
        }
        ArrayList result = new ArrayList();
        List origin = object;
        for (Object each : origin) {
            result.add(each);
        }
        return result;
    }

    public List<Object> getList(String path, List<Object> defaultList) {
        List<Object> object = this.getList(path);
        if (null == object) {
            return defaultList;
        }
        return object;
    }

    public <T> List<T> getList(String path, List<T> defaultList, Class<T> t) {
        List<T> list = this.getList(path, t);
        if (null == list) {
            return defaultList;
        }
        return list;
    }

    public List<DIJsonProcessor> getListConfiguration(String path) {
        List<Object> lists = this.getList(path);
        if (lists == null) {
            return null;
        }
        ArrayList<DIJsonProcessor> result = new ArrayList<DIJsonProcessor>();
        for (Object object : lists) {
            DIJsonProcessor subJsonProcessor = new DIJsonProcessor(object);
            result.add(subJsonProcessor);
        }
        return result;
    }

    public Map<String, Object> getMap(String path) {
        Map result = this.get(path, Map.class);
        if (null == result) {
            return null;
        }
        return result;
    }

    public <T> Map<String, T> getMap(String path, Class<T> t) {
        Map map = this.get(path, Map.class);
        if (null == map) {
            return null;
        }
        HashMap result = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            result.put((String)entry.getKey(), entry.getValue());
        }
        return result;
    }

    public Map<String, Object> getMap(String path, Map<String, Object> defaultMap) {
        Map<String, Object> object = this.getMap(path);
        if (null == object) {
            return defaultMap;
        }
        return object;
    }

    public <T> Map<String, T> getMap(String path, Map<String, T> defaultMap, Class<T> t) {
        Map<String, T> result = this.getMap(path, t);
        if (null == result) {
            return defaultMap;
        }
        return result;
    }

    public Map<String, DIJsonProcessor> getMapConfiguration(String path) {
        Map map = this.get(path, Map.class);
        if (null == map) {
            return null;
        }
        HashMap<String, DIJsonProcessor> result = new HashMap<String, DIJsonProcessor>();
        for (Map.Entry entry : map.entrySet()) {
            result.put((String)entry.getKey(), DIJsonProcessor.from(DIJsonProcessor.toJSONString(entry.getValue())));
        }
        return result;
    }

    public <T> T get(String path, Class<T> clazz) {
        this.checkPath(path);
        return (T)this.get(path);
    }

    public String beautify() {
        return JSONUtils.toPrettyString((Object)this.getInternal());
    }

    public Object set(String path, Object object) {
        this.checkPath(path);
        Object result = this.get(path);
        this.setObject(path, this.extractConfiguration(object));
        return result;
    }

    public Set<String> getKeys() {
        HashSet<String> collect = new HashSet<String>();
        this.getKeysRecursive(this.getInternal(), "", collect);
        return collect;
    }

    public Set<String> getMapDirectChildrenKeys() {
        Object current = this.getInternal();
        HashSet<String> collect = new HashSet<String>();
        if (current instanceof Map) {
            Map mapping = (Map)current;
            for (Map.Entry entry : mapping.entrySet()) {
                collect.add((String)entry.getKey());
            }
        } else {
            throw DataSyncException.asDataSyncException("your parameter is not map type");
        }
        return collect;
    }

    public Object remove(String path) {
        Object result = this.get(path);
        if (null == result) {
            return null;
        }
        this.set(path, null);
        return result;
    }

    public DIJsonProcessor merge(DIJsonProcessor another, boolean updateWhenConflict) {
        Set<String> keys = another.getKeys();
        for (String key : keys) {
            boolean isCurrentExists;
            if (updateWhenConflict) {
                this.set(key, another.get(key));
                continue;
            }
            boolean bl = isCurrentExists = this.get(key) != null;
            if (isCurrentExists) continue;
            this.set(key, another.get(key));
        }
        return this;
    }

    public boolean containsKey(String path) {
        Object obj = this.get(path);
        return null != obj;
    }

    public boolean isListParameter(String path) {
        return this.get(path) instanceof List;
    }

    public boolean isStringParameter(String path) {
        return this.get(path) instanceof String;
    }

    public String toString() {
        return this.toJSON();
    }

    public String toJSON() {
        return DIJsonProcessor.toJSONString(this.getInternal());
    }

    public DIJsonProcessor copy() {
        return DIJsonProcessor.from(DIJsonProcessor.toJSONString(this.getInternal()));
    }

    void getKeysRecursive(Object current, String path, Set<String> collect) {
        boolean isRegularElement;
        boolean bl = isRegularElement = !(current instanceof Map) && !(current instanceof List);
        if (isRegularElement) {
            collect.add(path);
            return;
        }
        boolean isMap = current instanceof Map;
        if (isMap) {
            Map mapping = (Map)current;
            for (Map.Entry entry : mapping.entrySet()) {
                if (StringUtils.isBlank((String)path)) {
                    this.getKeysRecursive(entry.getValue(), ((String)entry.getKey()).trim(), collect);
                    continue;
                }
                this.getKeysRecursive(entry.getValue(), path + "." + ((String)entry.getKey()).trim(), collect);
            }
            return;
        }
        boolean isList = current instanceof List;
        if (isList) {
            List lists = (List)current;
            for (int i = 0; i < lists.size(); ++i) {
                this.getKeysRecursive(lists.get(i), path + String.format("[%d]", i), collect);
            }
            return;
        }
    }

    public Object getInternal() {
        return this.root;
    }

    public void movePath(String oldKey, String newKey) {
        Object oldValue = this.get(oldKey);
        if (null != oldValue) {
            if ("".equalsIgnoreCase(oldKey)) {
                throw DataSyncException.asDataSyncException("not support root move");
            }
            this.set(newKey, oldValue);
            this.remove(oldKey);
        }
    }

    private void setObject(String path, Object object) {
        Object newRoot = this.setObjectRecursive(this.root, this.split2List(path), 0, object);
        if (this.isSuitForRoot(newRoot)) {
            this.root = newRoot;
            return;
        }
        throw DataSyncException.asDataSyncException(ToStringBuilder.reflectionToString((Object)object));
    }

    private Object extractConfiguration(Object object) {
        if (object instanceof DIJsonProcessor) {
            return this.extractFromConfiguration(object);
        }
        if (object instanceof List) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object each : (List)object) {
                result.add(this.extractFromConfiguration(each));
            }
            return result;
        }
        if (object instanceof Map) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (String key : ((Map)object).keySet()) {
                result.put(key, this.extractFromConfiguration(((Map)object).get(key)));
            }
            return result;
        }
        return object;
    }

    private Object extractFromConfiguration(Object object) {
        if (object instanceof DIJsonProcessor) {
            return ((DIJsonProcessor)object).getInternal();
        }
        return object;
    }

    Object buildObject(List<String> paths, Object object) {
        if (null == paths) {
            throw DataSyncException.asDataSyncException("paths is null");
        }
        if (1 == paths.size() && StringUtils.isBlank((String)paths.get(0))) {
            return object;
        }
        Cloneable child = object;
        for (int i = paths.size() - 1; i >= 0; --i) {
            String path = paths.get(i);
            if (this.isPathMap(path)) {
                HashMap mapping = new HashMap();
                mapping.put(path, child);
                child = mapping;
                continue;
            }
            if (this.isPathList(path)) {
                ArrayList<Object> lists = new ArrayList<Object>(this.getIndex(path) + 1);
                this.expand(lists, this.getIndex(path) + 1);
                lists.set(this.getIndex(path), child);
                child = lists;
                continue;
            }
            throw DataSyncException.asDataSyncException(StringUtils.join(paths, (String)"."));
        }
        return child;
    }

    Object setObjectRecursive(Object current, List<String> paths, int index, Object value) {
        boolean isLastIndex;
        boolean bl = isLastIndex = index == paths.size();
        if (isLastIndex) {
            return value;
        }
        String path = paths.get(index).trim();
        boolean isNeedMap = this.isPathMap(path);
        if (isNeedMap) {
            boolean isCurrentMap = current instanceof Map;
            if (!isCurrentMap) {
                HashMap<String, Object> mapping = new HashMap<String, Object>();
                mapping.put(path, this.buildObject(paths.subList(index + 1, paths.size()), value));
                return mapping;
            }
            Map mapping = (Map)current;
            boolean hasSameKey = mapping.containsKey(path);
            if (!hasSameKey) {
                mapping.put(path, this.buildObject(paths.subList(index + 1, paths.size()), value));
                return mapping;
            }
            current = mapping.get(path);
            mapping.put(path, this.setObjectRecursive(current, paths, index + 1, value));
            return mapping;
        }
        boolean isNeedList = this.isPathList(path);
        if (isNeedList) {
            boolean hasSameIndex;
            int listIndexer = this.getIndex(path);
            boolean isCurrentList = current instanceof List;
            if (!isCurrentList) {
                List<Object> lists = this.expand(new ArrayList<Object>(), listIndexer + 1);
                lists.set(listIndexer, this.buildObject(paths.subList(index + 1, paths.size()), value));
                return lists;
            }
            List<Object> lists = (List<Object>)current;
            boolean bl2 = hasSameIndex = (lists = this.expand(lists, listIndexer + 1)).get(listIndexer) != null;
            if (!hasSameIndex) {
                lists.set(listIndexer, this.buildObject(paths.subList(index + 1, paths.size()), value));
                return lists;
            }
            current = lists.get(listIndexer);
            lists.set(listIndexer, this.setObjectRecursive(current, paths, index + 1, value));
            return lists;
        }
        throw DataSyncException.asDataSyncException("programing error");
    }

    private Object findObject(String path) {
        String each;
        boolean isRootQuery = StringUtils.isBlank((String)path);
        if (isRootQuery) {
            return this.root;
        }
        Object target = this.root;
        Iterator<String> iterator = this.split2List(path).iterator();
        while (iterator.hasNext() && null != (target = this.isPathMap(each = iterator.next()) ? this.findObjectInMap(target, each) : this.findObjectInList(target, each))) {
        }
        return target;
    }

    private Object findObjectInMap(Object target, String index) {
        boolean isMap = target instanceof Map;
        if (!isMap) {
            throw new IllegalArgumentException("not map");
        }
        Object result = ((Map)target).get(index);
        return result;
    }

    private Object findObjectInList(Object target, String each) {
        boolean isList = target instanceof List;
        if (!isList) {
            throw new IllegalArgumentException("not list");
        }
        String index = each.replace("[", "").replace("]", "");
        if (!StringUtils.isNumeric((String)index)) {
            throw new IllegalArgumentException("not number " + index);
        }
        return ((List)target).get(Integer.parseInt(index));
    }

    private List<Object> expand(List<Object> list, int size) {
        int expand = size - list.size();
        while (expand-- > 0) {
            list.add(null);
        }
        return list;
    }

    private boolean isPathList(String path) {
        return path.contains("[") && path.contains("]");
    }

    private boolean isPathMap(String path) {
        return StringUtils.isNotBlank((String)path) && !this.isPathList(path);
    }

    private int getIndex(String index) {
        return Integer.parseInt(index.replace("[", "").replace("]", ""));
    }

    private boolean isSuitForRoot(Object object) {
        return null != object && (object instanceof List || object instanceof Map);
    }

    private String split(String path) {
        return StringUtils.replace((String)path, (String)"[", (String)".[");
    }

    private List<String> split2List(String path) {
        return Arrays.asList(StringUtils.split((String)this.split(path), (String)"."));
    }

    private void checkPath(String path) {
        if (null == path) {
            throw new IllegalArgumentException("path is null");
        }
        for (String each : StringUtils.split((String)".")) {
            if (!StringUtils.isBlank((String)each)) continue;
            throw new IllegalArgumentException(each + " is blank");
        }
    }

    private String toJSONPath(String path) {
        return (StringUtils.isBlank((String)path) ? "$" : "$." + path).replace("$.[", "$[");
    }

    private static void checkJSON(String json) {
        if (StringUtils.isBlank((String)json)) {
            throw new IllegalArgumentException("json is blank");
        }
    }

    private DIJsonProcessor(Object root) {
        this.root = root;
    }

    private DIJsonProcessor(String json) {
        try {
            this.root = JSONUtils.parseObject((String)json, Map.class);
        }
        catch (Exception e) {
            LOGGER.warn(ExceptionTracker.trace(e));
            throw DataSyncException.asDataSyncException(e.getMessage(), e);
        }
    }

    public static DIJsonProcessor filterSensitiveConfiguration(DIJsonProcessor dIJsonProcessor) {
        Set<String> keys = dIJsonProcessor.getKeys();
        for (String key : keys) {
            boolean isSensitive = StringUtils.endsWithIgnoreCase((String)key, (String)"password") || StringUtils.endsWithIgnoreCase((String)key, (String)"accessKey");
            if (!isSensitive || !(dIJsonProcessor.get(key) instanceof String)) continue;
            dIJsonProcessor.set(key, dIJsonProcessor.getString(key).replaceAll(".", "*"));
        }
        return dIJsonProcessor;
    }

    private static String toJSONString(Object object) {
        return JSONUtils.toPrettyString((Object)object);
    }
}

