/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.controller;

import com.aliyun.dataworks.migrationx.transformer.core.annotation.DependsOn;
import com.aliyun.dataworks.migrationx.transformer.core.controller.Task;
import com.aliyun.dataworks.migrationx.transformer.core.controller.TaskStage;
import com.aliyun.dataworks.migrationx.transformer.core.controller.TaskStatus;
import com.aliyun.dataworks.migrationx.transformer.core.report.ReportItem;
import com.aliyun.dataworks.migrationx.transformer.core.report.ReportItemType;
import com.aliyun.dataworks.migrationx.transformer.core.report.ReportRiskLevel;
import com.google.common.base.Joiner;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskDag {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskDag.class);
    private Map<TaskStage, Map<String, AtomTask>> tasks = new ConcurrentHashMap<TaskStage, Map<String, AtomTask>>();
    private Map<String, FutureTask> futureTaskMap = new ConcurrentHashMap<String, FutureTask>();
    private ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 100, 5L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100), new ThreadFactoryBuilder().build());

    public List<Task> getTasks() {
        return this.tasks.values().stream().map(Map::values).flatMap(Collection::stream).map(AtomTask::getTask).collect(Collectors.toList());
    }

    public <T> T getTask(TaskStage taskStage, String name, Class<T> clazz) {
        Map<String, AtomTask> map = this.tasks.get((Object)taskStage);
        if (MapUtils.isEmpty(map)) {
            return null;
        }
        AtomTask atomTask = map.get(name);
        Task task = atomTask.getTask();
        return clazz.cast(task);
    }

    public <T> T getTaskResult(String name) throws ExecutionException, InterruptedException {
        FutureTask futureTask = this.futureTaskMap.get(name);
        if (!futureTask.isDone()) {
            throw new RuntimeException("task " + name + " is still running");
        }
        Task task = (Task)futureTask.get();
        return task.getTemplateParameterType().cast(task.getResult());
    }

    public void registerTask(TaskStage taskStage, Task task) throws Exception {
        if (this.futureTaskMap.containsKey(task.getName())) {
            throw new Exception("task exists: " + task.getName());
        }
        if (!this.tasks.containsKey((Object)taskStage)) {
            this.tasks.put(taskStage, new ConcurrentHashMap(10));
        }
        task.setStage(taskStage);
        this.addTask(taskStage, task);
        task.setTaskDag(this);
    }

    private void handleAnnotationDependsOn() {
        ArrayList<TaskStage> stages = new ArrayList<TaskStage>(Arrays.asList(TaskStage.values()));
        stages.sort(Comparator.reverseOrder());
        stages.stream().forEach(stage -> {
            if (!this.tasks.containsKey(stage)) {
                return;
            }
            this.tasks.get(stage).values().stream().map(AtomTask::getTask).forEach(task -> {
                ArrayList<Field> fields = new ArrayList<Field>();
                this.getFields(fields, task.getClass());
                for (Field field : fields) {
                    field.setAccessible(true);
                    DependsOn anno = field.getDeclaredAnnotation(DependsOn.class);
                    if (anno == null || !Task.class.isAssignableFrom(field.getDeclaringClass())) continue;
                    List candidateTasks = this.getTasks().stream().filter(t -> t.getClass().equals(field.getType()) || t.getClass().equals(field.getGenericType())).collect(Collectors.toList());
                    if (candidateTasks.size() == 1) {
                        this.injectTaskDepend((Task)task, field, (Task)candidateTasks.get(0));
                    }
                    if (candidateTasks.size() > 1 && StringUtils.isBlank((String)anno.qualifier())) {
                        throw new RuntimeException("multi candidate task found by DependsOn: " + field.getType().getName() + ", but without qualifier specified on DependsOn annotation");
                    }
                    if (anno.types() != null && anno.types().length > 0) {
                        ArrayList typesArr = new ArrayList(Arrays.asList(anno.types()));
                        candidateTasks = this.getTasks().stream().filter(t -> typesArr.contains(t.getClass())).collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(candidateTasks)) {
                            Task[] arr = new Task[candidateTasks.size()];
                            candidateTasks.toArray(arr);
                            this.injectTaskDepend((Task)task, field, arr);
                        }
                    }
                    if (!CollectionUtils.isEmpty(candidateTasks)) continue;
                    throw new RuntimeException("no candidate task found by DependsOn: " + field.getType().getName());
                }
            });
        });
    }

    private List<Field> getFields(List<Field> fields, Class<?> clz) {
        if (clz.equals(Task.class)) {
            return fields;
        }
        if (Task.class.isAssignableFrom(clz)) {
            fields.addAll(new ArrayList<Field>(Arrays.asList(clz.getDeclaredFields())));
            return this.getFields(fields, clz.getSuperclass());
        }
        return fields;
    }

    private void injectTaskDepend(Task task, Field field, Task ... candidateTasks) {
        for (Task candidateTask : candidateTasks) {
            task.dependsOn(candidateTask);
        }
        try {
            if (List.class.isAssignableFrom(field.getType())) {
                field.set(task, new ArrayList<Task>(Arrays.asList(candidateTasks)));
            } else {
                field.set(task, candidateTasks[0]);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Task<?> getTaskByName(String name) {
        return this.getTasks().stream().filter(task -> task.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    private void addTask(TaskStage taskStage, Task task) {
        AtomTask atomTask = new AtomTask(task);
        FutureTask<Task> futureTask = new FutureTask<Task>(atomTask);
        this.futureTaskMap.put(task.getName(), futureTask);
        this.tasks.get((Object)taskStage).put(task.getName(), atomTask);
    }

    public void run() throws InterruptedException {
        this.start();
        this.join();
    }

    public void start() {
        this.futureTaskMap.values().forEach(futureTask -> this.threadPoolExecutor.submit((Runnable)futureTask));
    }

    public void init() {
        this.handleTaskStageDepends();
        this.handleAnnotationDependsOn();
    }

    private void handleTaskStageDepends() {
        ArrayList<TaskStage> stages = new ArrayList<TaskStage>(Arrays.asList(TaskStage.values()));
        stages.sort(Comparator.reverseOrder());
        for (int index = 0; index < stages.size() - 1; ++index) {
            int prevIndex = index + 1;
            TaskStage currStage = stages.get(index);
            TaskStage prevStage = stages.get(prevIndex);
            Map<String, AtomTask> curStageTasks = this.tasks.get((Object)currStage);
            Map<String, AtomTask> prevStageTasks = this.tasks.get((Object)prevStage);
            if (MapUtils.isEmpty(curStageTasks) || MapUtils.isEmpty(prevStageTasks)) continue;
            prevStageTasks.values().stream().map(AtomTask::getTask).forEach(prevTask -> curStageTasks.values().stream().map(AtomTask::getTask).forEach(curTask -> curTask.dependsOn((Task<?>)prevTask)));
        }
    }

    public void join() throws InterruptedException {
        this.futureTaskMap.values().forEach(futureTask -> {
            try {
                futureTask.get();
            }
            catch (InterruptedException e) {
                LOGGER.error("{}", (Throwable)e);
            }
            catch (ExecutionException e) {
                LOGGER.error("{}", (Throwable)e);
            }
        });
        LOGGER.info("All tasks completed");
        this.threadPoolExecutor.shutdown();
        this.threadPoolExecutor.awaitTermination(10L, TimeUnit.SECONDS);
    }

    public void print() {
        LOGGER.info("=========================== Task Dag ===========================");
        for (TaskStage stage : TaskStage.values()) {
            LOGGER.info("{}", (Object)stage);
            Map<String, AtomTask> atomTaskMap = this.tasks.get((Object)stage);
            Optional.ofNullable(atomTaskMap).ifPresent(map -> map.values().stream().map(AtomTask::getTask).forEach(task -> {
                List<Task<?>> depends = task.getDependencies();
                LOGGER.info("\t{}, depends: {}", (Object)task.getName(), depends.stream().map(Task::getName).collect(Collectors.toList()));
            }));
        }
        LOGGER.info("======================= Task Dag End ===========================");
    }

    class AtomTask
    implements Callable<Task> {
        private Task task;

        public AtomTask(Task task) {
            this.task = task;
        }

        @Override
        public Task call() throws Exception {
            Thread.currentThread().setName(Joiner.on((String)"-").join((Object)this.task.getName(), (Object)Thread.currentThread().getId(), new Object[0]));
            List<Task<?>> dependencies = this.task.getDependencies();
            this.task.setTaskStatus(TaskStatus.WAITING);
            for (TaskStage taskStage : TaskDag.this.tasks.keySet()) {
                Map map = (Map)TaskDag.this.tasks.get((Object)taskStage);
                for (Task<?> dep : dependencies) {
                    if (!map.containsKey(dep.getName())) continue;
                    AtomTask depTask = (AtomTask)map.get(dep.getName());
                    FutureTask futureTask = (FutureTask)TaskDag.this.futureTaskMap.get(depTask.getTask().getName());
                    futureTask.get();
                }
            }
            try {
                this.task.setTaskStatus(TaskStatus.RUNNING);
                Object res = this.task.call();
                this.task.setTaskStatus(TaskStatus.SUCCESS);
                this.task.setResult(res);
            }
            catch (Throwable e) {
                this.task.setTaskStatus(TaskStatus.FAILURE);
                LOGGER.error("run task {} failed: {}", (Object)this.task.getName(), (Object)e);
                ReportItem report = new ReportItem();
                report.setException(ExceptionUtils.getStackTrace((Throwable)e));
                report.setName(this.task.getName());
                report.setRiskLevel(ReportRiskLevel.ERROR);
                report.setType(ReportItemType.TASK_FAILURE.name());
                report.setMessage(e.getMessage());
                this.task.getReport().add(report);
            }
            return this.task;
        }

        public Task getTask() {
            return this.task;
        }
    }
}

