/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.collector;

import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwResource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Workflow;
import com.aliyun.dataworks.migrationx.transformer.core.common.Constants;
import com.aliyun.dataworks.migrationx.transformer.core.controller.Task;
import com.aliyun.dataworks.migrationx.transformer.core.controller.TaskStage;
import com.aliyun.dataworks.migrationx.transformer.core.loader.ProjectResourceLoader;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class WorkflowCollector
extends Task<List<DwWorkflow>> {
    public WorkflowCollector() {
        super(WorkflowCollector.class.getSimpleName());
    }

    public WorkflowCollector(String name) {
        super(name);
    }

    @Override
    public List<DwWorkflow> call() {
        TaskStage[] stages = TaskStage.values();
        Arrays.sort(stages, Comparator.comparingInt(Enum::ordinal));
        HashMap uuidWorkflowMap = new HashMap(100);
        for (TaskStage stage : stages) {
            this.dependencies.stream().filter(task -> task.getStage().equals((Object)stage)).filter(task -> task.getResult() instanceof List).filter(task -> !CollectionUtils.isEmpty((Collection)((List)task.getResult()))).filter(task -> ((List)task.getResult()).get(0) instanceof DwWorkflow).map(task -> (List)task.getResult()).flatMap(Collection::stream).forEach(dwWorkflow -> uuidWorkflowMap.put(dwWorkflow.getDmObjectUuid(), dwWorkflow));
        }
        List<DwWorkflow> workflows = uuidWorkflowMap.values().stream().collect(Collectors.toList());
        workflows.stream().forEach(workflow -> this.buildNodeCodePath((DwWorkflow)workflow));
        this.dependencies.stream().filter(task -> task instanceof ProjectResourceLoader).findFirst().ifPresent(loader -> {
            ProjectResourceLoader projectResourceLoader = (ProjectResourceLoader)loader;
            List resources = (List)projectResourceLoader.getResult();
            workflows.stream().map(Workflow::getResources).flatMap(Collection::stream).forEach(resource -> resources.stream().forEach(res -> {
                if (res.getName().equals(resource.getName())) {
                    ((DwResource)resource).setLocalPath(res.getLocalPath());
                }
            }));
        });
        return workflows;
    }

    private void buildNodeCodePath(DwWorkflow workflow) {
        for (Node node : workflow.getNodes()) {
            if (!StringUtils.isEmpty((CharSequence)node.getRef())) continue;
            String path = Constants.WORKFLOWS_DIR_PRJ_RELATED + File.separator + workflow.getName() + File.separator + "nodes" + File.separator + node.getName() + File.separator + node.getName();
            node.setRef(path);
        }
    }
}

