/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.oozie.domain;

import java.util.HashMap;
import java.util.Map;

public enum OoziePipeType {
    MAP("map"),
    REDUCE("reduce"),
    INPUTFORMAT("inputformat"),
    PARTITIONER("partitioner"),
    WRITER("writer"),
    PROGRAM("program");

    private final String name;
    private static final Map<String, OoziePipeType> COMMAND_TYPE_MAP;

    private OoziePipeType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static OoziePipeType of(String tagName) {
        if (COMMAND_TYPE_MAP.containsKey(tagName)) {
            return COMMAND_TYPE_MAP.get(tagName);
        }
        throw new IllegalArgumentException("invalid tagName : " + tagName);
    }

    static {
        COMMAND_TYPE_MAP = new HashMap<String, OoziePipeType>();
        for (OoziePipeType ooziePipeType : OoziePipeType.values()) {
            COMMAND_TYPE_MAP.put(ooziePipeType.name, ooziePipeType);
        }
    }
}

