/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian.DITask;
import com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian.DateParser;
import com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian.enums.CDPTypeEnum;
import com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian.enums.ScheduleTypeEnum;
import com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian.enums.ScriptTypeEnum;
import com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian.enums.TaskTypeEnum;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNodeIo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.NodeIo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.CodeModeType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.NodeUseType;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.StringUtils;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaiyunjianTask {
    private static final Logger log = LoggerFactory.getLogger(CaiyunjianTask.class);
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
    private CdfTaskInfo cdfTaskInfo;
    private CdpInfoDO cdpInfoDO;
    private TaskDefineDO taskDefineDO;
    private TaskDetectInfoDo taskDetectInfoDO;
    private Boolean success = Boolean.FALSE;
    private List<String> dirPath;

    public DwNode toNode(String projectName) throws ParseException {
        DwNode dwNode = new DwNode();
        this.getNodeType(dwNode);
        this.convertBasicInfo(dwNode);
        dwNode.setCycleType(Integer.valueOf(ScheduleTypeEnum.toCycleType(this.taskDefineDO.getScheduleType()).getCode()));
        dwNode.setCronExpress(this.taskDefineDO.getScheduleExp());
        this.convertDependent(dwNode, projectName);
        this.success = Boolean.TRUE;
        return dwNode;
    }

    private void getNodeType(DwNode dwNode) {
        String nodeType = "";
        if (TaskTypeEnum.CDP.getCode().equals(this.taskDefineDO.getTaskType())) {
            nodeType = CodeProgramType.DI.name();
            DITask diTask = CaiyunjianTask.toDITask(this.cdpInfoDO);
            JsonObject extend = new JsonObject();
            if (ListUtils.emptyIfNull(diTask.getSteps()).stream().anyMatch(st -> "transformer".equals(st.getCategory()))) {
                extend.addProperty("mode", CodeModeType.CODE.getValue());
            } else {
                extend.addProperty("mode", CodeModeType.WIZARD.getValue());
            }
            diTask.setExtend(extend);
            dwNode.setCode(diTask.toString());
            dwNode.setExtend(GsonUtils.toJsonString((Object)extend));
        } else if (TaskTypeEnum.ODPS.getCode().equals(this.taskDefineDO.getTaskType())) {
            if (ScriptTypeEnum.HIVE.getCode().equals(this.taskDefineDO.getScriptType())) {
                nodeType = CodeProgramType.HIVE.name();
            } else if (ScriptTypeEnum.ODPS.getCode().equals(this.taskDefineDO.getScriptType())) {
                nodeType = CodeProgramType.ODPS_SQL.name();
            } else if (ScriptTypeEnum.SHELL.getCode().equals(this.taskDefineDO.getScriptType())) {
                nodeType = CodeProgramType.DIDE_SHELL.name();
            } else if (ScriptTypeEnum.PERL.getCode().equals(this.taskDefineDO.getScriptType())) {
                nodeType = CodeProgramType.PERL.name();
            } else if (ScriptTypeEnum.PYTHON.getCode().equals(this.taskDefineDO.getScriptType())) {
                nodeType = CodeProgramType.PYODPS.name();
            }
            dwNode.setCode(this.cdfTaskInfo.getFileContent());
        } else if (TaskTypeEnum.NOTIFY.getCode().equals(this.taskDefineDO.getTaskType())) {
            nodeType = CodeProgramType.DIDE_SHELL.name();
            dwNode.setCode(this.cdfTaskInfo.getFileContent());
        } else if (TaskTypeEnum.VIRTUAL.getCode().equals(this.taskDefineDO.getTaskType())) {
            nodeType = CodeProgramType.VIRTUAL.name();
        } else {
            nodeType = CodeProgramType.DIDE_SHELL.name();
            dwNode.setCode(this.cdfTaskInfo.getFileContent());
        }
        dwNode.setType(nodeType);
    }

    public static DITask toDITask(CdpInfoDO cdpInfoDO) {
        String writerType;
        DITask.Step writerStep;
        List<DITask.Step> transformerSteps;
        DITask diTask = new DITask();
        String readerType = CDPTypeEnum.fromCyjType(cdpInfoDO.readerResourceType).getD2DataXType();
        DITask.Step readerStep = CaiyunjianTask.toDIParameter(readerType, cdpInfoDO.getSerializeReaderContext(), "reader");
        if (readerStep != null) {
            diTask.getSteps().add(readerStep);
        }
        if (CollectionUtils.isNotEmpty(transformerSteps = CaiyunjianTask.toTransformers(cdpInfoDO.transformer, readerStep))) {
            diTask.getSteps().addAll(transformerSteps);
        }
        if ((writerStep = CaiyunjianTask.toDIParameter(writerType = CDPTypeEnum.fromCyjType(cdpInfoDO.writerResourceType).getD2DataXType(), cdpInfoDO.getSerializeWriterContext(), "writer")) != null) {
            diTask.getSteps().add(writerStep);
        }
        if (cdpInfoDO.getSerializeSetting() != null) {
            if (cdpInfoDO.getSerializeSetting().getErrorLimit() != null) {
                Integer errorLimit = (int)Math.round(cdpInfoDO.getSerializeSetting().getErrorLimit());
                diTask.getSetting().getErrorLimit().setRecord(errorLimit);
            }
            if (cdpInfoDO.getSerializeSetting().getSpeed() != null && cdpInfoDO.getSerializeSetting().getChannelSpeed() != null && cdpInfoDO.getSerializeSetting().getChannelSpeed() > 0) {
                diTask.getSetting().getSpeed().setThrottle(Boolean.TRUE);
                int concurrent = Math.max(1, (int)(cdpInfoDO.getSerializeSetting().getSpeed() / (double)cdpInfoDO.getSerializeSetting().getChannelSpeed().intValue()));
                diTask.getSetting().getSpeed().setConcurrent(concurrent);
                diTask.getSetting().getSpeed().setMbps(cdpInfoDO.getSerializeSetting().getChannelSpeed());
            }
        }
        CaiyunjianTask.rewriteTaskOrder(diTask);
        return diTask;
    }

    private static void rewriteTaskOrder(DITask diTask) {
        if (CollectionUtils.isEmpty(diTask.getSteps())) {
            return;
        }
        if (diTask.getOrder() == null) {
            return;
        }
        List<DITask.Step> steps = diTask.getSteps();
        DITask.Order order = diTask.getOrder();
        ArrayList<DITask.Order.Hop> hops = new ArrayList<DITask.Order.Hop>();
        for (int i = 0; i < steps.size() - 1; ++i) {
            DITask.Step stepFrom = steps.get(i);
            DITask.Step stepTo = steps.get(i + 1);
            DITask.Order.Hop hop = new DITask.Order.Hop();
            hop.setFrom(stepFrom.getName());
            hop.setTo(stepTo.getName());
            hops.add(hop);
        }
        if (CollectionUtils.isNotEmpty(hops)) {
            order.setHops(hops);
        }
    }

    private static List<DITask.Step> toTransformers(String transformer, DITask.Step readerStep) {
        List transformerJsonArray;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)transformer) && (transformerJsonArray = (List)GsonUtils.fromJsonString((String)transformer, (Type)new TypeToken<List<JsonObject>>(){}.getType())) != null) {
            return transformerJsonArray.stream().map(tr -> CaiyunjianTask.convertTransformer(tr, readerStep)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return null;
    }

    private static DITask.Step convertTransformer(JsonObject t, DITask.Step readerStep) {
        if (!t.has("name")) {
            return null;
        }
        String name = t.get("name").getAsString();
        if ("dx_filter".equals(name)) {
            return CaiyunjianTask.convertDxFilterTransformer(t, readerStep);
        }
        return null;
    }

    private static DITask.Step convertDxFilterTransformer(JsonObject t, DITask.Step readerStep) {
        String name = t.get("name").getAsString();
        JsonArray parameter = t.get("parameter").getAsJsonArray();
        JsonObject stepParameter = new JsonObject();
        if (parameter.size() > 0) {
            JsonObject readerParameter;
            String columnName = parameter.get(0).getAsString();
            if (readerStep.getParameter() != null && (readerParameter = readerStep.getParameter()).has("column")) {
                JsonArray columnArr = readerParameter.get("column").getAsJsonArray();
                Iterator itr = columnArr.iterator();
                int index = 0;
                while (itr.hasNext()) {
                    String col = ((JsonElement)itr.next()).getAsString();
                    if (org.apache.commons.lang3.StringUtils.equals((CharSequence)columnName, (CharSequence)col)) {
                        stepParameter.addProperty("columnIndex", (Number)index);
                        parameter.remove(0);
                        stepParameter.add("paras", (JsonElement)parameter);
                        return new DITask.Step("transformer", stepParameter, name, "transformer");
                    }
                    ++index;
                }
            }
        }
        return null;
    }

    private static DITask.Step toDIParameter(String type, JsonObject parameter, String category) {
        List tableInfos;
        List connections;
        if (parameter == null) {
            return null;
        }
        if (parameter.has("resourceInfo")) {
            JsonObject resourceInfo = parameter.getAsJsonObject("resourceInfo");
            if (null != resourceInfo && resourceInfo.has("resourceName")) {
                parameter.add("datasource", resourceInfo.get("resourceName"));
            }
            if (null != resourceInfo && resourceInfo.has("objectName")) {
                String tableName = resourceInfo.get("objectName").getAsString();
                String[] parts = org.apache.commons.lang3.StringUtils.split((String)tableName, (String)".");
                if (parts != null && parts.length > 1) {
                    tableName = parts[parts.length - 1];
                }
                parameter.addProperty("table", tableName);
            }
        }
        if (parameter.has("writeNode")) {
            String writeMode = parameter.get("writeNode").getAsString();
            if ("insert".equals(writeMode)) {
                parameter.addProperty("writeNode", "insert into");
            } else if ("update".equals(writeMode)) {
                parameter.addProperty("writeNode", "on duplicate key update");
            } else if ("replace".equals(writeMode)) {
                parameter.addProperty("writeNode", "replace into");
            }
        }
        if ("reader".equals(category) && CDPTypeEnum.ODPS.getD2DataXType().equals(type) && parameter.has("partition")) {
            String param = parameter.get("partition").getAsString();
            JsonArray partition = new JsonArray();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)param)) {
                partition.add(param);
            }
            parameter.add("partition", (JsonElement)partition);
        }
        if ("reader".equals(category) && parameter.has("tableInfo") && CDPTypeEnum.MYSQL.getD2DataXType().equalsIgnoreCase(type) && CollectionUtils.isNotEmpty(connections = (tableInfos = (List)GsonUtils.defaultGson.fromJson(parameter.get("tableInfo"), new TypeToken<List<CdpInfoDO.TableInfo>>(){}.getType())).stream().map(tableInfo -> {
            DITask.Connection connection = new DITask.Connection();
            connection.setDatasource(((CdpInfoDO.TableInfo)tableInfo).resourceName);
            connection.setTable(((CdpInfoDO.TableInfo)tableInfo).tableName.split(","));
            return connection;
        }).collect(Collectors.toList()))) {
            parameter.add("connection", GsonUtils.defaultGson.toJsonTree(connections));
            parameter.remove("table");
            parameter.remove("datasource");
            parameter.remove("tableInfo");
        }
        CaiyunjianTask.processGuidTable(parameter);
        CaiyunjianTask.processResourceReader(type, parameter, category);
        CaiyunjianTask.processResourceWriter(type, parameter, category);
        CaiyunjianTask.processColumnInfo(type, parameter, category);
        return new DITask.Step(type, parameter, type, category);
    }

    private static void processResourceReader(String type, JsonObject parameter, String category) {
        if (!"reader".equalsIgnoreCase(category)) {
            return;
        }
        HashSet<CDPTypeEnum> resourceReaderTypes = new HashSet<CDPTypeEnum>(Arrays.asList(CDPTypeEnum.OSS, CDPTypeEnum.SFTP));
        if (resourceReaderTypes.stream().noneMatch(t -> t.getD2DataXType().equalsIgnoreCase(type))) {
            return;
        }
        resourceReaderTypes.stream().filter(t -> t.getD2DataXType().equalsIgnoreCase(type)).findFirst().ifPresent(resType -> {
            switch (resType) {
                case OSS: {
                    String filePrefix;
                    String objectName = parameter.has("objectName") && parameter.get("objectName") != null ? parameter.get("objectName").getAsString() : null;
                    String string = filePrefix = parameter.has("filePrefix") && parameter.get("filePrefix") != null ? parameter.get("filePrefix").getAsString() : null;
                    if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)objectName) || !org.apache.commons.lang3.StringUtils.isNotBlank(filePrefix)) break;
                    String ossObject = Joiner.on((String)"/").join((Object)objectName, (Object)filePrefix, new Object[0]);
                    ossObject = Joiner.on((String)"/").join((Iterable)Arrays.stream(ossObject.split("/")).map(org.apache.commons.lang3.StringUtils::trim).filter(org.apache.commons.lang3.StringUtils::isNotBlank).collect(Collectors.toList()));
                    parameter.addProperty("object", ossObject);
                    break;
                }
                case SFTP: {
                    if (!parameter.has("path") || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)parameter.get("path").getAsString())) break;
                    JsonArray arr = new JsonArray();
                    arr.add(parameter.get("path").getAsString());
                    parameter.add("path", (JsonElement)arr);
                    break;
                }
            }
        });
        CaiyunjianTask.processFieldDelimiter(parameter);
    }

    private static void processColumnInfo(String type, JsonObject parameter, String category) {
        JsonArray d2Columns;
        JsonArray columns;
        if (!parameter.has("columninfoList")) {
            return;
        }
        if ("writer".equals(category)) {
            if (!Arrays.asList(CDPTypeEnum.OSS.getD2DataXType(), CDPTypeEnum.SFTP.getD2DataXType()).contains(type)) {
                return;
            }
            columns = parameter.get("columninfoList").getAsJsonArray();
            d2Columns = new JsonArray();
            Iterator itr = columns.iterator();
            while (itr.hasNext()) {
                Iterator column = ((JsonElement)itr.next()).getAsJsonObject();
                if (!column.has("colIndex")) continue;
                d2Columns.add(String.valueOf(column.get("colIndex").getAsString()));
            }
            parameter.add("column", (JsonElement)d2Columns);
        }
        if ("reader".equals(category)) {
            columns = parameter.get("columninfoList").getAsJsonArray();
            d2Columns = new JsonArray();
            if (Arrays.asList(CDPTypeEnum.OSS.getD2DataXType(), CDPTypeEnum.SFTP.getD2DataXType()).contains(type)) {
                Integer preIndex = null;
                for (JsonElement jsonElement : columns) {
                    Integer index;
                    JsonObject column = jsonElement.getAsJsonObject();
                    JsonObject d2Column = new JsonObject();
                    Integer n = index = column.has("colIndex") ? Integer.valueOf(column.get("colIndex").getAsInt()) : null;
                    if (preIndex != null && index == null) {
                        index = preIndex + 1;
                    }
                    d2Column.addProperty("type", "string");
                    if (column.has("colIndex")) {
                        d2Column.addProperty("name", (Number)index);
                        d2Column.addProperty("index", (Number)index);
                    } else {
                        d2Column.addProperty("index", (Number)index);
                        d2Column.addProperty("value", column.get("name").getAsString());
                        d2Column.addProperty("name", column.get("name").getAsString());
                    }
                    preIndex = index;
                    d2Columns.add((JsonElement)d2Column);
                }
            } else {
                for (JsonElement jsonElement : columns) {
                    JsonObject column = jsonElement.getAsJsonObject();
                    d2Columns.add(String.valueOf(column.get("name").getAsString()));
                }
            }
            parameter.add("column", (JsonElement)d2Columns);
        }
        parameter.remove("columninfoList");
    }

    private static void processResourceWriter(String type, JsonObject parameter, String category) {
        if (!"writer".equalsIgnoreCase(category)) {
            return;
        }
        HashSet<CDPTypeEnum> resourceWriteTypes = new HashSet<CDPTypeEnum>(Arrays.asList(CDPTypeEnum.OSS, CDPTypeEnum.SFTP));
        if (resourceWriteTypes.stream().noneMatch(t -> t.getD2DataXType().equalsIgnoreCase(type))) {
            return;
        }
        String resourceName = parameter.has("resourceName") && parameter.get("resourceName") != null ? parameter.get("resourceName").getAsString() : null;
        parameter.addProperty("datasource", resourceName);
        CDPTypeEnum resourceWriteType = resourceWriteTypes.stream().filter(t -> t.getD2DataXType().equalsIgnoreCase(type)).findFirst().orElse(null);
        CaiyunjianTask.processFieldDelimiter(parameter);
        if (parameter.has("header")) {
            String header = parameter.get("header").getAsString();
            JsonArray headerArr = new JsonArray();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)header)) {
                String[] headers;
                for (String col : headers = org.apache.commons.lang3.StringUtils.split((String)header, (String)",")) {
                    headerArr.add(col);
                }
            }
            parameter.add("header", (JsonElement)headerArr);
        }
        switch (resourceWriteType) {
            case OSS: {
                String filePrefix;
                String objectName = parameter.has("objectName") && parameter.get("objectName") != null ? parameter.get("objectName").getAsString() : null;
                String string = filePrefix = parameter.has("filePrefix") && parameter.get("filePrefix") != null ? parameter.get("filePrefix").getAsString() : null;
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)objectName) || !org.apache.commons.lang3.StringUtils.isNotBlank(filePrefix)) break;
                String ossObject = Joiner.on((String)"/").join((Object)objectName, (Object)filePrefix, new Object[0]);
                ossObject = Joiner.on((String)"/").join((Iterable)Arrays.stream(ossObject.split("/")).map(org.apache.commons.lang3.StringUtils::trim).filter(org.apache.commons.lang3.StringUtils::isNotBlank).collect(Collectors.toList()));
                parameter.addProperty("object", ossObject);
                break;
            }
            case SFTP: {
                String objectName = parameter.has("objectName") && parameter.get("objectName") != null ? parameter.get("objectName").getAsString() : null;
                String filePrefix = parameter.has("filePrefix") && parameter.get("filePrefix") != null ? parameter.get("filePrefix").getAsString() : null;
                parameter.addProperty("fileName", filePrefix);
                parameter.addProperty("path", objectName);
                break;
            }
        }
    }

    private static void processFieldDelimiter(JsonObject parameter) {
        if (!parameter.has("fileFormat")) {
            parameter.addProperty("fileFormat", "text");
        }
        if (parameter.has("fieldDelimiter")) {
            String fieldDelimiter = parameter.get("fieldDelimiter").getAsString();
            String fieldDelimiterOriginal = StringUtils.replaceControlCharacterPrintable((String)fieldDelimiter);
            if (org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)fieldDelimiter)) {
                char delimiter = (char)Integer.parseInt(fieldDelimiter);
                parameter.addProperty("fieldDelimiter", delimiter + "");
                fieldDelimiterOriginal = StringUtils.replaceControlCharacterPrintable((String)(delimiter + ""));
            }
            parameter.addProperty("fieldDelimiterOrigin", fieldDelimiterOriginal);
        }
    }

    private static void processGuidTable(JsonObject parameter) {
        if (parameter.has("guid")) {
            String guid;
            String[] tokens;
            if ((!parameter.has("table") || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)parameter.get("table").getAsString())) && (tokens = org.apache.commons.lang3.StringUtils.split((String)(guid = parameter.get("guid").getAsString()), (String)".")) != null && tokens.length > 0) {
                parameter.addProperty("table", tokens[tokens.length - 1]);
            }
            parameter.remove("guid");
        }
    }

    private void convertBasicInfo(DwNode dwNode) throws ParseException {
        dwNode.setNodeUseType(NodeUseType.SCHEDULED);
        dwNode.setName(this.taskDefineDO.getTaskName().replaceAll(" +", ""));
        dwNode.setPriority(this.taskDefineDO.getPriority());
        dwNode.setIsAutoParse(Integer.valueOf(0));
        if (this.cdfTaskInfo.getStartEffectDate() != null) {
            dwNode.setStartEffectDate(SDF.parse(this.cdfTaskInfo.getStartEffectDate()));
        }
        if (this.cdfTaskInfo.getEndEffectDate() != null) {
            dwNode.setEndEffectDate(SDF.parse(this.cdfTaskInfo.getEndEffectDate()));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.taskDefineDO.parameter)) {
            dwNode.setParameter(DateParser.parse(this.taskDefineDO.parameter));
        }
    }

    private void convertDependent(DwNode dwNode, String workflowName) {
        List parentActivities;
        List inputs = this.cdfTaskInfo.getParentActivities().stream().filter(d -> d.getRelationType() == 0).map(d -> {
            DwNodeIo input = new DwNodeIo();
            input.setParseType(Integer.valueOf(1));
            input.setData(((CdfTaskInfo.ParentActivity)d).name);
            input.setIsDifferentApp(Boolean.valueOf(true));
            return input;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(inputs)) {
            dwNode.getInputs().addAll(inputs);
            NodeIo output = new NodeIo();
            output.setParseType(Integer.valueOf(1));
            output.setData(dwNode.getName());
            dwNode.getOutputs().add(output);
        }
        if (CollectionUtils.isNotEmpty(parentActivities = this.cdfTaskInfo.getParentActivities().stream().filter(d -> d.getRelationType() == 3).collect(Collectors.toList()))) {
            dwNode.setDependentType(this.cdfTaskInfo.getDependentType());
        }
    }

    public CdfTaskInfo getCdfTaskInfo() {
        return this.cdfTaskInfo;
    }

    public CdpInfoDO getCdpInfoDO() {
        return this.cdpInfoDO;
    }

    public TaskDefineDO getTaskDefineDO() {
        return this.taskDefineDO;
    }

    public TaskDetectInfoDo getTaskDetectInfoDO() {
        return this.taskDetectInfoDO;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public List<String> getDirPath() {
        return this.dirPath;
    }

    public void setCdfTaskInfo(CdfTaskInfo cdfTaskInfo) {
        this.cdfTaskInfo = cdfTaskInfo;
    }

    public void setCdpInfoDO(CdpInfoDO cdpInfoDO) {
        this.cdpInfoDO = cdpInfoDO;
    }

    public void setTaskDefineDO(TaskDefineDO taskDefineDO) {
        this.taskDefineDO = taskDefineDO;
    }

    public void setTaskDetectInfoDO(TaskDetectInfoDo taskDetectInfoDO) {
        this.taskDetectInfoDO = taskDetectInfoDO;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public void setDirPath(List<String> dirPath) {
        this.dirPath = dirPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CaiyunjianTask)) {
            return false;
        }
        CaiyunjianTask other = (CaiyunjianTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$success = this.getSuccess();
        Boolean other$success = other.getSuccess();
        if (this$success == null ? other$success != null : !((Object)this$success).equals(other$success)) {
            return false;
        }
        CdfTaskInfo this$cdfTaskInfo = this.getCdfTaskInfo();
        CdfTaskInfo other$cdfTaskInfo = other.getCdfTaskInfo();
        if (this$cdfTaskInfo == null ? other$cdfTaskInfo != null : !((Object)this$cdfTaskInfo).equals(other$cdfTaskInfo)) {
            return false;
        }
        CdpInfoDO this$cdpInfoDO = this.getCdpInfoDO();
        CdpInfoDO other$cdpInfoDO = other.getCdpInfoDO();
        if (this$cdpInfoDO == null ? other$cdpInfoDO != null : !((Object)this$cdpInfoDO).equals(other$cdpInfoDO)) {
            return false;
        }
        TaskDefineDO this$taskDefineDO = this.getTaskDefineDO();
        TaskDefineDO other$taskDefineDO = other.getTaskDefineDO();
        if (this$taskDefineDO == null ? other$taskDefineDO != null : !((Object)this$taskDefineDO).equals(other$taskDefineDO)) {
            return false;
        }
        TaskDetectInfoDo this$taskDetectInfoDO = this.getTaskDetectInfoDO();
        TaskDetectInfoDo other$taskDetectInfoDO = other.getTaskDetectInfoDO();
        if (this$taskDetectInfoDO == null ? other$taskDetectInfoDO != null : !((Object)this$taskDetectInfoDO).equals(other$taskDetectInfoDO)) {
            return false;
        }
        List<String> this$dirPath = this.getDirPath();
        List<String> other$dirPath = other.getDirPath();
        return !(this$dirPath == null ? other$dirPath != null : !((Object)this$dirPath).equals(other$dirPath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CaiyunjianTask;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $success = this.getSuccess();
        result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
        CdfTaskInfo $cdfTaskInfo = this.getCdfTaskInfo();
        result = result * 59 + ($cdfTaskInfo == null ? 43 : ((Object)$cdfTaskInfo).hashCode());
        CdpInfoDO $cdpInfoDO = this.getCdpInfoDO();
        result = result * 59 + ($cdpInfoDO == null ? 43 : ((Object)$cdpInfoDO).hashCode());
        TaskDefineDO $taskDefineDO = this.getTaskDefineDO();
        result = result * 59 + ($taskDefineDO == null ? 43 : ((Object)$taskDefineDO).hashCode());
        TaskDetectInfoDo $taskDetectInfoDO = this.getTaskDetectInfoDO();
        result = result * 59 + ($taskDetectInfoDO == null ? 43 : ((Object)$taskDetectInfoDO).hashCode());
        List<String> $dirPath = this.getDirPath();
        result = result * 59 + ($dirPath == null ? 43 : ((Object)$dirPath).hashCode());
        return result;
    }

    public String toString() {
        return "CaiyunjianTask(cdfTaskInfo=" + this.getCdfTaskInfo() + ", cdpInfoDO=" + this.getCdpInfoDO() + ", taskDefineDO=" + this.getTaskDefineDO() + ", taskDetectInfoDO=" + this.getTaskDetectInfoDO() + ", success=" + this.getSuccess() + ", dirPath=" + this.getDirPath() + ")";
    }

    public static class TaskDefineDO {
        @SerializedName(value="activitytype")
        private String activityType;
        @SerializedName(value="dependenttype")
        private Integer dependentType;
        private String parameter;
        private Integer priority;
        private String scheduleType;
        @SerializedName(value="scheduleexp")
        private String scheduleExp;
        private Integer scriptType;
        private Integer taskType;
        private String taskName;
        private String owner;

        public String getActivityType() {
            return this.activityType;
        }

        public Integer getDependentType() {
            return this.dependentType;
        }

        public String getParameter() {
            return this.parameter;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public String getScheduleType() {
            return this.scheduleType;
        }

        public String getScheduleExp() {
            return this.scheduleExp;
        }

        public Integer getScriptType() {
            return this.scriptType;
        }

        public Integer getTaskType() {
            return this.taskType;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public String getOwner() {
            return this.owner;
        }

        public void setActivityType(String activityType) {
            this.activityType = activityType;
        }

        public void setDependentType(Integer dependentType) {
            this.dependentType = dependentType;
        }

        public void setParameter(String parameter) {
            this.parameter = parameter;
        }

        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        public void setScheduleType(String scheduleType) {
            this.scheduleType = scheduleType;
        }

        public void setScheduleExp(String scheduleExp) {
            this.scheduleExp = scheduleExp;
        }

        public void setScriptType(Integer scriptType) {
            this.scriptType = scriptType;
        }

        public void setTaskType(Integer taskType) {
            this.taskType = taskType;
        }

        public void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public void setOwner(String owner) {
            this.owner = owner;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskDefineDO)) {
                return false;
            }
            TaskDefineDO other = (TaskDefineDO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$dependentType = this.getDependentType();
            Integer other$dependentType = other.getDependentType();
            if (this$dependentType == null ? other$dependentType != null : !((Object)this$dependentType).equals(other$dependentType)) {
                return false;
            }
            Integer this$priority = this.getPriority();
            Integer other$priority = other.getPriority();
            if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
                return false;
            }
            Integer this$scriptType = this.getScriptType();
            Integer other$scriptType = other.getScriptType();
            if (this$scriptType == null ? other$scriptType != null : !((Object)this$scriptType).equals(other$scriptType)) {
                return false;
            }
            Integer this$taskType = this.getTaskType();
            Integer other$taskType = other.getTaskType();
            if (this$taskType == null ? other$taskType != null : !((Object)this$taskType).equals(other$taskType)) {
                return false;
            }
            String this$activityType = this.getActivityType();
            String other$activityType = other.getActivityType();
            if (this$activityType == null ? other$activityType != null : !this$activityType.equals(other$activityType)) {
                return false;
            }
            String this$parameter = this.getParameter();
            String other$parameter = other.getParameter();
            if (this$parameter == null ? other$parameter != null : !this$parameter.equals(other$parameter)) {
                return false;
            }
            String this$scheduleType = this.getScheduleType();
            String other$scheduleType = other.getScheduleType();
            if (this$scheduleType == null ? other$scheduleType != null : !this$scheduleType.equals(other$scheduleType)) {
                return false;
            }
            String this$scheduleExp = this.getScheduleExp();
            String other$scheduleExp = other.getScheduleExp();
            if (this$scheduleExp == null ? other$scheduleExp != null : !this$scheduleExp.equals(other$scheduleExp)) {
                return false;
            }
            String this$taskName = this.getTaskName();
            String other$taskName = other.getTaskName();
            if (this$taskName == null ? other$taskName != null : !this$taskName.equals(other$taskName)) {
                return false;
            }
            String this$owner = this.getOwner();
            String other$owner = other.getOwner();
            return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TaskDefineDO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $dependentType = this.getDependentType();
            result = result * 59 + ($dependentType == null ? 43 : ((Object)$dependentType).hashCode());
            Integer $priority = this.getPriority();
            result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
            Integer $scriptType = this.getScriptType();
            result = result * 59 + ($scriptType == null ? 43 : ((Object)$scriptType).hashCode());
            Integer $taskType = this.getTaskType();
            result = result * 59 + ($taskType == null ? 43 : ((Object)$taskType).hashCode());
            String $activityType = this.getActivityType();
            result = result * 59 + ($activityType == null ? 43 : $activityType.hashCode());
            String $parameter = this.getParameter();
            result = result * 59 + ($parameter == null ? 43 : $parameter.hashCode());
            String $scheduleType = this.getScheduleType();
            result = result * 59 + ($scheduleType == null ? 43 : $scheduleType.hashCode());
            String $scheduleExp = this.getScheduleExp();
            result = result * 59 + ($scheduleExp == null ? 43 : $scheduleExp.hashCode());
            String $taskName = this.getTaskName();
            result = result * 59 + ($taskName == null ? 43 : $taskName.hashCode());
            String $owner = this.getOwner();
            result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
            return result;
        }

        public String toString() {
            return "CaiyunjianTask.TaskDefineDO(activityType=" + this.getActivityType() + ", dependentType=" + this.getDependentType() + ", parameter=" + this.getParameter() + ", priority=" + this.getPriority() + ", scheduleType=" + this.getScheduleType() + ", scheduleExp=" + this.getScheduleExp() + ", scriptType=" + this.getScriptType() + ", taskType=" + this.getTaskType() + ", taskName=" + this.getTaskName() + ", owner=" + this.getOwner() + ")";
        }
    }

    public static class CdpInfoDO {
        private String readerContext;
        private String readerResourceType;
        private String writerContext;
        private String writerResourceType;
        private String setting;
        private Setting serializeSetting;
        private JsonObject serializeReaderContext;
        private JsonObject serializeWriterContext;
        private String transformer;

        public Setting getSerializeSetting() {
            return (Setting)GsonUtils.defaultGson.fromJson(this.setting, new TypeToken<Setting>(){}.getType());
        }

        public JsonObject getSerializeReaderContext() {
            return new JsonParser().parse(this.readerContext).getAsJsonObject();
        }

        public JsonObject getSerializeWriterContext() {
            return new JsonParser().parse(this.writerContext).getAsJsonObject();
        }

        public String getReaderContext() {
            return this.readerContext;
        }

        public String getReaderResourceType() {
            return this.readerResourceType;
        }

        public String getWriterContext() {
            return this.writerContext;
        }

        public String getWriterResourceType() {
            return this.writerResourceType;
        }

        public String getSetting() {
            return this.setting;
        }

        public String getTransformer() {
            return this.transformer;
        }

        public void setReaderContext(String readerContext) {
            this.readerContext = readerContext;
        }

        public void setReaderResourceType(String readerResourceType) {
            this.readerResourceType = readerResourceType;
        }

        public void setWriterContext(String writerContext) {
            this.writerContext = writerContext;
        }

        public void setWriterResourceType(String writerResourceType) {
            this.writerResourceType = writerResourceType;
        }

        public void setSetting(String setting) {
            this.setting = setting;
        }

        public void setSerializeSetting(Setting serializeSetting) {
            this.serializeSetting = serializeSetting;
        }

        public void setSerializeReaderContext(JsonObject serializeReaderContext) {
            this.serializeReaderContext = serializeReaderContext;
        }

        public void setSerializeWriterContext(JsonObject serializeWriterContext) {
            this.serializeWriterContext = serializeWriterContext;
        }

        public void setTransformer(String transformer) {
            this.transformer = transformer;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CdpInfoDO)) {
                return false;
            }
            CdpInfoDO other = (CdpInfoDO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$readerContext = this.getReaderContext();
            String other$readerContext = other.getReaderContext();
            if (this$readerContext == null ? other$readerContext != null : !this$readerContext.equals(other$readerContext)) {
                return false;
            }
            String this$readerResourceType = this.getReaderResourceType();
            String other$readerResourceType = other.getReaderResourceType();
            if (this$readerResourceType == null ? other$readerResourceType != null : !this$readerResourceType.equals(other$readerResourceType)) {
                return false;
            }
            String this$writerContext = this.getWriterContext();
            String other$writerContext = other.getWriterContext();
            if (this$writerContext == null ? other$writerContext != null : !this$writerContext.equals(other$writerContext)) {
                return false;
            }
            String this$writerResourceType = this.getWriterResourceType();
            String other$writerResourceType = other.getWriterResourceType();
            if (this$writerResourceType == null ? other$writerResourceType != null : !this$writerResourceType.equals(other$writerResourceType)) {
                return false;
            }
            String this$setting = this.getSetting();
            String other$setting = other.getSetting();
            if (this$setting == null ? other$setting != null : !this$setting.equals(other$setting)) {
                return false;
            }
            Setting this$serializeSetting = this.getSerializeSetting();
            Setting other$serializeSetting = other.getSerializeSetting();
            if (this$serializeSetting == null ? other$serializeSetting != null : !((Object)this$serializeSetting).equals(other$serializeSetting)) {
                return false;
            }
            JsonObject this$serializeReaderContext = this.getSerializeReaderContext();
            JsonObject other$serializeReaderContext = other.getSerializeReaderContext();
            if (this$serializeReaderContext == null ? other$serializeReaderContext != null : !this$serializeReaderContext.equals(other$serializeReaderContext)) {
                return false;
            }
            JsonObject this$serializeWriterContext = this.getSerializeWriterContext();
            JsonObject other$serializeWriterContext = other.getSerializeWriterContext();
            if (this$serializeWriterContext == null ? other$serializeWriterContext != null : !this$serializeWriterContext.equals(other$serializeWriterContext)) {
                return false;
            }
            String this$transformer = this.getTransformer();
            String other$transformer = other.getTransformer();
            return !(this$transformer == null ? other$transformer != null : !this$transformer.equals(other$transformer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CdpInfoDO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $readerContext = this.getReaderContext();
            result = result * 59 + ($readerContext == null ? 43 : $readerContext.hashCode());
            String $readerResourceType = this.getReaderResourceType();
            result = result * 59 + ($readerResourceType == null ? 43 : $readerResourceType.hashCode());
            String $writerContext = this.getWriterContext();
            result = result * 59 + ($writerContext == null ? 43 : $writerContext.hashCode());
            String $writerResourceType = this.getWriterResourceType();
            result = result * 59 + ($writerResourceType == null ? 43 : $writerResourceType.hashCode());
            String $setting = this.getSetting();
            result = result * 59 + ($setting == null ? 43 : $setting.hashCode());
            Setting $serializeSetting = this.getSerializeSetting();
            result = result * 59 + ($serializeSetting == null ? 43 : ((Object)$serializeSetting).hashCode());
            JsonObject $serializeReaderContext = this.getSerializeReaderContext();
            result = result * 59 + ($serializeReaderContext == null ? 43 : $serializeReaderContext.hashCode());
            JsonObject $serializeWriterContext = this.getSerializeWriterContext();
            result = result * 59 + ($serializeWriterContext == null ? 43 : $serializeWriterContext.hashCode());
            String $transformer = this.getTransformer();
            result = result * 59 + ($transformer == null ? 43 : $transformer.hashCode());
            return result;
        }

        public String toString() {
            return "CaiyunjianTask.CdpInfoDO(readerContext=" + this.getReaderContext() + ", readerResourceType=" + this.getReaderResourceType() + ", writerContext=" + this.getWriterContext() + ", writerResourceType=" + this.getWriterResourceType() + ", setting=" + this.getSetting() + ", serializeSetting=" + this.getSerializeSetting() + ", serializeReaderContext=" + this.getSerializeReaderContext() + ", serializeWriterContext=" + this.getSerializeWriterContext() + ", transformer=" + this.getTransformer() + ")";
        }

        public static class Setting {
            private Integer channelSpeed;
            private Double errorLimit;
            private Double speed;

            public Integer getChannelSpeed() {
                return this.channelSpeed;
            }

            public Double getErrorLimit() {
                return this.errorLimit;
            }

            public Double getSpeed() {
                return this.speed;
            }

            public void setChannelSpeed(Integer channelSpeed) {
                this.channelSpeed = channelSpeed;
            }

            public void setErrorLimit(Double errorLimit) {
                this.errorLimit = errorLimit;
            }

            public void setSpeed(Double speed) {
                this.speed = speed;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Setting)) {
                    return false;
                }
                Setting other = (Setting)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Integer this$channelSpeed = this.getChannelSpeed();
                Integer other$channelSpeed = other.getChannelSpeed();
                if (this$channelSpeed == null ? other$channelSpeed != null : !((Object)this$channelSpeed).equals(other$channelSpeed)) {
                    return false;
                }
                Double this$errorLimit = this.getErrorLimit();
                Double other$errorLimit = other.getErrorLimit();
                if (this$errorLimit == null ? other$errorLimit != null : !((Object)this$errorLimit).equals(other$errorLimit)) {
                    return false;
                }
                Double this$speed = this.getSpeed();
                Double other$speed = other.getSpeed();
                return !(this$speed == null ? other$speed != null : !((Object)this$speed).equals(other$speed));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Setting;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Integer $channelSpeed = this.getChannelSpeed();
                result = result * 59 + ($channelSpeed == null ? 43 : ((Object)$channelSpeed).hashCode());
                Double $errorLimit = this.getErrorLimit();
                result = result * 59 + ($errorLimit == null ? 43 : ((Object)$errorLimit).hashCode());
                Double $speed = this.getSpeed();
                result = result * 59 + ($speed == null ? 43 : ((Object)$speed).hashCode());
                return result;
            }

            public String toString() {
                return "CaiyunjianTask.CdpInfoDO.Setting(channelSpeed=" + this.getChannelSpeed() + ", errorLimit=" + this.getErrorLimit() + ", speed=" + this.getSpeed() + ")";
            }
        }

        public static class TableInfo {
            private String resourceName;
            private String tableName;

            public String getResourceName() {
                return this.resourceName;
            }

            public String getTableName() {
                return this.tableName;
            }

            public void setResourceName(String resourceName) {
                this.resourceName = resourceName;
            }

            public void setTableName(String tableName) {
                this.tableName = tableName;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TableInfo)) {
                    return false;
                }
                TableInfo other = (TableInfo)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$resourceName = this.getResourceName();
                String other$resourceName = other.getResourceName();
                if (this$resourceName == null ? other$resourceName != null : !this$resourceName.equals(other$resourceName)) {
                    return false;
                }
                String this$tableName = this.getTableName();
                String other$tableName = other.getTableName();
                return !(this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName));
            }

            protected boolean canEqual(Object other) {
                return other instanceof TableInfo;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $resourceName = this.getResourceName();
                result = result * 59 + ($resourceName == null ? 43 : $resourceName.hashCode());
                String $tableName = this.getTableName();
                result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
                return result;
            }

            public String toString() {
                return "CaiyunjianTask.CdpInfoDO.TableInfo(resourceName=" + this.getResourceName() + ", tableName=" + this.getTableName() + ")";
            }
        }
    }

    public static class CdfTaskInfo {
        private String activityType;
        private String cronExpression;
        private Integer dependentType;
        private String description;
        private String endEffectDate;
        private String startEffectDate;
        private String param;
        private Integer priority;
        private Long resourceGroupId;
        private String fileContent;
        private List<ParentActivity> parentActivities;

        public String getActivityType() {
            return this.activityType;
        }

        public String getCronExpression() {
            return this.cronExpression;
        }

        public Integer getDependentType() {
            return this.dependentType;
        }

        public String getDescription() {
            return this.description;
        }

        public String getEndEffectDate() {
            return this.endEffectDate;
        }

        public String getStartEffectDate() {
            return this.startEffectDate;
        }

        public String getParam() {
            return this.param;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public Long getResourceGroupId() {
            return this.resourceGroupId;
        }

        public String getFileContent() {
            return this.fileContent;
        }

        public List<ParentActivity> getParentActivities() {
            return this.parentActivities;
        }

        public void setActivityType(String activityType) {
            this.activityType = activityType;
        }

        public void setCronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
        }

        public void setDependentType(Integer dependentType) {
            this.dependentType = dependentType;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setEndEffectDate(String endEffectDate) {
            this.endEffectDate = endEffectDate;
        }

        public void setStartEffectDate(String startEffectDate) {
            this.startEffectDate = startEffectDate;
        }

        public void setParam(String param) {
            this.param = param;
        }

        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        public void setResourceGroupId(Long resourceGroupId) {
            this.resourceGroupId = resourceGroupId;
        }

        public void setFileContent(String fileContent) {
            this.fileContent = fileContent;
        }

        public void setParentActivities(List<ParentActivity> parentActivities) {
            this.parentActivities = parentActivities;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CdfTaskInfo)) {
                return false;
            }
            CdfTaskInfo other = (CdfTaskInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$dependentType = this.getDependentType();
            Integer other$dependentType = other.getDependentType();
            if (this$dependentType == null ? other$dependentType != null : !((Object)this$dependentType).equals(other$dependentType)) {
                return false;
            }
            Integer this$priority = this.getPriority();
            Integer other$priority = other.getPriority();
            if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
                return false;
            }
            Long this$resourceGroupId = this.getResourceGroupId();
            Long other$resourceGroupId = other.getResourceGroupId();
            if (this$resourceGroupId == null ? other$resourceGroupId != null : !((Object)this$resourceGroupId).equals(other$resourceGroupId)) {
                return false;
            }
            String this$activityType = this.getActivityType();
            String other$activityType = other.getActivityType();
            if (this$activityType == null ? other$activityType != null : !this$activityType.equals(other$activityType)) {
                return false;
            }
            String this$cronExpression = this.getCronExpression();
            String other$cronExpression = other.getCronExpression();
            if (this$cronExpression == null ? other$cronExpression != null : !this$cronExpression.equals(other$cronExpression)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$endEffectDate = this.getEndEffectDate();
            String other$endEffectDate = other.getEndEffectDate();
            if (this$endEffectDate == null ? other$endEffectDate != null : !this$endEffectDate.equals(other$endEffectDate)) {
                return false;
            }
            String this$startEffectDate = this.getStartEffectDate();
            String other$startEffectDate = other.getStartEffectDate();
            if (this$startEffectDate == null ? other$startEffectDate != null : !this$startEffectDate.equals(other$startEffectDate)) {
                return false;
            }
            String this$param = this.getParam();
            String other$param = other.getParam();
            if (this$param == null ? other$param != null : !this$param.equals(other$param)) {
                return false;
            }
            String this$fileContent = this.getFileContent();
            String other$fileContent = other.getFileContent();
            if (this$fileContent == null ? other$fileContent != null : !this$fileContent.equals(other$fileContent)) {
                return false;
            }
            List<ParentActivity> this$parentActivities = this.getParentActivities();
            List<ParentActivity> other$parentActivities = other.getParentActivities();
            return !(this$parentActivities == null ? other$parentActivities != null : !((Object)this$parentActivities).equals(other$parentActivities));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CdfTaskInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $dependentType = this.getDependentType();
            result = result * 59 + ($dependentType == null ? 43 : ((Object)$dependentType).hashCode());
            Integer $priority = this.getPriority();
            result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
            Long $resourceGroupId = this.getResourceGroupId();
            result = result * 59 + ($resourceGroupId == null ? 43 : ((Object)$resourceGroupId).hashCode());
            String $activityType = this.getActivityType();
            result = result * 59 + ($activityType == null ? 43 : $activityType.hashCode());
            String $cronExpression = this.getCronExpression();
            result = result * 59 + ($cronExpression == null ? 43 : $cronExpression.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $endEffectDate = this.getEndEffectDate();
            result = result * 59 + ($endEffectDate == null ? 43 : $endEffectDate.hashCode());
            String $startEffectDate = this.getStartEffectDate();
            result = result * 59 + ($startEffectDate == null ? 43 : $startEffectDate.hashCode());
            String $param = this.getParam();
            result = result * 59 + ($param == null ? 43 : $param.hashCode());
            String $fileContent = this.getFileContent();
            result = result * 59 + ($fileContent == null ? 43 : $fileContent.hashCode());
            List<ParentActivity> $parentActivities = this.getParentActivities();
            result = result * 59 + ($parentActivities == null ? 43 : ((Object)$parentActivities).hashCode());
            return result;
        }

        public String toString() {
            return "CaiyunjianTask.CdfTaskInfo(activityType=" + this.getActivityType() + ", cronExpression=" + this.getCronExpression() + ", dependentType=" + this.getDependentType() + ", description=" + this.getDescription() + ", endEffectDate=" + this.getEndEffectDate() + ", startEffectDate=" + this.getStartEffectDate() + ", param=" + this.getParam() + ", priority=" + this.getPriority() + ", resourceGroupId=" + this.getResourceGroupId() + ", fileContent=" + this.getFileContent() + ", parentActivities=" + this.getParentActivities() + ")";
        }

        public static class ParentActivity {
            private String name;
            private Integer relationType;

            public String getName() {
                return this.name;
            }

            public Integer getRelationType() {
                return this.relationType;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setRelationType(Integer relationType) {
                this.relationType = relationType;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ParentActivity)) {
                    return false;
                }
                ParentActivity other = (ParentActivity)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Integer this$relationType = this.getRelationType();
                Integer other$relationType = other.getRelationType();
                if (this$relationType == null ? other$relationType != null : !((Object)this$relationType).equals(other$relationType)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                return !(this$name == null ? other$name != null : !this$name.equals(other$name));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ParentActivity;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Integer $relationType = this.getRelationType();
                result = result * 59 + ($relationType == null ? 43 : ((Object)$relationType).hashCode());
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                return result;
            }

            public String toString() {
                return "CaiyunjianTask.CdfTaskInfo.ParentActivity(name=" + this.getName() + ", relationType=" + this.getRelationType() + ")";
            }
        }
    }

    public static class TaskDetectInfoDo {
        private String expiryAction;
        private String expiryTime;
        private String expiryTimeUnit;
        private Long id;
        private Boolean isDeleted;
        private String setting;
        private Long signMethodId;
        private Integer type;

        public Setting getSetting() {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.setting)) {
                return new Setting();
            }
            Setting settingObj = (Setting)GsonUtils.fromJsonString((String)this.setting, (Type)new TypeToken<Setting>(){}.getType());
            if (settingObj == null) {
                return new Setting();
            }
            return settingObj;
        }

        public String getExpiryAction() {
            return this.expiryAction;
        }

        public String getExpiryTime() {
            return this.expiryTime;
        }

        public String getExpiryTimeUnit() {
            return this.expiryTimeUnit;
        }

        public Long getId() {
            return this.id;
        }

        public Boolean getIsDeleted() {
            return this.isDeleted;
        }

        public Long getSignMethodId() {
            return this.signMethodId;
        }

        public Integer getType() {
            return this.type;
        }

        public void setExpiryAction(String expiryAction) {
            this.expiryAction = expiryAction;
        }

        public void setExpiryTime(String expiryTime) {
            this.expiryTime = expiryTime;
        }

        public void setExpiryTimeUnit(String expiryTimeUnit) {
            this.expiryTimeUnit = expiryTimeUnit;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public void setIsDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
        }

        public void setSetting(String setting) {
            this.setting = setting;
        }

        public void setSignMethodId(Long signMethodId) {
            this.signMethodId = signMethodId;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskDetectInfoDo)) {
                return false;
            }
            TaskDetectInfoDo other = (TaskDetectInfoDo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$id = this.getId();
            Long other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Boolean this$isDeleted = this.getIsDeleted();
            Boolean other$isDeleted = other.getIsDeleted();
            if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
                return false;
            }
            Long this$signMethodId = this.getSignMethodId();
            Long other$signMethodId = other.getSignMethodId();
            if (this$signMethodId == null ? other$signMethodId != null : !((Object)this$signMethodId).equals(other$signMethodId)) {
                return false;
            }
            Integer this$type = this.getType();
            Integer other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
                return false;
            }
            String this$expiryAction = this.getExpiryAction();
            String other$expiryAction = other.getExpiryAction();
            if (this$expiryAction == null ? other$expiryAction != null : !this$expiryAction.equals(other$expiryAction)) {
                return false;
            }
            String this$expiryTime = this.getExpiryTime();
            String other$expiryTime = other.getExpiryTime();
            if (this$expiryTime == null ? other$expiryTime != null : !this$expiryTime.equals(other$expiryTime)) {
                return false;
            }
            String this$expiryTimeUnit = this.getExpiryTimeUnit();
            String other$expiryTimeUnit = other.getExpiryTimeUnit();
            if (this$expiryTimeUnit == null ? other$expiryTimeUnit != null : !this$expiryTimeUnit.equals(other$expiryTimeUnit)) {
                return false;
            }
            Setting this$setting = this.getSetting();
            Setting other$setting = other.getSetting();
            return !(this$setting == null ? other$setting != null : !((Object)this$setting).equals(other$setting));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TaskDetectInfoDo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Boolean $isDeleted = this.getIsDeleted();
            result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
            Long $signMethodId = this.getSignMethodId();
            result = result * 59 + ($signMethodId == null ? 43 : ((Object)$signMethodId).hashCode());
            Integer $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
            String $expiryAction = this.getExpiryAction();
            result = result * 59 + ($expiryAction == null ? 43 : $expiryAction.hashCode());
            String $expiryTime = this.getExpiryTime();
            result = result * 59 + ($expiryTime == null ? 43 : $expiryTime.hashCode());
            String $expiryTimeUnit = this.getExpiryTimeUnit();
            result = result * 59 + ($expiryTimeUnit == null ? 43 : $expiryTimeUnit.hashCode());
            Setting $setting = this.getSetting();
            result = result * 59 + ($setting == null ? 43 : ((Object)$setting).hashCode());
            return result;
        }

        public String toString() {
            return "CaiyunjianTask.TaskDetectInfoDo(expiryAction=" + this.getExpiryAction() + ", expiryTime=" + this.getExpiryTime() + ", expiryTimeUnit=" + this.getExpiryTimeUnit() + ", id=" + this.getId() + ", isDeleted=" + this.getIsDeleted() + ", setting=" + this.getSetting() + ", signMethodId=" + this.getSignMethodId() + ", type=" + this.getType() + ")";
        }

        public static class Setting {
            private Long datasourceId;
            private String datasourceName;
            private String datasourceType;
            private String fileName;
            private String path;

            public Long getDatasourceId() {
                return this.datasourceId;
            }

            public String getDatasourceName() {
                return this.datasourceName;
            }

            public String getDatasourceType() {
                return this.datasourceType;
            }

            public String getFileName() {
                return this.fileName;
            }

            public String getPath() {
                return this.path;
            }

            public void setDatasourceId(Long datasourceId) {
                this.datasourceId = datasourceId;
            }

            public void setDatasourceName(String datasourceName) {
                this.datasourceName = datasourceName;
            }

            public void setDatasourceType(String datasourceType) {
                this.datasourceType = datasourceType;
            }

            public void setFileName(String fileName) {
                this.fileName = fileName;
            }

            public void setPath(String path) {
                this.path = path;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Setting)) {
                    return false;
                }
                Setting other = (Setting)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$datasourceId = this.getDatasourceId();
                Long other$datasourceId = other.getDatasourceId();
                if (this$datasourceId == null ? other$datasourceId != null : !((Object)this$datasourceId).equals(other$datasourceId)) {
                    return false;
                }
                String this$datasourceName = this.getDatasourceName();
                String other$datasourceName = other.getDatasourceName();
                if (this$datasourceName == null ? other$datasourceName != null : !this$datasourceName.equals(other$datasourceName)) {
                    return false;
                }
                String this$datasourceType = this.getDatasourceType();
                String other$datasourceType = other.getDatasourceType();
                if (this$datasourceType == null ? other$datasourceType != null : !this$datasourceType.equals(other$datasourceType)) {
                    return false;
                }
                String this$fileName = this.getFileName();
                String other$fileName = other.getFileName();
                if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
                    return false;
                }
                String this$path = this.getPath();
                String other$path = other.getPath();
                return !(this$path == null ? other$path != null : !this$path.equals(other$path));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Setting;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $datasourceId = this.getDatasourceId();
                result = result * 59 + ($datasourceId == null ? 43 : ((Object)$datasourceId).hashCode());
                String $datasourceName = this.getDatasourceName();
                result = result * 59 + ($datasourceName == null ? 43 : $datasourceName.hashCode());
                String $datasourceType = this.getDatasourceType();
                result = result * 59 + ($datasourceType == null ? 43 : $datasourceType.hashCode());
                String $fileName = this.getFileName();
                result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
                String $path = this.getPath();
                result = result * 59 + ($path == null ? 43 : $path.hashCode());
                return result;
            }

            public String toString() {
                return "CaiyunjianTask.TaskDetectInfoDo.Setting(datasourceId=" + this.getDatasourceId() + ", datasourceName=" + this.getDatasourceName() + ", datasourceType=" + this.getDatasourceType() + ", fileName=" + this.getFileName() + ", path=" + this.getPath() + ")";
            }
        }
    }
}

