/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.transform.di.sqoop.utils;

import com.aliyun.migration.workflow.migration.common.convert.datax2di.DataxType;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqoopCommandUtils {
    private static final Logger log = LoggerFactory.getLogger(SqoopCommandUtils.class);
    public static final String SQOOP_KEYWORD = "sqoop";
    public static final String SQOOP_IMPORT_KEYWORD = "sqoop import";
    public static final String SQOOP_EXPORT_KEYWORD = "sqoop export";

    public static Boolean isImport(String cmd) {
        if (cmd.contains(SQOOP_IMPORT_KEYWORD)) {
            return true;
        }
        if (cmd.contains(SQOOP_EXPORT_KEYWORD)) {
            return false;
        }
        log.warn("cmd.is.not.sqoop.import.cmd");
        return null;
    }

    public static Map<String, String> getRawArgs(String cmd) {
        HashMap<String, String> rawArgs = new HashMap<String, String>();
        String[] args = (" " + (cmd = SqoopCommandUtils.getPureSqoopCommandArgsString(cmd)).trim()).split(" -+");
        if (args.length == 0) {
            return rawArgs;
        }
        for (String arg : args) {
            if (arg.trim().isEmpty()) continue;
            String[] kv = arg.trim().split(" ", 2);
            if (kv.length == 1) {
                rawArgs.put(kv[0], null);
                continue;
            }
            if (kv.length != 2) continue;
            String value = kv[1];
            if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
                value = StringEscapeUtils.unescapeJava((String)value.substring(1, value.length() - 1));
            }
            rawArgs.put(kv[0], value);
        }
        return rawArgs;
    }

    private static String getPureSqoopCommandArgsString(String cmd) {
        if ((cmd = cmd.replaceAll("\\\\\n", " ")).contains(SQOOP_IMPORT_KEYWORD)) {
            return cmd.substring(cmd.indexOf(SQOOP_IMPORT_KEYWORD) + SQOOP_IMPORT_KEYWORD.length());
        }
        if (cmd.contains(SQOOP_EXPORT_KEYWORD)) {
            return cmd.substring(cmd.indexOf(SQOOP_EXPORT_KEYWORD) + SQOOP_EXPORT_KEYWORD.length());
        }
        log.warn("cmd.is.not.sqoop.import.cmd");
        return null;
    }

    public static DataxType getDatabaseTypeFromUrl(String jdbcUrl) {
        String url = jdbcUrl.substring(5);
        if (url.contains("://")) {
            url.substring(0, url.indexOf("://"));
        }
        for (DataxType type : DataxType.values()) {
            if (!url.contains(type.getType())) continue;
            return type;
        }
        return DataxType.DEFAULT;
    }

    public static String getDatabaseFromUrl(String jdbcUrl) {
        try {
            URI uri = new URI(jdbcUrl.substring(5));
            String databaseName = uri.getPath().substring(1);
            return databaseName;
        }
        catch (Exception e) {
            log.warn("jdbcURL\u4e0d\u5408\u6cd5\uff0c\u8bf7\u68c0\u67e5\u5176\u5185\u90e8\u662f\u5426\u6709\u5c40\u90e8\u53d8\u91cf", (Object)e.getMessage());
            return "";
        }
    }

    public static String getLastPartOfPath(String path) {
        File file = new File(path);
        return file.getName();
    }
}

