/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.transform.di.seatunnel.converter;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiDatasourceMappingConfig;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiScriptStep;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiScriptStepParameter;
import com.aliyun.migration.workflow.migration.common.transform.di.module.DiStepTypeHandler;
import com.aliyun.migration.workflow.migration.common.transform.di.seatunnel.utils.SeatunnelUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBC2PolardbConverter
implements DiStepTypeHandler {
    private static final Logger log = LoggerFactory.getLogger(JDBC2PolardbConverter.class);

    @Override
    public DiScriptStep convertToDwSourceStep(DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping config, JSONObject jobParams) {
        return null;
    }

    @Override
    public DiScriptStep convertToDwDestStep(DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping config, JSONObject jobParams) {
        jobParams = jobParams.getJSONArray("sink").getJSONObject(0);
        DiScriptStep destStep = new DiScriptStep();
        destStep.setName("Writer");
        destStep.setStepType("polardb");
        destStep.setCategory("writer");
        DiScriptStepParameter stepParameter = new DiScriptStepParameter();
        stepParameter.setDatasource(config.getTgtName());
        if (jobParams.containsKey("table")) {
            stepParameter.setTable(jobParams.getString("table"));
        }
        stepParameter.setWriteMode("insert");
        if (jobParams.containsKey("query") && (jobParams.getString("query").contains("insert into") || jobParams.getString("query").contains("INSERT INTO"))) {
            stepParameter.setColumn(SeatunnelUtils.getColumnsFromInsertIntoSql(jobParams.getString("query")));
            if (stepParameter.getTable() == null) {
                stepParameter.setTable(SeatunnelUtils.getTableNameFromInsertIntoSql(jobParams.getString("query")));
            }
        } else {
            stepParameter.setColumn(List.of("*"));
            log.warn("jdbc\u6570\u636e\u6e90\u5f53\u524d\u4ec5\u5339\u914d\u4e86query insert into\u8bed\u53e5\uff0c\u5176\u4ed6\u8bed\u53e5\u672a\u5339\u914d");
        }
        stepParameter.setPreSql(new ArrayList<String>());
        if (jobParams.containsKey("data_save_mode") && jobParams.getString("data_save_mode").equals("DROP_DATA")) {
            if (stepParameter.getTable() != null) {
                stepParameter.getPreSql().add("truncate table " + stepParameter.getTable() + ";");
            } else {
                log.warn("jdbc\u6570\u636e\u6e90\u9009\u62e9\u4e86DropData\u6a21\u5f0f\uff0c\u4f46\u89e3\u6790\u4e0d\u5230\u8868\u540d\uff0c\u65e0\u6cd5\u6784\u9020truncate\u8bed\u53e5");
            }
        } else if (jobParams.containsKey("data_save_mode") && jobParams.getString("data_save_mode").equals("CUSTOM_PROCESSING")) {
            if (jobParams.containsKey("custom_sql")) {
                stepParameter.getPreSql().add(jobParams.getString("custom_sql"));
            } else {
                log.warn("jdbc\u6570\u636e\u6e90\u9009\u62e9\u4e86CustomProcessing\u6a21\u5f0f\uff0c\u4f46\u81ea\u5b9a\u4e49sql\u7f3a\u5931\uff0c\u65e0\u6cd5\u6784\u9020\u81ea\u5b9a\u4e49sql");
            }
        }
        if (jobParams.containsKey("batch_size")) {
            stepParameter.setBatchSize(jobParams.getInteger("batch_size"));
        }
        destStep.setParameter(stepParameter);
        return destStep;
    }
}

