/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.transform.di.seatunnel.converter;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiDatasourceMappingConfig;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiScriptStep;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiScriptStepParameter;
import com.aliyun.migration.workflow.migration.common.transform.di.module.DiStepTypeHandler;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Clickhouse2SelectdbConverter
implements DiStepTypeHandler {
    private static final Logger log = LoggerFactory.getLogger(Clickhouse2SelectdbConverter.class);

    @Override
    public DiScriptStep convertToDwSourceStep(DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping config, JSONObject jobParams) {
        return null;
    }

    @Override
    public DiScriptStep convertToDwDestStep(DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping config, JSONObject jobParams) {
        jobParams = jobParams.getJSONArray("sink").getJSONObject(0);
        DiScriptStep destStep = new DiScriptStep();
        destStep.setName("Writer");
        destStep.setStepType("selectdb");
        destStep.setCategory("writer");
        DiScriptStepParameter stepParameter = new DiScriptStepParameter();
        stepParameter.setDatasource(config.getTgtName());
        stepParameter.setTable(jobParams.getString("table"));
        stepParameter.setColumn(List.of("*"));
        stepParameter.setPreSql(new ArrayList<String>());
        if (jobParams.containsKey("data_save_mode") && jobParams.getString("data_save_mode").equals("DROP_DATA")) {
            if (stepParameter.getTable() != null) {
                stepParameter.getPreSql().add("truncate table " + stepParameter.getTable() + ";");
            } else {
                log.warn("jdbc\u6570\u636e\u6e90\u9009\u62e9\u4e86DropData\u6a21\u5f0f\uff0c\u4f46\u89e3\u6790\u4e0d\u5230\u8868\u540d\uff0c\u65e0\u6cd5\u6784\u9020truncate\u8bed\u53e5");
            }
        } else if (jobParams.containsKey("data_save_mode") && jobParams.getString("data_save_mode").equals("CUSTOM_PROCESSING")) {
            if (jobParams.containsKey("custom_sql")) {
                stepParameter.getPreSql().add(jobParams.getString("custom_sql"));
            } else {
                log.warn("jdbc\u6570\u636e\u6e90\u9009\u62e9\u4e86CustomProcessing\u6a21\u5f0f\uff0c\u4f46\u81ea\u5b9a\u4e49sql\u7f3a\u5931\uff0c\u65e0\u6cd5\u6784\u9020\u81ea\u5b9a\u4e49sql");
            }
        }
        if (jobParams.containsKey("bulk_size")) {
            stepParameter.setMaxBatchRows(jobParams.getInteger("bulk_size"));
        }
        destStep.setParameter(stepParameter);
        return destStep;
    }
}

