/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.transform.di.domain;

import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiDatasourceMappingConfig {
    private static final Logger log = LoggerFactory.getLogger(DiDatasourceMappingConfig.class);
    private List<MigrationDatasourceConnectionMapping> connMappingList;

    public DiDatasourceMappingConfig() {
        this.connMappingList = new ArrayList<MigrationDatasourceConnectionMapping>();
    }

    public void addConnectionMapping(MigrationDatasourceConnectionMapping connMapping) {
        this.connMappingList.add(connMapping);
    }

    public void init(BwmConfiguration bwmConfiguration) {
        if (bwmConfiguration == null) {
            this.connMappingList = new ArrayList<MigrationDatasourceConnectionMapping>();
            log.warn("\u6570\u636e\u6e90\u6620\u5c04\u89c4\u5219\u7ec4\u4e3a\u7a7a\uff0cDI\u8f6c\u6362\u53ef\u80fd\u5f02\u5e38");
            return;
        }
        Object diDsMapObj = bwmConfiguration.getMap("self").get("di.datasource.map");
        if (Objects.isNull(diDsMapObj)) {
            this.connMappingList = new ArrayList<MigrationDatasourceConnectionMapping>();
            log.warn("\u6570\u636e\u6e90\u6620\u5c04\u89c4\u5219\u7ec4\u4e3a\u7a7a\uff0cDI\u8f6c\u6362\u53ef\u80fd\u5f02\u5e38");
            return;
        }
        this.connMappingList = (List)BwmJsonUtil.parseObject((String)BwmJsonUtil.toJsonString(diDsMapObj), (TypeReference)new TypeReference<List<MigrationDatasourceConnectionMapping>>(){});
    }

    public void init(String configStr) {
        this.connMappingList = (List)BwmJsonUtil.parseObject((String)BwmJsonUtil.toJsonString((Object)configStr), (TypeReference)new TypeReference<List<MigrationDatasourceConnectionMapping>>(){});
    }

    public DiDatasourceMappingConfig(String configStr) {
        if (configStr == null) {
            this.connMappingList = new ArrayList<MigrationDatasourceConnectionMapping>();
            return;
        }
        this.connMappingList = (List)BwmJsonUtil.parseObject((String)BwmJsonUtil.toJsonString((Object)configStr), (TypeReference)new TypeReference<List<MigrationDatasourceConnectionMapping>>(){});
        if (this.connMappingList == null) {
            this.connMappingList = new ArrayList<MigrationDatasourceConnectionMapping>();
        }
    }

    public MigrationDatasourceConnectionMapping getConnectionMapping(String srcName, String srcDb, String srcId, String srcType, MigrationDatasourceConnectionMapping defaultMapping) {
        MigrationDatasourceConnectionMapping connectionMapping;
        if (StringUtils.isEmpty((String)srcName) && StringUtils.isEmpty((String)srcId)) {
            log.warn("\u67e5\u8be2\u6570\u636e\u6e90\u6620\u5c04\u89c4\u5219\u65f6\uff0c\u8f93\u5165\u4e86\u4e00\u4e2a\u7a7a\u503c\uff0c\u8bf7\u68c0\u67e5\u8282\u70b9\u662f\u5426\u914d\u7f6e\u4e86\u6570\u636e\u6e90");
            if (defaultMapping != null) {
                return defaultMapping;
            }
            return this.getDefaultConnMapping();
        }
        if (this.connMappingList.size() == 0) {
            log.warn("\u6570\u636e\u6e90\u6620\u5c04\u89c4\u5219\u7ec4\u4e3a\u7a7a\uff0c\u8fd4\u56de\u9ed8\u8ba4\u503c");
            if (defaultMapping != null) {
                return defaultMapping;
            }
            return this.getDefaultConnMapping();
        }
        for (MigrationDatasourceConnectionMapping conn : this.connMappingList) {
            if (!Objects.nonNull(conn) || StringUtils.isEmpty((String)srcId) || !srcId.equals(conn.getSrcName())) continue;
            return conn;
        }
        if (!StringUtils.isEmpty((String)srcDb)) {
            for (MigrationDatasourceConnectionMapping conn : this.connMappingList) {
                if (!Objects.nonNull(conn) || StringUtils.isEmpty((String)(srcName + "." + srcDb)) || !(srcName + "." + srcDb).equals(conn.getSrcName())) continue;
                return conn;
            }
        }
        for (MigrationDatasourceConnectionMapping conn : this.connMappingList) {
            if (!Objects.nonNull(conn) || StringUtils.isEmpty((String)srcName) || !srcName.equals(conn.getSrcName())) continue;
            return conn;
        }
        log.warn("\u6570\u636e\u6e90{}, {}, {}\u672a\u627e\u5230\u6620\u5c04\u89c4\u5219\uff0c\u8fd4\u56de\u9ed8\u8ba4\u503c", new Object[]{srcName, srcId, srcType});
        if (defaultMapping != null) {
            return defaultMapping;
        }
        if (!StringUtils.isEmpty((String)srcName)) {
            connectionMapping = new MigrationDatasourceConnectionMapping();
            connectionMapping.setSrcName(srcName);
            connectionMapping.setTgtName(srcName);
            connectionMapping.setSrcType(StringUtils.isEmpty((String)srcType) ? "CUSTOM" : srcType);
            connectionMapping.setTgtType(StringUtils.isEmpty((String)srcType) ? "CUSTOM" : srcType);
            return connectionMapping;
        }
        if (!StringUtils.isEmpty((String)srcId)) {
            connectionMapping = new MigrationDatasourceConnectionMapping();
            connectionMapping.setSrcName(srcId);
            connectionMapping.setTgtName(srcId);
            connectionMapping.setSrcType(StringUtils.isEmpty((String)srcType) ? "CUSTOM" : srcType);
            connectionMapping.setTgtType(StringUtils.isEmpty((String)srcType) ? "CUSTOM" : srcType);
            return connectionMapping;
        }
        return this.getDefaultConnMapping();
    }

    public MigrationDatasourceConnectionMapping getConnectionMapping(String srcName, String srcId, String srcType, MigrationDatasourceConnectionMapping defaultMapping) {
        MigrationDatasourceConnectionMapping connectionMapping;
        if (StringUtils.isEmpty((String)srcName) && StringUtils.isEmpty((String)srcId)) {
            log.warn("\u67e5\u8be2\u6570\u636e\u6e90\u6620\u5c04\u89c4\u5219\u65f6\uff0c\u8f93\u5165\u4e86\u4e00\u4e2a\u7a7a\u503c\uff0c\u8bf7\u68c0\u67e5\u8282\u70b9\u662f\u5426\u914d\u7f6e\u4e86\u6570\u636e\u6e90");
            if (defaultMapping != null) {
                return defaultMapping;
            }
            return this.getDefaultConnMapping();
        }
        if (this.connMappingList.size() == 0) {
            log.warn("\u6570\u636e\u6e90\u6620\u5c04\u89c4\u5219\u7ec4\u4e3a\u7a7a\uff0c\u8fd4\u56de\u9ed8\u8ba4\u503c");
            if (defaultMapping != null) {
                return defaultMapping;
            }
            return this.getDefaultConnMapping();
        }
        for (MigrationDatasourceConnectionMapping conn : this.connMappingList) {
            if (!Objects.nonNull(conn) || StringUtils.isEmpty((String)srcId) || !srcId.equals(conn.getSrcName())) continue;
            return conn;
        }
        for (MigrationDatasourceConnectionMapping conn : this.connMappingList) {
            if (!Objects.nonNull(conn) || StringUtils.isEmpty((String)srcName) || !srcName.equals(conn.getSrcName())) continue;
            return conn;
        }
        log.warn("\u6570\u636e\u6e90{}, {}, {}\u672a\u627e\u5230\u6620\u5c04\u89c4\u5219\uff0c\u8fd4\u56de\u9ed8\u8ba4\u503c", new Object[]{srcName, srcId, srcType});
        if (defaultMapping != null) {
            return defaultMapping;
        }
        if (!StringUtils.isEmpty((String)srcName)) {
            connectionMapping = new MigrationDatasourceConnectionMapping();
            connectionMapping.setSrcName(srcName);
            connectionMapping.setTgtName(srcName);
            connectionMapping.setSrcType(StringUtils.isEmpty((String)srcType) ? "CUSTOM" : srcType);
            connectionMapping.setTgtType(StringUtils.isEmpty((String)srcType) ? "CUSTOM" : srcType);
            return connectionMapping;
        }
        if (!StringUtils.isEmpty((String)srcId)) {
            connectionMapping = new MigrationDatasourceConnectionMapping();
            connectionMapping.setSrcName(srcId);
            connectionMapping.setTgtName(srcId);
            connectionMapping.setSrcType(StringUtils.isEmpty((String)srcType) ? "CUSTOM" : srcType);
            connectionMapping.setTgtType(StringUtils.isEmpty((String)srcType) ? "CUSTOM" : srcType);
            return connectionMapping;
        }
        return this.getDefaultConnMapping();
    }

    public MigrationDatasourceConnectionMapping getConnectionMapping(String srcName, MigrationDatasourceConnectionMapping defaultMapping) {
        if (srcName == null || srcName.length() == 0) {
            log.warn("\u67e5\u8be2\u4e86\u4e00\u4e2a\u540d\u79f0\u4e3a\u7a7a\u7684\u6570\u636e\u6e90\uff0c\u6ce8\u610f\u68c0\u67e5\uff0c\u8fd4\u56de\u9ed8\u8ba4\u503c");
            if (defaultMapping != null) {
                return defaultMapping;
            }
            return this.getDefaultConnMapping();
        }
        if (this.connMappingList.size() == 0) {
            log.warn("\u6570\u636e\u6e90\u6620\u5c04\u89c4\u5219\u7ec4\u4e3a\u7a7a\uff0c\u8fd4\u56de\u9ed8\u8ba4\u503c");
            if (defaultMapping != null) {
                return defaultMapping;
            }
            return this.getDefaultConnMapping();
        }
        for (MigrationDatasourceConnectionMapping conn : this.connMappingList) {
            if (!Objects.nonNull(conn) || !srcName.equals(conn.getSrcName())) continue;
            return conn;
        }
        log.warn("\u672a\u67e5\u8be2\u5230\u540d\u79f0\u4e3a{}\u7684\u6570\u636e\u6e90\uff0c\u8fd4\u56de\u9ed8\u8ba4\u503c", (Object)srcName);
        if (defaultMapping != null) {
            return defaultMapping;
        }
        return this.getDefaultConnMapping();
    }

    private MigrationDatasourceConnectionMapping getDefaultConnMapping() {
        MigrationDatasourceConnectionMapping connectionMapping = new MigrationDatasourceConnectionMapping();
        connectionMapping.setSrcName("default_name");
        connectionMapping.setSrcType("default_type");
        connectionMapping.setTgtName("default_name");
        connectionMapping.setTgtType("default_type");
        return connectionMapping;
    }

    public static class MigrationDatasourceConnectionMapping {
        private String srcName;
        private String srcType;
        private String tgtName;
        private String tgtType;

        public String getSrcName() {
            return this.srcName;
        }

        public String getSrcType() {
            return this.srcType;
        }

        public String getTgtName() {
            return this.tgtName;
        }

        public String getTgtType() {
            return this.tgtType;
        }

        public void setSrcName(String srcName) {
            this.srcName = srcName;
        }

        public void setSrcType(String srcType) {
            this.srcType = srcType;
        }

        public void setTgtName(String tgtName) {
            this.tgtName = tgtName;
        }

        public void setTgtType(String tgtType) {
            this.tgtType = tgtType;
        }
    }
}

