/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.transform.di.datax.converter;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.DIType;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiDatasourceMappingConfig;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiScriptStep;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiScriptStepParameter;
import com.aliyun.migration.workflow.migration.common.transform.di.module.DiStepTypeHandler;
import java.util.List;

public class Mysql2MysqlConverter
implements DiStepTypeHandler {
    @Override
    public DiScriptStep convertToDwSourceStep(DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping config, JSONObject jobParams) {
        JSONObject parameter;
        DiScriptStep sourceStep = new DiScriptStep();
        sourceStep.setName("Reader");
        sourceStep.setStepType(DIType.MYSQL.getStepType());
        sourceStep.setCategory("reader");
        DiScriptStepParameter stepParameter = new DiScriptStepParameter();
        stepParameter.setDatasource(config.getTgtName());
        try {
            parameter = jobParams.getJSONObject("job").getJSONObject("content").getJSONObject("reader").getJSONObject("parameter");
        }
        catch (Exception e) {
            parameter = null;
        }
        if (parameter != null) {
            if (parameter.containsKey("splitPk")) {
                stepParameter.setSplitPk(parameter.getString("splitPk"));
            }
            if (parameter.containsKey("where")) {
                stepParameter.setWhere(parameter.getString("where"));
            }
            if (parameter.containsKey("connection") && !parameter.getJSONArray("connection").isEmpty()) {
                if (parameter.getJSONArray("connection").getJSONObject(0).containsKey("table")) {
                    stepParameter.setTable(parameter.getJSONArray("connection").getJSONObject(0).getJSONArray("table").getString(0));
                }
                if (parameter.getJSONArray("connection").getJSONObject(0).containsKey("querySql")) {
                    stepParameter.setQuerySql(parameter.getJSONArray("connection").getJSONObject(0).getJSONArray("querySql").getString(0));
                }
            }
            if (parameter.containsKey("column")) {
                stepParameter.setColumn((List<?>)parameter.getJSONArray("column"));
            } else {
                stepParameter.setColumn(List.of("*"));
            }
        }
        sourceStep.setParameter(stepParameter);
        return sourceStep;
    }

    @Override
    public DiScriptStep convertToDwDestStep(DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping config, JSONObject jobParams) {
        JSONObject parameter;
        DiScriptStep targetStep = new DiScriptStep();
        targetStep.setName("Writer");
        targetStep.setStepType(DIType.MYSQL.getStepType());
        targetStep.setCategory("writer");
        DiScriptStepParameter stepParameter = new DiScriptStepParameter();
        stepParameter.setDatasource(config.getTgtName());
        try {
            parameter = jobParams.getJSONObject("job").getJSONObject("content").getJSONObject("writer").getJSONObject("parameter");
        }
        catch (Exception e) {
            parameter = null;
        }
        if (parameter != null) {
            JSONObject connection;
            if (parameter.containsKey("column")) {
                stepParameter.setColumn((List<?>)parameter.getJSONArray("column"));
            } else {
                stepParameter.setColumn(List.of("*"));
            }
            if (parameter.containsKey("connection") && (connection = parameter.getJSONArray("connection").getJSONObject(0)).containsKey("table")) {
                stepParameter.setTable(connection.getJSONArray("table").getString(0));
            }
            if (parameter.containsKey("preSql")) {
                stepParameter.setPreSql(parameter.getJSONArray("preSql").toList(String.class, new JSONReader.Feature[0]));
            }
            if (parameter.containsKey("postSql")) {
                stepParameter.setPostSql(parameter.getJSONArray("postSql").toList(String.class, new JSONReader.Feature[0]));
            }
            if (parameter.containsKey("writeMode")) {
                stepParameter.setWriteMode(parameter.getString("writeMode"));
            } else {
                stepParameter.setWriteMode("insert");
            }
            if (parameter.containsKey("batchSize")) {
                stepParameter.setBatchSize(parameter.getInteger("batchSize"));
            } else {
                stepParameter.setBatchSize(256);
            }
        }
        targetStep.setParameter(stepParameter);
        return targetStep;
    }
}

