/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.emr.tools;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.aliyun.securitysdk.SecurityUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import org.apache.commons.io.FileUtils;

public class EmrWebClient {
    private String workspaceId;
    private String endPoint;
    private String cookie;
    private String tempPath;

    public EmrWebClient(String workspaceId, String endPoint, String cookie, String tempPath) {
        this.workspaceId = workspaceId;
        this.endPoint = endPoint;
        this.cookie = cookie;
        this.tempPath = tempPath;
        SecurityUtil.initialize();
    }

    public JSONArray listDataSource() {
        JSONObject jsonObject;
        JSONArray res = new JSONArray();
        do {
            if ((jsonObject = this.listDataSourcePageByPage(1)).getInteger("total") == 0) {
                return res;
            }
            res.addAll((Collection)jsonObject.getJSONArray("totalList"));
        } while (jsonObject.getInteger("totalPage") != jsonObject.getInteger("currentPage"));
        return res;
    }

    public JSONObject listDataSourcePageByPage(Integer pageNo) {
        try {
            String inputLine;
            String urlTemplate = "https://emr-workflow-%s.data.aliyun.com/dolphinscheduler/datasources?workspaceId=%s&pageNo=%s&pageSize=100&searchVal=";
            String urlString = String.format(urlTemplate, this.endPoint, this.workspaceId, String.valueOf(pageNo));
            SecurityUtil.startSSRFNetHookChecking((String)urlString);
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Cookie", this.cookie);
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder content = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
            }
            in.close();
            String res = content.toString();
            JSONObject jsonObject = JSONObject.parseObject((String)res);
            connection.disconnect();
            return jsonObject.getJSONObject("data");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new JSONObject();
        }
    }

    public void downloadAllResource(JSONArray fileResourceArray) {
        for (int i = 0; i < fileResourceArray.size(); ++i) {
            JSONObject jsonObject = (JSONObject)fileResourceArray.get(i);
            if (jsonObject.getBoolean("directory").booleanValue()) continue;
            this.downloadResource(jsonObject.getString("id"), jsonObject.getString("fullName"));
        }
    }

    private void downloadResource(String resourceId, String resourceFullName) {
        try {
            int bytesRead;
            String urlTemplate = "https://emr-workflow-%s.data.aliyun.com/dolphinscheduler/resources/%s/download?workspaceId=%s";
            String urlString = String.format(urlTemplate, this.endPoint, resourceId, this.workspaceId);
            SecurityUtil.startSSRFNetHookChecking((String)urlString);
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Cookie", this.cookie);
            InputStream inputStream = connection.getInputStream();
            File targetFile = new File(this.tempPath, resourceFullName);
            FileUtils.forceMkdir((File)targetFile.getParentFile());
            FileOutputStream outputStream = new FileOutputStream(targetFile);
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            outputStream.close();
            inputStream.close();
            connection.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JSONArray listResource() {
        String rootFolderId = "-1";
        JSONArray res = this.listFileResourceInFolder(rootFolderId);
        return res;
    }

    private JSONArray listFileResourceInFolder(String folderId) {
        JSONObject jsonObject;
        JSONArray res = new JSONArray();
        do {
            if ((jsonObject = this.listFileResourceInFolderPageByPage(folderId, 1)).getInteger("total") == 0) {
                return res;
            }
            res.addAll((Collection)jsonObject.getJSONArray("totalList"));
        } while (jsonObject.getInteger("totalPage") != jsonObject.getInteger("currentPage"));
        if (res.size() > 0) {
            for (int i = 0; i < res.size(); ++i) {
                JSONObject jsonObject2 = (JSONObject)res.get(i);
                if (!jsonObject2.getBoolean("directory").booleanValue()) continue;
                res.addAll((Collection)this.listFileResourceInFolder(jsonObject2.getString("id")));
            }
        }
        return res;
    }

    private JSONObject listFileResourceInFolderPageByPage(String folderId, int pageNo) {
        try {
            String inputLine;
            String urlTemplate = "https://emr-workflow-%s.data.aliyun.com/dolphinscheduler/resources?workspaceId=%s&id=%s&type=FILE&searchVal=&pageNo=%s&pageSize=100";
            String urlString = String.format(urlTemplate, this.endPoint, this.workspaceId, folderId, String.valueOf(pageNo));
            SecurityUtil.startSSRFNetHookChecking((String)urlString);
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Cookie", this.cookie);
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder content = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
            }
            in.close();
            String res = content.toString();
            JSONObject jsonObject = JSONObject.parseObject((String)res);
            connection.disconnect();
            return jsonObject.getJSONObject("data");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new JSONObject();
        }
    }
}

